#ifndef _IOP480_LIB_H_
#define _IOP480_LIB_H_

#ifdef __KERNEL__
    #include "../../../include/kdstdlib.h"
#endif //__KERNEL__
#include "../../../include/windrvr.h"
#include "../../../samples/shared/pci_regs.h"
#include "../../../samples/shared/bits.h"

#ifdef __cplusplus
extern "C" {
#endif

// PLX register definitions 
enum {
    IOP480_DEVINIT    = 0x80,
    IOP480_LAS0RR     = 0xa0,
    IOP480_LAS0BA     = 0xa4,
    IOP480_LAS1RR     = 0xa8,
    IOP480_LAS1BA     = 0xac,
    IOP480_EROMRR     = 0xc0,
    IOP480_EROMBA     = 0xc4,
    IOP480_MBOX0      = 0x180,
    IOP480_MBOX1      = 0x184,
    IOP480_MBOX2      = 0x188,
    IOP480_MBOX3      = 0x18c,
    IOP480_MBOX4      = 0x190,
    IOP480_MBOX5      = 0x194,
    IOP480_MBOX6      = 0x198,
    IOP480_MBOX7      = 0x19c,
    IOP480_P2LDBELL   = 0x1a0,
    IOP480_L2PDBELL   = 0x1a4,
    IOP480_PINTSTAT   = 0x1b0,
    IOP480_PINTENB    = 0x1b4,
    IOP480_LINTSTAT   = 0x1b8,
    IOP480_LINTENB    = 0x1bc,
    IOP480_DMA_MODE   = 0x200,
    IOP480_DMA_CSR    = 0x204,
    IOP480_DMA_COUNT  = 0x208,
    IOP480_DMA_PCILADR= 0x20c,
    IOP480_DMA_PCIHADR= 0x218,
    IOP480_DMA_LOCADR = 0x210,
    IOP480_DMA_DPR    = 0x214,
    IOP480_DMA_THRES  = 0x214,
};

// PLX specific PCI configuration registers
enum {
    IOP480_VPD_ADDR   = 0x5a,
    IOP480_VPD_DATA   = 0x5c,
};

typedef enum
{
    IOP480_DMA_CHANNEL_0 = 0,
    IOP480_DMA_CHANNEL_1 = 1,
} IOP480_DMA_CHANNEL;

typedef enum
{
    IOP480_MODE_BYTE   = 0,
    IOP480_MODE_WORD   = 1,
    IOP480_MODE_DWORD  = 2
} IOP480_MODE;

typedef enum
{
    IOP480_ADDR_REG     = AD_PCI_BAR0,
    IOP480_ADDR_SPACE0  = AD_PCI_BAR1,
    IOP480_ADDR_SPACE1  = AD_PCI_BAR2,
    IOP480_ADDR_SPACE2  = AD_PCI_BAR3,
    IOP480_ADDR_SPACE3  = AD_PCI_BAR4,
    IOP480_ADDR_SPACE4  = AD_PCI_BAR5,
    IOP480_ADDR_EPROM   = AD_PCI_BAR_EPROM
} IOP480_ADDR;

enum { IOP480_RANGE_REG = 0x00000080 };

typedef struct IOP480_DMA_STRUCT *IOP480_DMA_HANDLE;

typedef struct IOP480_STRUCT *IOP480_HANDLE;

typedef struct
{
    DWORD dwCounter;   // number of interrupts received
    DWORD dwLost;      // number of interrupts not yet dealt with
    BOOL fStopped;     // was interrupt disabled during wait
    DWORD dwStatusReg; // value of status register when interrupt occured
} IOP480_INT_RESULT;
typedef void (WINAPI *IOP480_INT_HANDLER)( IOP480_HANDLE hPlx, IOP480_INT_RESULT *intResult);

// options for PLX_Open
enum { IOP480_OPEN_USE_INT =   0x1 };

DWORD IOP480_CountCards (DWORD dwVendorID, DWORD dwDeviceID);
BOOL IOP480_Open (IOP480_HANDLE *phPlx, DWORD dwVendorID, DWORD dwDeviceID, DWORD nCardNum, DWORD dwOptions);
void IOP480_Close (IOP480_HANDLE hPlx);
BOOL IOP480_IsAddrSpaceActive(IOP480_HANDLE hPlx, IOP480_ADDR addrSpace);
void IOP480_GetPciSlot(IOP480_HANDLE hPlx, WD_PCI_SLOT *pPciSlot);

void IOP480_ReadWriteBlockLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
                    DWORD dwBytes, BOOL fIsRead, IOP480_MODE mode);
void IOP480_ReadBlockLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, DWORD dwBytes, IOP480_MODE mode);
void IOP480_WriteBlockLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, DWORD dwBytes, IOP480_MODE mode);
BYTE IOP480_ReadByteLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr);
void IOP480_WriteByteLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr, BYTE data);
WORD IOP480_ReadWordLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr);
void IOP480_WriteWordLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr, WORD data);
DWORD IOP480_ReadDWordLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr);
void IOP480_WriteDWordLocal (IOP480_HANDLE hPlx, DWORD dwLocalAddr, DWORD data);

void IOP480_ReadWriteBlock (IOP480_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, BOOL fIsRead, IOP480_ADDR addrSpace, IOP480_MODE mode);
BYTE IOP480_ReadByte (IOP480_HANDLE hPlx, IOP480_ADDR addrSpace, DWORD dwOffset);
void IOP480_WriteByte (IOP480_HANDLE hPlx, IOP480_ADDR addrSpace, DWORD dwOffset, BYTE data);
WORD IOP480_ReadWord (IOP480_HANDLE hPlx, IOP480_ADDR addrSpace, DWORD dwOffset);
void IOP480_WriteWord (IOP480_HANDLE hPlx, IOP480_ADDR addrSpace, DWORD dwOffset, WORD data);
DWORD IOP480_ReadDWord (IOP480_HANDLE hPlx, IOP480_ADDR addrSpace, DWORD dwOffset);
void IOP480_WriteDWord (IOP480_HANDLE hPlx, IOP480_ADDR addrSpace, DWORD dwOffset, DWORD data);
void IOP480_ReadBlock (IOP480_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                    DWORD dwBytes, IOP480_ADDR addrSpace, IOP480_MODE mode);
void IOP480_WriteBlock (IOP480_HANDLE hPlx, DWORD dwOffset, PVOID buf, 
                     DWORD dwBytes, IOP480_ADDR addrSpace, IOP480_MODE mode);

// interrupt functions
BOOL IOP480_IntIsEnabled (IOP480_HANDLE hPlx);
BOOL IOP480_IntEnable (IOP480_HANDLE hPlx, IOP480_INT_HANDLER funcIntHandler);
void IOP480_IntDisable (IOP480_HANDLE hPlx);

// access registers
DWORD IOP480_ReadReg (IOP480_HANDLE hPlx, DWORD dwReg);
void IOP480_WriteReg (IOP480_HANDLE hPlx, DWORD dwReg, DWORD dwData);

// access PCI configuration registers
DWORD IOP480_ReadPCIReg(IOP480_HANDLE hPlx, DWORD dwReg);
void IOP480_WritePCIReg(IOP480_HANDLE hPlx, DWORD dwReg, DWORD dwData);

// Start DMA to/from card.
// fIsRead - TRUE: read from card to buffer.  FALSE: write from buffer to card
// dwBytes - number of bytes to transfer (must be a multiple of 4)
// mode - local bus width.
// dwLocalAddr - local address on card to write to / read from
// channel - uses channel 0 or 1 of the IOP 480
// buf - the buffer to transfer
IOP480_DMA_HANDLE IOP480_DMAOpen (IOP480_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
    DWORD dwBytes, BOOL fIsRead, IOP480_DMA_CHANNEL dmaChannel);
void IOP480_DMAClose (IOP480_HANDLE hPlx, IOP480_DMA_HANDLE hDma);
void IOP480_DMAStart (IOP480_HANDLE hPlx, IOP480_DMA_HANDLE hDma, BOOL fBlocking);
BOOL IOP480_DMAIsDone (IOP480_HANDLE hPlx, IOP480_DMA_HANDLE hDma);
BOOL IOP480_DMAReadWriteBlock (IOP480_HANDLE hPlx, DWORD dwLocalAddr, PVOID buf, 
    DWORD dwBytes, BOOL fIsRead, IOP480_DMA_CHANNEL dmaChannel);

BOOL IOP480_EEPROMReadWord(IOP480_HANDLE hPlx, DWORD dwOffset, PWORD pwData);
BOOL IOP480_EEPROMWriteWord(IOP480_HANDLE hPlx, DWORD dwOffset, WORD wData);
BOOL IOP480_EEPROMReadDWord(IOP480_HANDLE hPlx, DWORD dwOffset, PDWORD pdwData);
BOOL IOP480_EEPROMWriteDWord(IOP480_HANDLE hPlx, DWORD dwOffset, DWORD dwData);
BOOL IOP480_EEPROMValid(IOP480_HANDLE hPlx);

// this string is set to an error message, if one occurs
extern CHAR IOP480_ErrorString[];

#ifdef __cplusplus
}
#endif

#endif
