////////////////////////////////////////////////////////////////
// File - altera_diag.c
//
// This is a diagnostics application for accessing the ALTERA card.
// Code was generated by Driver Wizard.
// It accesses the hardware via WinDriver functions.
// 
////////////////////////////////////////////////////////////////

#include "../lib/altera_lib.h"
#include "../../../samples/shared/pci_diag_lib.h"
#include <stdio.h>

// input of command from user
static char line[256];

char *ALTERA_GetAddrSpaceName(ALTERA_ADDR addrSpace)
{
    return 
        addrSpace==ALTERA_AD_BAR0 ? "Addr Space BAR0" :
        addrSpace==ALTERA_AD_BAR1 ? "Addr Space BAR1" :
        addrSpace==ALTERA_AD_BAR2 ? "Addr Space BAR2" :
        addrSpace==ALTERA_AD_BAR3 ? "Addr Space BAR3" :
        addrSpace==ALTERA_AD_BAR4 ? "Addr Space BAR4" :
        addrSpace==ALTERA_AD_BAR5 ? "Addr Space BAR5" :
        addrSpace==ALTERA_AD_EPROM ? "EEPROM Addr Space" :
        "Invalid";
}

void ALTERA_AccessRanges(ALTERA_HANDLE hALTERA)
{
    int cmd, cmd2, i;
    DWORD addr, data;
    ALTERA_ADDR ad_sp = 0;
    ALTERA_MODE ad_mode = ALTERA_MODE_DWORD;

    for (; ad_sp<ALTERA_ITEMS && !ALTERA_IsAddrSpaceActive(hALTERA, ad_sp); ad_sp++)
    if (ad_sp==ALTERA_ITEMS)
    {
        printf ("No active memory or IO ranges on board!\n");
        return;
    }

    do
    {
        printf ("Access the board's memory and IO ranges\n");
        printf ("---------------------------------------\n");
        printf ("1. Change active memory space: %s\n",ALTERA_GetAddrSpaceName(ad_sp));
        printf ("2. Toggle active mode: %s\n", 
            ad_mode==ALTERA_MODE_BYTE ? "BYTE (8 bit)" :
            ad_mode==ALTERA_MODE_WORD ? "WORD (16 bit)" : "DWORD (32 bit)");
        printf ("3. Read from board\n");
        printf ("4. Write to board\n");
        printf ("99. Back to main menu\n");
        printf ("\n");
        printf ("Enter option: ");
        cmd = 0;
        gets(line);
        sscanf(line, "%d",&cmd);
        switch (cmd)
        {
        case 1:
            printf ("Choose memory or IO space:\n");
            printf ("--------------------------\n");
            for (i=0; i<ALTERA_ITEMS; i++)
            {
                printf ("%d. %s", i+1, ALTERA_GetAddrSpaceName(i));
                if (!ALTERA_IsAddrSpaceActive(hALTERA, (ALTERA_ADDR) i))
                    printf (" - space not active");
                printf("\n");
            }
            printf ("Enter option: ");
            cmd2 = 99;
            gets(line);
            sscanf(line, "%d",&cmd2);
            if (cmd2>=1 && cmd2<ALTERA_ITEMS+1)
            {
                ad_sp = cmd2-1;
                if (!ALTERA_IsAddrSpaceActive(hALTERA, ad_sp))
                    printf ("Chosen space not active!\n");
            }
            break;
        case 2:
            ad_mode = (ad_mode + 1) % 3;
            break;
        case 3:
            printf ("Enter offset to read from: ");
            gets(line);
            sscanf (line, "%x", &addr);
            switch (ad_mode)
            {
            case ALTERA_MODE_BYTE:
                data = ALTERA_ReadByte(hALTERA, ad_sp, addr);
                break;
            case ALTERA_MODE_WORD:
                data = ALTERA_ReadWord(hALTERA, ad_sp, addr);
                break;
            case ALTERA_MODE_DWORD:
                data = ALTERA_ReadDword(hALTERA, ad_sp, addr);
                break;
            }
            printf ("Value read: %x\n", data);
            break;
        case 4:
            printf ("Enter offset to write to: ");
            gets(line);
            sscanf (line,"%x", &addr);
            printf ("Enter data to write %s: ",
                ad_mode==ALTERA_MODE_BYTE ? "BYTE (8 bit)" :
                ad_mode==ALTERA_MODE_WORD ? "WORD (16 bit)" : "DWORD (32 bit)");
            gets(line);
            sscanf (line, "%x",&data);
            switch (ad_mode)
            {
            case ALTERA_MODE_BYTE:
                ALTERA_WriteByte(hALTERA, ad_sp, addr, (BYTE) data);
                break;
            case ALTERA_MODE_WORD:
                ALTERA_WriteWord(hALTERA, ad_sp, addr, (WORD) data);
                break;
            case ALTERA_MODE_DWORD:
                ALTERA_WriteDword(hALTERA, ad_sp, addr, data);
                break;
            }
            break;
        }
    } while (cmd!=99);
}

void WINAPI ALTERA_IntHandlerRoutine(ALTERA_HANDLE hALTERA, ALTERA_INT_RESULT *intResult)
{
    printf ("Got Int number %d\n", intResult->dwCounter);
}

void ALTERA_EnableDisableInterrupts(ALTERA_HANDLE hALTERA)
{
    int cmd;

    printf ("WARNING!!!\n");
    printf ("----------\n");
    printf ("Your hardware has level sensitive interrupts.\n");
    printf ("You must modify the source code of ALTERA_IntEnable(), in the file altera_lib.c,\n");
    printf ("to acknowledge the interrupt before enabling interrupts.\n");
    printf ("Without this modification, your PC will HANG upon interrupt!\n");
    printf ("\n");

    do
    {
        printf ("Enable / Disable interrupts\n");
        printf ("---------------------------\n");
        printf ("1. %s Int\n", ALTERA_IntIsEnabled(hALTERA) ? "Disable" : "Enable");
        printf ("99. Back to main menu\n");
        printf ("\n");
        printf ("Enter option: ");
        cmd = 0;
        gets(line);
        sscanf(line, "%d",&cmd);
        switch (cmd)
        {
        case 1:
            if (ALTERA_IntIsEnabled(hALTERA))
            {
                printf ("Disabling interrupt Int\n");
                ALTERA_IntDisable(hALTERA);
            }
            else
            {
                printf ("Enabling interrupt Int\n");
                if (!ALTERA_IntEnable(hALTERA, ALTERA_IntHandlerRoutine))
                    printf ("failed enabling interrupt Int\n");
            }
            break;
        }
    } while (cmd!=99);
}

ALTERA_HANDLE ALTERA_LocateAndOpenBoard (DWORD dwVendorID, DWORD dwDeviceID, BOOL fUseInt)
{
    DWORD cards, my_card;
    ALTERA_HANDLE hALTERA = NULL;

    if (dwVendorID==0)
    {
        printf ("Enter VendorID: ");
        gets(line);
        sscanf (line, "%x",&dwVendorID);
        if (dwVendorID==0) return NULL;

        printf ("Enter DeviceID: ");
        gets(line);
        sscanf (line, "%x",&dwDeviceID);
    }
    cards = ALTERA_CountCards (dwVendorID, dwDeviceID);
    if (cards==0)
    {
        printf("%s", ALTERA_ErrorString);
        return NULL;
    }
    else if (cards==1) my_card = 1;
    else
    {
        DWORD i;

        printf("Found %d matching PCI cards\n", cards);
        printf("Select card (1-%d): ", cards);
        i = 0;
        gets(line);
        sscanf (line, "%d",&i);
        if (i>=1 && i <=cards) my_card = i;
        else 
        {
            printf ("Choice out of range\n");
            return NULL;
        }
    }
    if (ALTERA_Open (&hALTERA, dwVendorID, dwDeviceID, my_card - 1, fUseInt ? ALTERA_OPEN_USE_INT : 0 ))
        printf ("ALTERA PCI card found!\n");
    else printf ("%s", ALTERA_ErrorString);
    return hALTERA;
}

int main(int argc, char *argv[])
{
    int cmd;
    ALTERA_HANDLE hALTERA = NULL;
    HANDLE hWD;
    BOOL fUseInt = FALSE; // by default - do not install interrupts
    BOOL fOpenedWithInt = fUseInt;

    printf ("ALTERA diagnostic utility.\n");
    printf ("Application accesses hardware using " WD_PROD_NAME ".\n");

    // make sure WinDriver is loaded
    if (!PCI_Get_WD_handle(&hWD)) return 0;
    WD_Close (hWD);

    if (ALTERA_DEFAULT_VENDOR_ID)
        hALTERA = ALTERA_LocateAndOpenBoard(ALTERA_DEFAULT_VENDOR_ID, ALTERA_DEFAULT_DEVICE_ID, fUseInt);

    do
    {
        printf ("\n");
        printf ("ALTERA main menu\n");
        printf ("-------------------\n");
        printf ("1. Scan PCI bus\n");
        printf ("2. Set opening board %s interrupts\n", fUseInt ? "without" : "with");
        printf ("3. Locate/Choose ALTERA board (%s interrupts)\n", fUseInt ? "with" : "without");
        if (hALTERA)
        {
            printf ("4. PCI configuration registers\n");
            printf ("6. Access ALTERA memory and IO ranges\n");
            if (fOpenedWithInt)
                printf ("7. Enable / Disable interrupts\n");
        }
        printf ("99. Exit\n");
        printf ("Enter option: ");
        cmd = 0;
        gets(line);
        sscanf(line, "%d",&cmd);
        switch (cmd)
        {
        case 1: // Scan PCI bus
            PCI_Print_all_cards_info();
            break;
        case 2: // Set opening board with / without interrupts
            fUseInt = !fUseInt;
            break;
        case 3: // Locate ALTERA board
            if (hALTERA) ALTERA_Close(hALTERA);
            hALTERA = ALTERA_LocateAndOpenBoard(0, 0, fUseInt);
            if (!hALTERA) printf ("ALTERA card open failed!\n");
            fOpenedWithInt = fUseInt;
            break;
        case 4: // PCI configuration registers
            if (hALTERA)
            {
                WD_PCI_SLOT pciSlot;
                ALTERA_GetPciSlot(hALTERA, &pciSlot);
                PCI_EditConfigReg(pciSlot);
                break;
            }
        case 6: // Access ALTERA memory and IO ranges
            if (hALTERA) ALTERA_AccessRanges(hALTERA);
            break;
        case 7: // Enable / Disable interrupts
            if (hALTERA && fOpenedWithInt)
                ALTERA_EnableDisableInterrupts(hALTERA);
            break;
        }
    } while (cmd!=99);

    if (hALTERA) ALTERA_Close(hALTERA);

    return 0;
}
