/* printf.c (emx+gcc) */

/* As this program tests a lot of borderline cases and cases of
   `undefined behavior' of printf(), GCC displays many warning
   messages.  Ignore them. */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>

static double inf = 1.0 / 0.0;
static double nan = 0.0 / 0.0;

#if defined (__IBMCPP__)
#define alloca _alloca
#endif

#define CHECK(X) do { if ((X) == EOF) abort(); } while (0)

static void test_printf (char type, const char *fmt, ...)
{

  va_list arg_ptr;
  char *p, *q;

  p = alloca (strlen (fmt) + 1);
  strcpy (p, fmt);
  for (q = p; *q != 0; ++q)
    if (*q == '?')
      *q = type;
  va_start (arg_ptr, fmt);
  CHECK (vprintf (p, arg_ptr));
  va_end (arg_ptr);
}


static void test_float (char type)
{
  CHECK (printf ("------ %c\n", type));
  test_printf (type, "%?|%#?|%15?|%15.3?|\n", 0.0, 0.0, 0.0, 0.0);
  test_printf (type, "%+15.3?|%015.3?|%#?|%-15?|\n", 0.0, 0.0, 0.0, 0.0);
  test_printf (type, "%.0?|%15.0?|%#15.0?|\n", 0.0, 0.0, 0.0);
  test_printf (type, "%?|%3.2?|\n", -0.0, -0.0);
  test_printf (type, "%?|%+?|%010?|% ?|%-10?|\n", inf, inf, inf, inf, inf);
  test_printf (type, "%?|%+?|%010?|% ?|%-10?|\n", -inf, -inf, -inf, -inf, -inf);
  test_printf (type, "%?|%+?|%010?|% ?|%-10?|\n", nan, nan, nan, nan, nan);
  type = toupper (type);
  test_printf (type, "%?|%?|%?|%?|%?|\n", 0.01, 0.1, 1.0, 10.0, 100.0);
  test_printf (type, "%.0?|%.1?|%.2?|%.3?|%.4?|%.5?|\n",
               0.9999, 0.9999, 0.9999, 0.9999, 0.9999, 0.9999);
  test_printf (type, "%.3?|%.3?|%.3?|%.3?|\n",
               1.23449, 1.234500001, 2.3449, 2.34500001);
  test_printf (type, "%?|%?|%?|\n", inf, -inf, nan);
  test_printf (type, "%12.2?|%012.2?|%12.2?|%012.2?|%012.2?|\n",
               0.2, 0.2, -0.2, -0.2, 0.0);
  test_printf (type, "%.2?|%.2?|%.2?|%.2?|%.2?|%.2?|\n",
               0.124, 0.125, 0.125001, 0.874, 0.875, 0.875001);
  test_printf (type, "%.1?|%.1?|%.1?|%.1?|%.1?|%.1?|\n",
               0.74, 0.75, 0.75001, 0.24, 0.25, 0.25001);
  test_printf (type, "%.2?|%.2?|%.2?|%.2?|%.2?|\n", 0.1, 0.2, 0.5, 0.501, 0.9);
  test_printf (type, "%.1?|%.1?|%.1?|%.1?|%.1?|\n", 0.1, 0.2, 0.5, 0.501, 0.9);
  test_printf (type, "%.0?|%.0?|%.0?|%.0?|%.0?|\n", 0.1, 0.2, 0.5, 0.501, 0.9);
}


static void test_g (double x)
{
  CHECK (printf ("%g|%.0g|%.1g|%.2g|%.3g|%.4g|\n", x, x, x, x, x, x));
  CHECK (printf ("%#g|%#.0g|%#.1g|%#.2g|%#.3g|%#.4g|\n", x, x, x, x, x, x));
}

int main (int argc, char *argv[])
{
  if (argc == 2 && strcmp (argv[1], "-nb") == 0)
    setvbuf (stdout, NULL, _IONBF, 0);
  else if (argc != 1)
    {
      puts ("Usage: printf [-nb]");
      return 1;
    }

  CHECK (printf (""));
  CHECK (printf ("x%"));
  CHECK (printf ("x%%y"));
  CHECK (printf ("a%999bc\n"));

  CHECK (printf ("%s|\n", NULL));
  CHECK (printf ("%2s|\n", NULL));
  CHECK (printf ("%10s|\n", NULL));
  CHECK (printf ("%.0s|\n", NULL));
  CHECK (printf ("%.2s|\n", NULL));
  CHECK (printf ("%.10s|\n", NULL));
  CHECK (printf ("%10.0s|\n", NULL));
  CHECK (printf ("%10.2s|\n", NULL));
  CHECK (printf ("%10.10s|\n", NULL));

  CHECK (printf ("%s|%s|%10s|%2s|%.2s|%10.2s|%-10s|%+5s|%#5s|% 5s|\n",
                 "", "abc", "abc", "abc", "abc", "abc",
                 "abc", "abc", "abc", "abc"));
  CHECK (printf ("%05s|%-05s|%*.*s|%*.*s|%.2s|\n",
                 "abc", "abc", 5, 2, "abc", -5, 2, "abc", "a"));

  CHECK (printf ("%c|%3c|%3.1c|%3.0c|%-3c|%03c|%-03c|%#3c|% 3c|%+3c|\n",
                 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'));

  CHECK (printf ("%d|%5d|%-5d|%5.3d|%-5.3d|%05d|%-05d|%05.3d|%3.0d|%3.0d|\n",
                 12, 12, 12, 12, 12, 12, 12, 12, 12, 0));
  CHECK (printf ("%+d|%+d|%+5d|%+05d|%#5d|% 05d|% 08.3d|\n",
                 12, -12, 12, -12, 12, 12, 12));
  CHECK (printf ("%o|%.0o|%.1o|%.2o|%.3o|%.4o|\n", 0, 0, 0, 0, 0, 0));
  CHECK (printf ("%#o|%#.0o|%#.1o|%#.2o|%#.3o|%#.4o|\n", 0, 0, 0, 0, 0, 0));
  CHECK (printf ("%o|%.0o|%.1o|%.2o|%.3o|%.4o|\n", 12, 12, 12, 12, 12, 12));
  CHECK (printf ("%#o|%#.0o|%#.1o|%#.2o|%#.3o|%#.4o|\n",
                 12, 12, 12, 12, 12, 12));
  CHECK (printf ("%x|%.0x|%.1x|%.2x|%.3x|%.4x|\n", 0, 0, 0, 0, 0, 0));
  CHECK (printf ("%#x|%#.0x|%#.1x|%#.2x|%#.3x|%#.4x|\n", 0, 0, 0, 0, 0, 0));
  CHECK (printf ("%x|%.0x|%.1x|%.2x|%.3x|%.4x|\n", 12, 12, 12, 12, 12, 12));
  CHECK (printf ("%#x|%#.0x|%#.1x|%#.2x|%#.3x|%#.4x|\n",
                 12, 12, 12, 12, 12, 12));
  test_float ('e');
  test_float ('f');
  test_float ('g');

  test_g (12.34567);
  test_g (0.01);
  test_g (3.4);
  test_g (0.0);

  if (fflush (stdout) != 0)
    abort ();

  return 0;
}
