/*--------------------------------------------------------------*/
/* Visual Yacc++ REXX function                                  */
/*                                                              */
/* Note - If you changed the default directory when you         */
/*        installed Visual Parse++, you must change the         */
/*        SSDll variable to reflect that change.                */
/*                                                              */
/*--------------------------------------------------------------*/

arg expr

numeric digits 12

SSDll = 'SSVPREXX'
call RxFuncAdd 'SSLoadRexxFunctions', SSDll, 'SSLoadRexxFunctions'
call SSLoadRexxFunctions SSDll

signal on error name SSTerminate
signal on syntax name SSTerminate
signal on failure name SSTerminate

ALexEnd         = 4
ALexPlus        = 5
ALexMinus       = 6
ALexDiv         = 7
ALexMult        = 8
ALexMod         = 9
ALexPow         = 10
ALexOr          = 11
ALexAnd         = 12
ALexNot         = 13
ALexOParen      = 14
ALexCParen      = 15
ALexDec         = 16
ALexOct         = 17
ALexHex         = 18

AYaccStart      = 1
AYaccStartList  = 2
AYaccExprSingle = 3
AYaccExprError  = 4
AYaccExprPlus   = 5
AYaccExprMinus  = 6
AYaccExprMult   = 7
AYaccExprDiv    = 8
AYaccExprMod    = 9
AYaccExprNot    = 10
AYaccExprAnd    = 11
AYaccExprOr     = 12
AYaccExprNested = 13
AYaccExprNumber = 14
AYaccNumberDec  = 15
AYaccNumberOct  = 16
AYaccNumberHex  = 17

ALexClassTable = 'sscalc.dfa'
ALexClass = SSLexCreate( ALexClassTable, expr, SSBuffer)
ALexClassTable = ""
AYaccClassTable = 'sscalc.llr'
AYaccClass = SSYaccCreate( ALexClass, AYaccClassTable)
AYaccClassTable = ""

do forever
   SSRet = SSYaccParse( AYaccClass, SSParm)
   select
      when SSRet = SSOK then
         nop /*say "Lexeme "SSParm.0", "SSParm.1*/
      when SSRet = SSMORE then do
         SSRet = ALexClassProcessMore()
         if SSRet <> "" then
            SSRet = SSLexAddData( ALexClass, SSRet)
         end
      when SSRet = SSSHIFT then
         nop /*say "Shift "SSParm.0", "SSParm.1*/
      when SSRet = SSREDUCE then
         call AYaccClassReduce
      when SSRet = SSACCEPT then do
         leave
         end
      when SSRet = SSLEXERROR then do
         SSRet = ALexClassProcessError()
         if SSRet < 0 then leave
         end
      when SSRet = SSYACCERROR then do
         SSRet = AYaccClassProcessError()
         if SSRet < 0 then leave
         end
      otherwise
         say 'Unprocessed parse 'SSRet
   end
end

call SSCleanup
return 0



AYaccClassProcessError:
   if SSParm.2 = 4294967295 then
      say 'Syntax error: Probable missing semicolon'
   else
      say 'Syntax error at 'SSParm.2','SSParm.3': 'SSParm.0', 'SSParm.1
   return -1

ALexClassProcessMore:
   return ''

ALexClassProcessError:
   say 'Invalid lexeme on line 'SSParm.2' at offset 'SSParm.3': 'SSParm.0
   return -1

AYaccClassReduce:
   select
      when SSParm.0 = AYaccStart then do
      /* start -> exprStatement */
         end

      when SSParm.0 = AYaccStartList then do
      /* start -> start exprStatement */
         end

      when SSParm.0 = AYaccExprSingle then do
      /* exprStatement -> expr ; */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         if substr( Expr0.4, 1, 1) <> '-' then
            say Expr0.4','d2x(trunc( Expr0.4))
         else
            say Expr0.4
         end

      when SSParm.0 = AYaccExprError then do
      /* exprStatement -> %error ; */
         end

      when SSParm.0 = AYaccExprPlus then do
      /* expr -> expr + expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr2, 2)
         Calc = Expr0.4 + Expr2.4
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprMinus then do
      /* expr -> expr - expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr2, 2)
         Calc = Expr0.4 - Expr2.4
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprMult then do
      /* expr -> expr * expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr2, 2)
         Calc = Expr0.4 * Expr2.4
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprDiv then do
      /* expr -> expr / expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr2, 2)
         if Expr2.4 = 0 then do
            say "Divide by 0 error, terminating"
            exit 1
            end
         Calc = Expr0.4 / Expr2.4
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprMod then do
      /* expr -> expr % expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr2, 2)
         Calc = Expr0.4 // Expr2.4
         if Expr2.4 = 0 then do
            say "Divide by 0 error, terminating"
            exit 1
            end
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprNot then do
      /* expr -> not expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr1, 1)
         Calc = SSBitNot( Expr1.4)
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprAnd then do
      /* expr -> expr and expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr2, 2)
         Calc = SSBitAnd( Expr0.4, Expr2.4)
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprOr then do
      /* expr -> expr or expr */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr2, 2)
         Calc = SSBitOr( Expr0.4, Expr2.4)
         SSRet = SSYaccSetStackParm( AYaccClass, Calc)
         end

      when SSParm.0 = AYaccExprNested then do
      /* expr -> ( expr ) */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr1, 1)
         SSRet = SSYaccSetStackParm( AYaccClass, Expr1.4)
         end

      when SSParm.0 = AYaccExprNumber then do
      /* expr -> number */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccSetStackParm( AYaccClass, Expr0.4)
         end

      when SSParm.0 = AYaccNumberDec then do
      /* number -> dec */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccSetStackParm( AYaccClass, Expr0.0)
         end

      when SSParm.0 = AYaccNumberOct then do
      /* number -> oct */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         SSRet = SSYaccSetStackParm( AYaccClass, Expr0.0)
         end

      when SSParm.0 = AYaccNumberHex then do
      /* number -> hex */
         SSRet = SSYaccGetStackParmsFromProduction( AYaccClass, Expr0, 0)
         Number = x2d( substr( Expr0.0, 3))
         SSRet = SSYaccSetStackParm( AYaccClass, Number)
         end

   end
   return

SSCleanup:
   if ALexClassTable = "" then
      call SSLexDestroy ALexClass
   if AYaccClassTable = "" then
      call SSYaccDestroy AYaccClass
   call SSUnloadRexxFunctions
   return

SSTerminate:
   say 'Error on line 'sigl': 'SSResult
   call SSCleanup
   exit 1
