%include "..\s2macros.asm" ;Handy macros

section _TEXT class=CODE use32 flat

;In REXX-callable function:
;argc = [ebp+0Ch]
;argv = [ebp+10h]
;retstr = [ebp+18h]

;CerealLoadFuncs: Load all the Cereal functions, and return a version string.
;Parameter: [dllname]
func CerealLoadFuncs
mov edi,defdllname
mov eax,[ebp+0Ch]
or eax,eax
jz .defdll
mov ebx,[ebp+10h]
mov edi,[ebx+4]
.defdll:
mov esi,funcs
mov ecx,numfuncs
.loop:
push ecx
callos2 RexxRegisterFunctionDll,[esi],edi,[esi]
pop ecx
add esi,4
loop .loop
retver:
mov ebx,[ebp+18h]
mov dword[ebx],ver.len
mov dword[ebx+4],ver
jmp finok

retnull:
mov ebx,[ebp+18h]
mov dword[ebx],0 ;Zero out retstr.strlength
finok:
xor eax,eax
fin:
mov esp,ebp
pop ebp
ret

throwerror:
mov eax,1
jmp fin

;getnumber: Convert a rxstring into a binary number
;Pass string pointer in ESI, length in ECX
;Returns value in EAX
;Destroys EBX, EDX, EFLAGS
;Invalid characters cause jmp to throwerror (ie return Error 40 to REXX interpreter)
getnumber:
or ecx,ecx
jz near throwerror ;If number = '' then error
xor eax,eax
mov ebx,10
cld
.loop:
mul ebx
push eax
lodsb
sub al,'0'
cmp al,'9'
ja throwerror
xor edx,edx
mov dl,al
pop eax
add eax,edx
loop .loop
ret

;CerealRequest: Obtain one semaphore
;One parameter: Maximum semaphore number.
;Runs through the list of semaphores, claiming the first available one
;On success returns index of successfully gained semaphore. This value should be passed to CerealRelease when the resource is finished with.
;On failure (ie all sems up to maxsem are taken) returns "".
func CerealRequest
mov eax,[ebp+0Ch]
cmp eax,1
jnz throwerror ;Want one arg
mov ebx,[ebp+10h]
mov ecx,[ebx]
mov esi,[ebx+4]
call getnumber
push eax
callos2 DosRequestMutexSem,[mastersem],0xFFFFFFFF
pop ecx
mov edi,sems
mov al,0
repnz scasb
jnz .error ;If not found, error. If found, return it.
inc byte[edi-1]
sub edi,sems
mov eax,edi
call returneax
callos2 DosReleaseMutexSem,[mastersem]
jmp finok

.error:
callos2 DosReleaseMutexSem,[mastersem]
mov ebx,[ebp+18h]
mov dword[ebx],0
jmp finok

;CerealRelease: Release semaphore (finished now!)
;Parameter: ID as returned by CerealRequest
;Returns 0 for success, 288 (ERROR_NOT_OWNER) if semaphore not owned. (Note: No owner ID is stored as yet. If one thread requests a semaphore and another releases it, this is no error.)
func CerealRelease
mov eax,[ebp+0Ch]
cmp eax,1
jnz throwerror ;Want one arg
mov ebx,[ebp+10h]
mov ecx,[ebx]
mov esi,[ebx+4]
call getnumber
lea ebx,[sems+eax-1]
callos2 DosRequestMutexSem,[mastersem],0xFFFFFFFF
mov eax,288
cmp byte[ebx],0
jz .error
mov byte[ebx],0
xor eax,eax
.error:
call returneax
callos2 DosReleaseMutexSem,[mastersem]
jmp finok

returneax: ;CALL here after setting EAX to set the return value (for REXX-callable external function)
mov ebx,[ebp+18h]
mov edi,[ebx+4]
..@storenum:
mov ebx,10 ;Return in decimal - change this for diff radix, but if >10 must uncomment code for alpha digits
xor ecx,ecx
.moredigits:
xor edx,edx
div ebx
push edx
inc ecx
or eax,eax
jnz .moredigits
mov ebx,[ebp+18h]
mov [ebx],ecx
.getdigits:
pop eax
add al,0x30
;Below four lines for alpha digits
;cmp al,0x39
;jbe .notalpha
;add al,7
;.notalpha:
;End alpha digit code
stosb
loop .getdigits
ret

;CerealStatus: Get block of data indicating semaphore ownership
;One parameter: NumSemaphores. For best results this should match the value used in CerealRequest.
;Returns a block of byte values, one per semaphore. The first byte is semaphore 1.
func CerealStatus
mov eax,[ebp+0Ch]
cmp eax,1
jnz throwerror ;Want one arg
mov ebx,[ebp+10h]
mov ecx,[ebx]
mov esi,[ebx+4]
call getnumber
mov ebx,[ebp+18h]
mov [ebx],eax
mov dword[ebx+4],sems
jmp finok

;CerealClear: Erase all information about semaphore ownership
;WARNING: This is a potentially dangerous function, and should not be used carelessly!
;One parameter: number of semaphores to clear. For best results this should match the value used in CerealRequest.
;Returns "".
func CerealClear
mov eax,[ebp+0Ch]
cmp eax,1
jnz throwerror ;Want one arg
mov ebx,[ebp+10h]
mov ecx,[ebx]
mov esi,[ebx+4]
call getnumber
push eax
callos2 DosRequestMutexSem,[mastersem],0xFFFFFFFF
pop ecx
mov al,0
mov edi,sems
repz stosb
callos2 DosReleaseMutexSem,[mastersem]
mov ebx,[ebp+18h]
mov dword[ebx],0
jmp finok


..start:
callos2 DosCreateMutexSem,0,mastersem,0,0
or eax,eax
jz .noerr
mov eax,0xFFFFFFFF
.noerr:
inc eax
ret

section _DATA dword public class=DATA use32 flat
defdllname db "Cereal.DLL",0
funcs dd req,rel,sta,clr
numfuncs equ 4
req db "CerealRequest",0
rel db "CerealRelease",0
sta db "CerealStatus",0
clr db "CerealClear",0
msg ver,"1.0.0 Cereal.DLL by Chris Angelico http://www.kepl.com.au/esstu/cereal.html"
nwritten dd 0
mastersem dd 0
sems resb 4096
