// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of the GNU C++ Library.  This library is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This library is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef _StringStringAVLMap_h
#ifdef __GNUG__
#pragma interface
#endif
#define _StringStringAVLMap_h 1

//#include "String_String_Map.h"
#include "strsmap.h"

struct StringStringAVLNode
{
  String                 item;
  String                 cont;
  StringStringAVLNode*      lt;
  StringStringAVLNode*      rt;
  char                stat;
                      StringStringAVLNode(String& h, String& c, 
                                    StringStringAVLNode* l=0, StringStringAVLNode* r=0);
                      ~StringStringAVLNode();
};

inline StringStringAVLNode::StringStringAVLNode(String& h, String& c, 
                                    StringStringAVLNode* l, StringStringAVLNode* r)
     :item(h), cont(c), lt(l), rt(r), stat(0) {}

inline StringStringAVLNode::~StringStringAVLNode() {}

typedef StringStringAVLNode* StringStringAVLNodePtr;


class StringStringAVLMap : public StringStringMap
{
protected:
  StringStringAVLNode*   root;

  StringStringAVLNode*   leftmost();
  StringStringAVLNode*   rightmost();
  StringStringAVLNode*   pred(StringStringAVLNode* t);
  StringStringAVLNode*   succ(StringStringAVLNode* t);
  void            _kill(StringStringAVLNode* t);
  void            _add(StringStringAVLNode*& t);
  void            _del(StringStringAVLNode* p, StringStringAVLNode*& t);

public:
                StringStringAVLMap(String& dflt);
                StringStringAVLMap(StringStringAVLMap& a);
                ~StringStringAVLMap();

  String&          operator [] (String& key);

  void          del(String& key);

  Pix           first();
  void          next(Pix& i);
  String&          key(Pix i);
  String&          contents(Pix i);

  Pix           seek(String& key);
  int           contains(String& key);

  void          clear(); 

  Pix           last();
  void          prev(Pix& i);

  int           OK();
};

inline StringStringAVLMap::~StringStringAVLMap()
{
  _kill(root);
}

inline StringStringAVLMap::StringStringAVLMap(String& dflt) :StringStringMap(dflt)
{
  root = 0;
}

inline Pix StringStringAVLMap::first()
{
  return Pix(leftmost());
}

inline Pix StringStringAVLMap::last()
{
  return Pix(rightmost());
}

inline void StringStringAVLMap::next(Pix& i)
{
  if (i != 0) i = Pix(succ((StringStringAVLNode*)i));
}

inline void StringStringAVLMap::prev(Pix& i)
{
  if (i != 0) i = Pix(pred((StringStringAVLNode*)i));
}

inline String& StringStringAVLMap::key(Pix i)
{
  if (i == 0) error("null Pix");
  return ((StringStringAVLNode*)i)->item;
}

inline String& StringStringAVLMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return ((StringStringAVLNode*)i)->cont;
}

inline void StringStringAVLMap::clear()
{
  _kill(root);
  count = 0;
  root = 0;
}

inline int StringStringAVLMap::contains(String& key)
{
  return seek(key) != 0;
}

#endif
