.. ----------------------------------------
.2 [=BASETITLE] attribute escape characters
.. ----------------------------------------
.an ESC_ATTRIBUTES

[=TOPICS]

.su V30 u 1

.. ----------------------------------------
.3 Bold, italic and underlined text
.. ----------------------------------------
.an ESC_ATTRIBUTES_STANDARD

Example:
.fo off
 .. This is a text with attribute escape chars:
 .
 **This text is bold**,
 .
 ##this text is italic##,
 .
 __this text is underlinded__,
 .
 __**this text is bold and underlined**__,
 .
 .. There is no escape character for the
 .. hilite attribute, so we use the .ATTRIBUTE
 .. command:
 .at hilite
 this text is hilighted using the .ATTRIBUTE command.
 .at
.fo on

The following escape characters can be used to
toggle text attributes:
.pl compact break=none tsize=5
- **
= (asterisk) to toggle #bold# attribute
- ##
= (numsign) to toggle #italic# attribute
- __
= (underscore) to toggle #underlined# attribute

The following rules apply to attribute escape characters:
.ul compact
- The escape character toggles the attribute on or off
  corresponding to the current status.
- If you want to use the escape character itself within the text,
  you have to specify it twice.
- One or more attributes can be activated at a time with the following
  exceptions:
.ul compact
  - Hilighted ignores all other attributes if set.
  - Italic and underlined attribute being active let ignore the bold
    attribute.

[=NOTE]
.ul compact
- You can also use the [.CMD_ATTRIBUTE] command to toggle
  text attributes.
- There is no escape character to toggle the hilite attribute
  (set to red color). You must use the [.CMD_ATTRIBUTE] command
  to toggle the hilite attribute.

.hr Result of the example above

.. This is a text with attribute escape chars:
*This text is bold*,
.
#this text is italic#,
.
_this text is underlinded_,
.
_*this text is bold and underlined*_,
.
.at hilite
this text is hilighted using the .ATTRIBUTE command.
.at

.. ----------------------------------------
.3 Optional monospace inline text
.. ----------------------------------------
.an ESC_ATTRIBUTES_MONOSPACE

Example:
.fo off
 .. The escape char for ttfont must be explicitly
 .. defined somewhere before its first usage:
 .ttchar ~
 ~this text is set in a typewriter type font~
.fo on

The prefix *TT* stands for *typewriter type*. It's being used for commands
allowing for inline text set in a monospace font. (In HTML, the equivalent
<tt> tag means *teletype font*, which means the same. The logical markup
version of it is the more often-used <code>.)

After defining a typewriter type escape char, it can be used like any
other attribute escape char:

.ul compact
- For compatibility with existing texts being prepared for older
  versions of [=TITLE], the character being used to toggle typewriter type
  font must be defined with the [.CMD_TTCHAR] command first. Otherwise,
  that char will be handled as a standard char.
- To reset the defined escape char (e.g. when text parts including a tilde
  should be processed easily), [.CMD_TTCHAR] can be specified without
  parameters.
- It is recommended to use the tilde sign ~ as ttfont escape char, if any.
  As an alternate, also the plus sign may be suited.
- Toggling the typewriter type font resets all other attributes.

[=NOTE]
.ul compact
- In IPF, no real typewriter type font attribute exists. In order to set
  only a part of a paragraph with a typewriter type font, the font is
  changed using IPF's *:font.* tag. That value is being hard-coded in
  the resulting INF or HLP file.
- The default font attributes are: #facename=Courier size=18x12#.
- It can be changed with the [.CMD_TTFONT] command, but that should
  better be avoided, see the explanation there.
- You can also use the [.CMD_ATTRIBUTE .at tt] command to toggle
  typewriter type text attributes.
- For entire blocks in monospace font, see the [.CMD_FORMAT] command.

.hr Result of the example above

.. The escape char for ttfont must be explicitly
.. defined somewhere before its first usage:
.ttchar ~
~this text is set in a typewriter type font~

.. ----------------------------------------
.2 Hyperlink and replacement escape characters
.. ----------------------------------------
.an ESC_LINKS
.an TEST1
.an TEST2
.res 6001

[=TOPICS]

.su V30 u 1

.. ----------------------------------------
.3 Internal links
.. ----------------------------------------
.an LINK_INTERNAL

Examples:

.fo off
 .. Link to previous page with the exact title text
 title text link: [[hyperlink and replacement escape characters]]

 .hr Link to previous page with an anchor name using the title text
 anchor link: [[.ESC__LINKS]]

 .. Link to previous page with an anchor name using alternate text
 anchor link with alternate text: [[.ESC__LINKS my link]]

.fo on

For a title text link, the link information is the exact title text of a
section (case-insensitive).

An anchor link, referring to a section, starts with a period. The title of
the linked page is used as link text, if no alternate text is specified
after the anchor name.

For creating bitmap links (IPF artlinks) and for an alternate syntax
to specify the link text, see [.LINK_ADVANCED].

.hr Result of the examples above

title text link: [hyperlink and replacement escape characters]

anchor link: [.ESC_LINKS]

anchor link with alternate text: [.ESC_LINKS my link]

.. ----------------------------------------
.3 External links to internet resources
.. ----------------------------------------
.an LINK_URL

Examples:

.fo off
 .. Link to internet resources
 web link: [[http://hobbes.nmsu.edu]]

 .. Link to internet resources with alternate text
 web link: [[http://hobbes.nmsu.edu The Hobbes File Archive]]

 .. Ftp link
 ftp link: [[ftp://ftp.netlabs.org/pub]]

 .. Email link
 email link: [[mailto:C.Langanke@Teamos2.de]]

 .. Email link with alternate text
 email link: [[mailto:C.Langanke@Teamos2.de Christian Langanke]]
.fo on

The link information is either

.ul compact
- an URL with *http://*, *https://*, *ftp://*, *irc://* or
- an email address starting with *mailto:*,

and optional with an alternate text to be used as link text instead of
the URL or filename.

For creating bitmap-only links (IPF artlinks), for an alternate syntax
to specify the link text and for using special bitmaps, see
[.LINK_ADVANCED].

.hr Result of the examples above

web link: [http://hobbes.nmsu.edu]

web link: [http://hobbes.nmsu.edu The Hobbes File Archive]

ftp link: [ftp://ftp.netlabs.org/pub]

email link: [mailto:C.Langanke@Teamos2.de]

email link: [mailto:C.Langanke@Teamos2.de Christian Langanke]

.. ----------------------------------------
.3 External links to INF files
.. ----------------------------------------
.an LINK_INF

Examples:

.fo off
 .. Link to INF and HLP file
 INF file: [[inf:cmdref]] and HLP file: [[inf:epm.hlp]]

 .. Link to XCOPY section of command reference
 INF file: [[inf:cmdref XCOPY]]

 .. Link to NET VIEW section of command reference
 INF file: [[inf:cmdref net view]] or [[inf:cmdref "net view"]]

 .. Link to NET VIEW section of command reference
 .. with alternate link text
 INF file: [[inf:cmdref "net view" alternate link text]]
.fo on

The link information starts with *inf:*, followed by an INF filename.
The extension ".inf" can be omitted. The file is searched in the
BOOKSHELF path.

To open an INF file with a special section, optionally append the
search string. The search string is used as link text, unless an
alternate link text is specified after the search string.

For creating bitmap links (IPF artlinks) and for an alternate syntax
to specify the link text (even without specifying a search string),
see [.LINK_ADVANCED].

To use a HLP file, always add the extension. HLP files are searched
in the HELP path. Note that in HLP files only the index is searched.

.hr Result of the examples above

INF file: [inf:cmdref] and HLP file: [inf:epm.hlp]

INF file: [inf:cmdref XCOPY]

INF file: [inf:cmdref net view] or [inf:cmdref "net view"]

INF file: [inf:cmdref "net view" alternate link text]

.. ----------------------------------------
.3 Text replacements
.. ----------------------------------------
.an LINK_REPLACEMENTS

Examples:

.fo off
 .. Insert the title of the referred page
 title of the page is: [[=.ESC__LINKS]]

 .. Insert the content of an environment variable
 IPFC directory on my harddisk is: [[=IPFC]]
.fo on

For getting the title of a linked page, the link information is the anchor
name preceded with an equal sign and a period.

For getting the value of environment variable, the link information is
the name of the environment variable preceded with an equal sign.

[=NOTE]
.ul compact
- Set an anchor with the [.CMD_ANCHOR] command.
- You can set environment variables with the [.CMD_SET] command.
- See also: [.CMD_GET], [.SAMPLE_CODE_MACRO] and [.SAMPLE_NESTED_ENV_VARS].

.hr Result of the examples above

title of the page is: [=.ESC_LINKS]

IPFC directory on my harddisk is: [=IPFC]

.. ----------------------------------------
.3 Rules for links and text replacements
.. ----------------------------------------
.an LINK_RULES

See the following sections:

.su h25 u

.. - - - - - - - - - - - - - - - - - - - -
.4 Common Rules
.. - - - - - - - - - - - - - - - - - - - -

The following rules apply to creating links and text replacements:
.ul
- The link information must be embedded in brackets.
  The following types exist:
.ul compact
  - *[[section title]]*
.
    ([.LINK_INTERNAL internal link to a page])
  - *[[.ANCHORNAME]]* or *[[.ANCHORNAME alternate text]]*
.
    ([.LINK_INTERNAL internal link to a page])
  - *[[URL]]* or *[[URL alternate text]]*
.
    ([.LINK_URL external link to a URL or email address])
  - *[[inf:FILENAME]]* or *[[inf:FILENAME search string]]* or
    *[[inf:FILENAME "search string" alternate text]]*
.
    ([.LINK_INF external link to an INF file])
  - *[[=.ANCHORNAME]]*
.
    ([.LINK_REPLACEMENTS insert the title of a page])
  - *[[=ENVVARNAME]]*
.
    ([.LINK_REPLACEMENTS insert the value of an environment variable]).
.el
- For anchor, INF and URL links, an alternate text can be specified
  after the link location. If the alternate link text contains [=TITLE]
  [.ESC_ATTRIBUTES escape chars], they have to be specified twice.
- The start *[[* and end *]]* of a link must be specified on the same line.
- When using text replacements or anchor names within the link
  information, the anchor name must start with an equal sign or a period
  right after the bracket.

.. - - - - - - - - - - - - - - - - - - - -
.4 Advanced bitmap and text parameters for links
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_ADVANCED

Examples:

.fo off
 .. Link to the parent panel, here with browser bitmap
 Internal link with bitmap link: [[.LINK__RULES bitmap=ns.bmp Jump to parent panel]]

 .. Link to the parent panel, here with INF bitmap
 Internal link with bitmap link: [[.LINK__RULES bitmap=book.bmp text='Jump to parent panel']]

 .. Link to Hobbes, without text
 Link to Hobbes: [[http://hobbes.nmsu.edu text=none]]
.fo on

External links to URLs and INF files are preceded with bitmaps by default.
These bitmaps were made active, so you can click on the link text or its
bitmap.

In order to configure the default bitmaps used for links, see
[.LINK_BITMAPS].

In order to make single bitmaps links and the alternate text configurable,
the link syntax was extended with #key=value# parameters:

.pl compact tsize=5
- #bitmap=#file.bmp
= The specified file is used instead of the default bitmap. This works
  even for an internal link.
- #bitmap=#'my file.bmp' or #bitmap=#"my file.bmp"
= Enquote the filename if it contains spaces.
- #bitmap=none#
= Use this parameter to avoid the automatic addition of a link bitmap for
  an external link.
- #text=#linktext
= Text without spaces can be specified unenquoted.
- #text=#'link text' or #text=#"link text"
= Enquote the link text if it contains spaces.
- #text=none#
= Use this parameter to create a bitmap link without additional text.

.note u compact
- These parameters can be specified anywhere between the link brackets.
- They were ignored for text replacements, where they don't make sense.
- The bitmap files are searched in the following places:
.ul compact
  - within the specified directory (current directory if none specified),
  - within the directory, from where *htext.cmd* is called from,
  - within the subdirectory *htext* from the directory, from where *htext.cmd*
    is called from,
  - within all directories of the *INCLUDE* environment variable, if present,
  - within all directories of the *HTINCLUDE* environment variable, if present.
.el
- The current [ [=URL_NEWVIEW] NewView] version 2.19 doesn't support IPF
  artlinks to external resources. That is planned for version 2.20.
- See also: [.CMD_BITMAP].

.hr Result of the examples above

Internal link with bitmap link: [.LINK_RULES bitmap=ns.bmp Jump to parent panel]

Internal link with bitmap link: [.LINK_RULES bitmap=book.bmp text='Jump to parent panel']

Link to Hobbes: [http://hobbes.nmsu.edu text=none]

.. - - - - - - - - - - - - - - - - - - - -
.4 Searchpaths for link bitmaps and other bitmaps
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_SEARCHBITMAPS

Bitmap filenames are searched along paths in the following order:
.fo text
   .
   .\bmp
   .\htext
   ..
   ..\bmp
   ..\htext
   <dir of htext.cmd>
   <dir of htext.cmd>\bmp
   <dir of htext.cmd>\htext
   %INCLUDE%
   %HTINCLUDE%
.fo on

.. - - - - - - - - - - - - - - - - - - - -
.4 Configure default link bitmaps
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_BITMAPS

Example:

.fo off
 .SET WEBBMP=myweb.bmp
.fo on

Following default link bitmaps are defined via environment variables:

.lm 5
.pl compact break=none tsize=15
- *Env var*
= *Value*
- WEBBMP
= ns.bmp
- EMAILBMP
= nsmail.bmp
- INFBMP
= book.bmp

.lm
These values can be changed with the [.CMD_SET] command or in the environment
before the call of [=TITLE]. After they have been searched once, no change
will take effect anymore. That means that you can change the values before
the first external link only.

.. These values can be changed with the [.CMD_SET] command. Because all links
.. are processed after the rest of the source file(s), the last .SET command
.. wins. That means that you can't use these environment variables to switch
.. the default bitmaps for only the part of the document.

.. - - - - - - - - - - - - - - - - - - - -
.4 Linking to pages of external files
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_REFID

If an anchor cannot be resolved, it is assumed that a section exists
with the anchor name as an IPF *refid*. This allows to refer to sections
outside of the IPF source being generated by [=TITLE], when it is
embedded in other IPF sources.

.. - - - - - - - - - - - - - - - - - - - -
.4 Using environment variables in links
.. - - - - - - - - - - - - - - - - - - - -
.an LINK_ENVVAR

Example:

.fo text
 .set URL_NETLABS=http://www.netlabs.org
 .. Use a space between the two opening brackets:
 [ [=URL_NETLABS] netlabs.org - Open Source Software for OS/2 and eCS]
.fo on

For easier maintenance and validation of URLs, it's recommended to define
all used URLs via environment variables, maybe alltogether in one file,
included with the [.CMD_INCLUDE] command.

Environment variables are defined with the [.CMD_SET] command. To recall
them within links via [.ESC_LINKS [[=ENVVARNAME]]], it's important to avoid
doubled brackets. That can be achieved with a space char in between them.
The additional space is stripped off in the output file.

.hr Result of the example above

.set URL_NETLABS=http://www.netlabs.org
[ [=URL_NETLABS] netlabs.org - Open Source Software for OS/2 and eCS]

