/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %dispcod    */

/* script that attempts to locate a trap location in a .cod file */
/* if the script finds the trap address, it will load the .cod file into epm.exe */
/* and scroll to the line that matches the trap address and set bookmark on that line */
/* the script makes use of the LAST loaded sym file in order to find location in the .cod file */
/* the sym files needs to be loaded manually with the "wa" command (the script will not load it) */
/* first argument: path to .cod files to query for trap location */
/* second argument: trap address, either in selector:offset form or in symbolic form */

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

TAB = d2c(9)
MARKER = d2c(29)

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

parse arg path trapaddr

if path = '' | trapaddr = '' then
do
  parse source . . rexxscript
  rexxscript = filespec('name',rexxscript)
  parse var rexxscript rexxscript '.' .
  say 'invoke: 'rexxscript' [path to cod files] [trap address]'
  return 1
end

address df 'cmd xxx ln ('trapaddr')'
rc = CompressDfReturn()
if (xxx.0 > 2) | (xxx.1 == 'Expression error') | (xxx.1 == 'No Symbols Found') then
do
  say 'Invalid addr "'trapaddr'" or symbol file not yet loaded'
  return 1
end

offset=''
parse var xxx.1 addr . symbolname . offset

if offset == '' then
do
  offset = 0
end

searchstring = symbolname||TAB||'PROC'

file.0 = 0
rc = SysFileTree(path'\*.cod',file,'FSO')

trapcodeline = -1
do n=1 to file.0
  rc = SysFileSearch(searchstring,file.n,found,'N')
  if rc == 0 & found.0 == 1 then
  do
     parse var found.1 1 symbolline .
     firstcodeline = symbolline + 1

     i=0
     check=0
     /* pre open file */
     line = linein(file.n,1,0)
     do while lines(file.n)
       line = linein(file.n)
       i = i+1
       codoffset = ''
       parse var line . 6 codoffset +6 .
       if datatype(codoffset,'X') \= 1 then do
         iterate
       end
       if (i == firstcodeline) then
       do
         offset = d2x(x2d(codoffset) + x2d(offset))
         check = 1
       end
       if (check == 1) then
       do
         if (x2d(codoffset) == x2d(offset)) then do
            trapcodeline = i
            leave
         end
       end
     end
     /* don't forget to properly close the file */
     rc = lineout(file.n)

     if (trapcodeline == -1) then
     do
       leave
     end

     "@start epm.exe """file.n""" 'mc /postme "trapcodeline" /postme bm TrapLocation 0 /postme setmessageline Selected line displays code for trap at "trapaddr".Bookmark set on this line.'"

/*
     say
     say '/// Found in file' file.n '///'
     say
     i=0
     /* pre open file */
     line = linein(file.n,1,0)
     /* read file until file end */
     do while lines(file.n)
        line = linein(file.n)
        i = i+1
        if (i >= (trapcodeline-20)) & (i<(trapcodeline+20)) then
        do
           if (i == trapcodeline) then
             say MARKER||MARKER||MARKER||MARKER||MARKER||line
           else
             say line
        end
     end
     /* don't forget to properly close the file */
     rc = lineout(file.n)
*/

     leave
  end
end
if (trapcodeline == -1) then
do
  say 'Could not find a cod file containing "'symbolname'" or address "'trapaddr'" does not match any instruction boundary'
  return 1
end
return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */
