/* this is a REXX script for PMDF usage */
/* invoke from PMDF with: %callchain    */

/* if passed ss:bp cs:ip, this script tries to follow the call chain */
/* and will attempt to decode all symbol names */

trace 'o'
if \IfCalledFromPMDF() then do
   return 1
end /* do */

parse upper arg ss':'bp cs':'ip

if ss = '' | bp = '' | cs = '' | ip = '' then do
   parse source . . rexxscript
   rexxscript = filespec('name',rexxscript)
   parse var rexxscript rexxscript '.' .
   say 'invoke: 'rexxscript' ss:bp cs:ip'
   return 1
end

numeric digits 20
rc = rxfuncadd('SysLoadFuncs','REXXUTIL','SysLoadFuncs')
rc = SysLoadFuncs()

address df 'cmd xxx ln 'cs':'ip
rc = CompressDfReturn()
if xxx.1 = 'No Symbols Found' then do
   say 'Load Symbol File for symbol at address 'cs':'ip', aborting ...'
   return 1
end

say '*********** Call Chain *****************'
do n=1 to 10
/*
   parse var xxx.1 . symname '+' .
   symname = strip(symname)
*/
   if xxx.1 = 'No Symbols Found' then do
      leave
   end

   parse var xxx.1 . symname
   say '('ss':'bp') 'symname

   address df 'cmd xxx dw 'ss':'bp' l2'
   rc = CompressDfReturn()

   parse var xxx.1 tmp bp ip

   if tmp = 'Invalid' then do
      leave
   end

   /*say 'ss is:'ss' , bp is:'bp' , cs is:'cs' , ip is:'ip*/

   address df 'cmd xxx ln 'cs':'ip
   rc = CompressDfReturn()
end
return 0


CompressDfReturn: procedure expose xxx.
if xxx.1 == '' then do
   rc = SysStemDelete(xxx,1)
end
return rc 

IfCalledFromPMDF: procedure
address df 'querydf path'
if rc == 30 then do
   say 'run this script from PMDF'
   return 0
end
else do /* do */
   return 1
end /* do */

