/*+-------------------------------------------------------------------------
                            MTFP.C
 ----------------------------------------------------------------------------
     This program will register one Footprints process and use trace
     id's 1-64 to register tracing for each of 64 threads.  Trace
     id zero will be used to trace the main process.  To trace the
     threads, the bits 1 to 64 must be turned on from the external
     PM interface.  These may be written to a file so that they are
     automatically on when the program starts up.

     Note:  you cannot recompile this file because you do not have
     the headers, libraries, or DLL's required.  Those will come
     when you order the product.
 ------------------------------------------------------------------------*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define INCL_NOPMAPI
#define INCL_BASE
#include <os2.h>

#include "footprnt.h"

/*---------------
    constants
 ---------------*/
#define MAX_THREADS 64
#define FP_PROC_NAME "ScanT"

/*----------------
    global vars
 ----------------*/
HFPHANDLE hfp;

/*---------------
    structures
 ---------------*/
typedef struct _THREAD_WA
{
   char      szEyecatcher[16];
   int       iThreadNo;
   HFPHANDLE hfp;
   HEV       hevTerm;
   char      acDataArea[256];
} THREAD_WA;

/*---------------
    prototypes
 ---------------*/
void TermGracefully( void );
void ScanThread( void *pV );
void SimTCPIPRead( THREAD_WA *pT );
void DebugLog( int iThread );

int main( int argc, char *argv[], char *envp[] )
{
   char szProcName[]="MulTdSim";
   int  i;
   THREAD_WA Twa[MAX_THREADS];
   APIRET apiRC;
   HEV   hevTerm;
   FILE *fp;

   /*+-----------------------------------------------------------+
     |  Call HfpInit to establish Footprints session             |
     +-----------------------------------------------------------+*/
   if( apiRC = HfpInit( szProcName, &hfp ))
      printf("Bad return from HfpInit %d\n", apiRC );

   /*+--------------------------------------+
     |  delete debug log                    |
     +--------------------------------------+*/
   if( ( fp = fopen( "debug.log", "w" ) ) == NULL )
      printf("couldn't open debug log\n");
   else
      fclose( fp );

   if( apiRC = DosCreateEventSem( NULL, &hevTerm, 0L, FALSE))
   {
      printf("Can't create termination sem, rc = %d\n", apiRC );
      return(1);
   }
   if(apiRC = DosExitList( EXLST_ADD, (PFNEXITLIST)TermGracefully ))
      printf("Bad return from DosExitList %d\n", apiRC );
   for( i=0; i<MAX_THREADS && i<99; i++ )
   {
      Twa[i].hevTerm = hevTerm;        /* give each thread sem handle */
      Twa[i].hfp = hfp;                /* put handle in global area */

     /* put eyecatcher in data area (nice to look at big buffers this way)*/
      sprintf( Twa[i].szEyecatcher, "ScanData%02d", i+1 );
      Twa[i].iThreadNo = i+1;
      _beginthread( ScanThread, NULL, 8192, (void *)&Twa[i] );
   }
   printf("Press <enter> to quit\n");
   getchar();

   DosPostEventSem( hevTerm );
   DosSleep( 500L ); /* give threads a chance to quit */
   DosCloseEventSem( hevTerm );
   DosExit( EXIT_PROCESS, 0 );
} /* end main */

/*+---------------------------------------------------------------------+
  |  The scan thread is called MAX_THREAD times.                        |
  +---------------------------------------------------------------------+*/
void ScanThread( void *pV )
{
   THREAD_WA *pT;
   APIRET    apiRC;

   pT = (THREAD_WA *)pV;
   /*+--------------------------------------------------------------------+
     |  Call HfpTrace to record the thread work area.  Use 0 for the 5th  |
     |  argument.  This will always get traced, since this is useful info |
     |  Note that while this trace will always get captured, the only     |
     |  way you'll know which thread it is is by looking at the actual    |
     |  buffer contents.                                                  |
     +--------------------------------------------------------------------+*/
   HfpTrace( pT->hfp, pT, 20 , "TBegin", 0 );
   while(1)
   {
      SimTCPIPRead( pT );
      /*+-----------------------------------------------------------------+
        |  Here, we pass the thread id number with the trace, so if you   |
        |  want to isolate your tracing to only one thread, you can turn  |
        |  only that trace id on.                                         |
        +-----------------------------------------------------------------+*/
      HfpTrace( pT->hfp, pT, sizeof(THREAD_WA), "RetBuf", pT->iThreadNo );
      /*+-----------------------------------------------------------------+
        |  Another thing to do, instead of the above command, if you      |
        |  don't like to look at hex dumps, you can use the HfpIsItOn     |
        |  function.  Then write your debugging info to a text file       |
        |  that you or your user can read.  This is a good substitute     |
        |  for the old #ifdef stuff where you have to recompile to get    |
        |  a debugging log                                                |
        +-----------------------------------------------------------------+*/
      if( HfpIsItOn( pT->hfp, pT->iThreadNo ) )
         DebugLog( pT->iThreadNo );
      /*-------------------------------------------------------------
          wait 500ms and continue looping until posted by main guy
       -------------------------------------------------------------*/
      if( (apiRC = DosWaitEventSem( pT->hevTerm, 500L )) == NO_ERROR )
         _endthread();
      else if( apiRC == ERROR_TIMEOUT )
         ;
      else
      {
         HfpTrace( pT->hfp, &apiRC, sizeof(apiRC), "SemErr", 0 );
         _endthread();
      }
   }
} /* end ScanThread */

void SimTCPIPRead( THREAD_WA *pT )
{
   char c;
   char szString1[] = "Random Fill 1";
   char szString2[] = "Random Fill 2";

   c = (char)rand();
   memmove( pT->acDataArea, szString1, strlen(szString1) );
   memset( &pT->acDataArea[strlen(szString1)], c, 128-strlen(szString1) );
   c = (char)rand();
   memmove( &pT->acDataArea[100], szString2, strlen(szString2) );
   memset( &pT->acDataArea[128+strlen(szString2)], c, 128-strlen(szString2) );
   return;
}

/*+----------------------------------------------------------------------+
  |  This is registered with DosExitList. It will terminate Footprints   |
  +----------------------------------------------------------------------+*/
void TermGracefully( void )
{
   int i;
   APIRET apiRC;

   printf("Exit routine in control\n");
   /*--------------------------------------------------------------
       terminate Footprints so buffer in memory is flushed
    --------------------------------------------------------------*/
   apiRC = HfpTerm( hfp );
   return;
}

/*+-----------------------------------------------------------------------+
  |  This is a debug log that you would use with the HfpIsItOn API call   |
  +-----------------------------------------------------------------------+*/
void DebugLog( int iThread )
{
   FILE *fp;

   if( ( fp = fopen( "debug.log", "a" ) ) == NULL )
      return;
   fprintf(fp, "Here's a bunch of debug info for thread %d\n", iThread );
   fprintf(fp, "...debug info...\n" );
   fclose( fp );
   return;
}
