/**********************************************************************
  sample4.c test trap in 16 bit function

  adapted from code created by Marc Fiammante December 1992

 2005-08-02 SHL Baseline - FIXME
 2020-05-25 SHL Support INCL_EXCEPTQ
*/

// Disable to let compiler generate handler
// #define INCL_LOADEXCEPTQ

#ifdef INCL_LOADEXCEPTQ
#define INCL_DOSPROCESS
#endif

#ifdef INCL_LOADEXCEPTQ
#define INCL_DOSEXCEPTIONS
// #define INCL_DOSERRORS
// #define INCL_DOSPROCESS
#define INCL_DOSMODULEMGR

#include <os2.h>
#include "exceptq.h"
#endif // INCL_LOADEXCEPTQ

#include <stdio.h>
#include <stdlib.h>

#ifdef INCL_LOADEXCEPTQ
#include <string.h>		// for LoadExceptq
#endif

int main(int argc, char **argv);
void Func32(void);

extern void _Far16 TrapFunc16(void);

#ifndef INCL_LOADEXCEPTQ
/* Install exception handler for main */
#pragma handler (main)

/* Use MYHANDLER instead of default _Exception handler */
#pragma map (_Exception,"MYHANDLER")
#endif

int main(int argc, char **argv)
{
#   if defined(INCL_LOADEXCEPTQ)
    EXCEPTIONREGISTRATIONRECORD exRegRec = { NULL, NULL };
    if (!LoadExceptq(&exRegRec, "I", "sample2 testcase")) {
	printf("LoadExceptq failed.\n");
    }
#else
    printf("Exception handler has been set by compiler\n");
#endif

    Func32();
    return 0;
}

void Func32(void) {
    TrapFunc16();
}

// eof
