#
# exceptq.mak - build exceptq.dll
# $Id: exceptq.mak,v 1.11 2023/02/24 05:18:41 Steven Exp $
#
# Tools used:  nmake32  vacpp(v3.65)  ilink(v5)  implib  mapsym
# Note:  '@echo' separates each tool's output with a blank line

# Define DEBUG to enable optimized debug build.
# Define DEBUG = 2 to enable debug build and disable optimizer
# when building with 3.6.5.
# /Ti /O breaks local variable debugging on 3.6.5.

.SUFFIXES:

.SUFFIXES: .c .asm

all: exceptq.dll

# Note 3.08 does not support SEGORGER

exceptq.dll:  \
  exceptq.obj \
  exq_cv.obj \
  exq_dbg.obj \
  exq_rpt.obj \
  exq_sym.obj \
  cmpxchg.obj \
  exceptq.def \
  exceptq.mak
  @echo
  ilink @<<exceptq.lrf
    /DLL /EXEPACK:2 /NOIGNORECASE /MAP /OPTFUNC /NOSEGORDER
!ifdef DEBUG
    /DE /LINENUMBERS
!else
    /NOLINENUMBERS 
!endif
    /OUT:exceptq.dll
    exceptq.obj
    exq_cv.obj
    exq_dbg.obj
    exq_rpt.obj
    exq_sym.obj
    cmpxchg.obj
    exceptq.def
<<KEEP
  @echo
  implib /nologo exceptq.lib exceptq.def
  @echo
# 2012-09-16 SHL
  mapsym exceptq
  mapxqs exceptq
# 2020-04-13 SHL 4OS2 required here
  echo. | tee exceptq.lvl
  dir /km exceptq.dll  | tee /a exceptq.lvl
  echo. | tee /a exceptq.lvl
  bldlevel exceptq.dll | tee /a exceptq.lvl
  echo. | tee /a exceptq.lvl
  md5sum exceptq.dll | tee /a exceptq.lvl
!ifndef DEBUG
  @echo
# 2012-08-02 SHL
  lxlite $@
!endif

# Use default Optlink calling convention (/Mp)
# /Ge-  Build DLL
# /Gl   Smart linking
# /Gm   Link with multithread runtime libraries
# /O    Optimize (breaks debug build local variable support on 3.6.5)
# /Q    Suppress logo
# /Sm   Allow migration keywords
# /Ss   Allow //
# /Ti   Generate debugging information

.c.obj:
  @echo
!ifdef DEBUG
# 2013-10-15 SHL /O breaks local variables on 3.6.5 - use DEBUG = 2 to avoid
!if $(DEBUG) == 2
  icc /Ge- /Gl /Gm /Q /Sm /Ss /W3 /Ti /C $*.c
!else
  icc /Ge- /Gl /Gm /O /Q /Sm /Ss /W3 /Ti /C $*.c
!endif
!else
  icc /Ge- /Gl /Gm /O /Q /Sm /Ss /W3 /C $*.c
!endif

.asm.obj:
  alp $<

exceptq.obj:  exceptq.c  exq.h exceptq.mak
exq_cv.obj:   exq_cv.c   exq.h exceptq.mak omf.h hlldbg.h
exq_dbg.obj:  exq_dbg.c  exq.h exceptq.mak omf.h hlldbg.h
exq_rpt.obj:  exq_rpt.c  exq.h exceptq.mak distorm.h
exq_sym.obj:  exq_sym.c  exq.h exceptq.mak sym.h xqs.h

