#
# distorm.mak - build distorm.dll with VAC and nmake32
#
# Tools used:  nmake32  vacpp  ilink  implib  mapsym
# Note:  '@echo' separates each tool's output with a blank line

# define DEBUG for debug build

SRCDIR = ..\src
INCDIR = ..
MAKEFILE = distorm.mak

.SUFFIXES:

.SUFFIXES: .obj .c

!ifdef DEBUG
LFLAGS = /DLL /EXEPACK:2 /MAP /NOLINENUMBERS /NOSEGORDER /OPTFUNC /DE
!else
LFLAGS = /DLL /EXEPACK:2 /MAP /NOLINENUMBERS /NOSEGORDER /OPTFUNC
!endif

all: distorm.dll:  \
  distorm.obj \
  decoder.obj \
  instructions.obj \
  insts.obj \
  operands.obj \
  prefix.obj \
  textdefs.obj \
  wstring.obj \
  x86defs.obj \
  $(MAKEFILE)
  @echo
  ilink @<<distorm.lrf
    $(LFLAGS)
    /OUT:distorm.dll
    distorm.obj
    decoder.obj
    instructions.obj
    insts.obj
    operands.obj
    prefix.obj
    textdefs.obj
    wstring.obj
    x86defs.obj
    distorm.def
<<KEEP
  @echo
  implib /nologo distorm.lib distorm.def
  @echo
  mapsym distorm
  mapxqs distorm

!ifdef DEBUG
CFLAGS = /Ge- /Gl+ /O+ /Q /Rn /Sm /Ss /W3 /Ti
!else
CFLAGS = /Ge- /Gl+ /O+ /Q /Rn /Sm /Ss /W3
!endif

{$(SRCDIR)}.c.obj:
  @echo
  icc $(CFLAGS) /C $<

distorm.obj:      $(MAKEFILE) $(INCDIR)\config.h
decoder.obj:      $(MAKEFILE) $(INCDIR)\config.h
instructions.obj: $(MAKEFILE) $(INCDIR)\config.h
insts.obj:        $(MAKEFILE) $(INCDIR)\config.h
operands.obj:     $(MAKEFILE) $(INCDIR)\config.h
prefix.obj:       $(MAKEFILE) $(INCDIR)\config.h
textdefs.obj:     $(MAKEFILE) $(INCDIR)\config.h
wstring.obj:      $(MAKEFILE) $(INCDIR)\config.h
x86defs.obj:      $(MAKEFILE) $(INCDIR)\config.h

