/************************************************************************/
/***                                                                  ***/
/*** AUTHOR :            RH                                           ***/
/***                                                                  ***/
/*** SHORT DESCRIPTION : header file for all non resource related     ***/
/***                     definitions of mtestpm.exe                   ***/
/***                                                                  ***/
/*** COPYRIGHT         : (C) 1995 a priori Computer Solutions GmbH    ***/
/***                                                                  ***/
/************************************************************************/

/*----------------------------------------------------------------------*/
/* includes                                                             */
/*----------------------------------------------------------------------*/

#include <setjmp.h>

/*----------------------------------------------------------------------*/
/* defines                                                              */
/*----------------------------------------------------------------------*/

#define  MESSAGELEN 80
#define  DUMP_BUFFER_LEN           4096L    /* 4K      */
#define  EXCEPTION              "An exception has occurred"

/*----------------------------------------------------------------------*/
/* typedefs                                                             */
/*----------------------------------------------------------------------*/

/* typedef for FNEH: an exception handler function  */
/* -----------------------------------------------  */

#ifdef __IBMC__
typedef ULONG _System FNEH( PEXCEPTIONREPORTRECORD,
#else
typedef ULONG _syscall FNEH( PEXCEPTIONREPORTRECORD,
#endif
                             PEXCEPTIONREGISTRATIONRECORD,
                             PCONTEXTRECORD,
                             PVOID );

typedef FNEH *PFNEH;

/* structures for Exception handling   */
/* ---------------------------------   */

/* typedef for the structure which is pointed to in exception record */
typedef struct __UserExcRec
  {

  PVOID       pvBuffer;                /* output buffer for debug  */
  jmp_buf     jmp;                     /* long jump buffer         */

  } _UserExcRec;

typedef _UserExcRec  *PUSEREXREC;

/* typedef for a handler registration record; a link in a list */
typedef struct __regrec
  {
  // these two fields are defined by os2 and required
  PEXCEPTIONREGISTRATIONRECORD pnext;
  PFNEH                        pfnHandler;

  // user-defined fields
  PUSEREXREC           pstUserExRec;   // pointer to user defined fields
  } _REGREC;

typedef _REGREC *PREGREC;

/*----------------------------------------------------------------------*/
/* declarations                                                         */
/*----------------------------------------------------------------------*/

/* miscellaneous helper functions of module misc.c */

VOID MiscDisplayMsg ( HWND   hwndOwner,
                      SHORT  idMsg,
                      SHORT  fsStyle,
                      BOOL   fBeep );

VOID MiscCenterDialog( HWND   hwndParent,
                       HWND   hwndDialog);

VOID MiscInitHelp(HWND hwnd);
VOID MiscDisplayHelp( ULONG   msg,
                      USHORT  usPanelId);
VOID MiscDestroyHelp(VOID);

/************************************************************************/
/*** EOF mtestpm.h                                                    ***/
/************************************************************************/
