/* The Object Factory DEMO version REXX installation */

Parse source . . __rexx_name;
__rexx_dir = Filespec('D',__rexx_name)||Filespec('P',__rexx_name)

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs';
Call SysLoadFuncs;           

system_dll = FileSpec('Drive', Value('SYSTEM_INI', ,'OS2ENVIRONMENT')) || '\OS2\DLL';

rc = SysDeregisterObjectClass('SOMNotebook');
Address CMD '@ERASE 'system_dll'\SOMNOTE.DLL 2>NUL';
Address CMD '@COPY '__rexx_dir'SOMNOTE.DLL 'system_dll;

If rc <> 0 Then
	Do;
	   Say  "Could not replace SOMNOTE.DLL";
           Exit;
        End;

rc = SysRegisterObjectClass('SOMNotebook', system_dll || '\SOMNOTE.DLL');

If rc <> 1 Then 
	Do;
           Say  "Could not register SOM Notebook, rc="rc".";
           Exit;
        End;
Else
	Say "SOM Notebook registered.";

rc = SysDeregisterObjectClass('ClassNotebook');
Address CMD '@ERASE 'system_dll'\CLSSNOTE.DLL 2>NUL';
Address CMD '@COPY '__rexx_dir'CLSSNOTE.DLL 'system_dll;

If rc <> 0 Then
	Do;
	   Say  "Could not replace CLSSNOTE.DLL";
           Exit;
        End;

rc = SysRegisterObjectClass('ClassNotebook', system_dll || '\CLSSNOTE.DLL');

If rc <> 1 Then 
	Do;
           Say  "Could not register Class Notebook, rc="rc".";
           Exit;
        End;
Else
	Say "Class Notebook registered.";

rc = SysDeregisterObjectClass('ClassTree');
Address CMD '@ERASE 'system_dll'\CLSSTREE.DLL 2>NUL';
Address CMD '@COPY '__rexx_dir'CLSSTREE.DLL 'system_dll;

If rc <> 0 Then
	Do;
	   Say  "Could not replace CLSSTREE.DLL";
           Exit;
        End;

rc = SysRegisterObjectClass('ClassTree', system_dll || '\CLSSTREE.DLL');

If rc <> 1 Then 
	Do;
           Say  "Could not register Class Tree, rc="rc".";
           Exit;
        End;
Else
	Say "Class Tree registered.";

COPY "*.HLP" "C:\OS2\HELP"
COPY "*.INF"  "C:\OS2\HELP"

rc=SysCreateObject('WPProgram','The Object Factory Help','<WP_DESKTOP>', ,
		     "EXENAME=VIEW.EXE;PARAMETERS=C:\OS2\HELP\SYNAPTEC.INF");

Say "";

If rc <> 1 Then 
	Do;
           Say  "Could not create help program object rc="rc".";
           Exit;
        End;
Else
	Say "Help added to desktop.";

Say "";
Say "All objects have successfully been added to your machine."

Say "";
Say "";

Say "Please enter a new directory name to place method tables: ";
Pull MethodDirectory;

rc = SysMkDir(MethodDirectory);

If rc <> 0 Then
	Do;
	   Say "Could not create directory "MethodDirectory;
	   Exit;
	End;

COPY "*.WPS" MethodDirectory;
COPY "*.MTH" MethodDirectory;

Say "";
Say "The Object Factory's DEMO version is now installed";
Say "";

Say "You will now have 2 new templates in your System Templates folder";
Say "";

Say "Before starting, you MUST add "MethodDirectory" to the PATH statement in CONFIG.SYS and reboot.";

Exit;
