/* -------------------------------------------------------------------

	Project: 

	Objective-C source file for the class Controller

	This file was automatically generated by OS/2 Project Builder
	COPYRIGHT (C), 1995, Thomas Baier

	Unregistered version

	COPYRIGHT (C), 1995
	ALL RIGHTS RESERVED.

	Date:                           Rev:
	Sat Oct 14 02:07:57 1995


------------------------------------------------------------------- */

/* ------------------------ Include files ------------------------- */
#include <pm/pm.h>
#include <db/db.h>
#include <stdlib.h>

/* ------------------------  Classes used  ------------------------ */


/* -------------------------  Externals  -------------------------- */


/* --------------------------  Defines  --------------------------- */


/* ----------------------  Class variables  ----------------------- */


/*====================================================================
                     Implementation of class Controller
====================================================================*/
#include "Controller.h"

@implementation Controller : Object
{
  id button;
  id container;
  id recordList;
  id database;
  id dialog;
}

/*====================================================================
                              Initialize
====================================================================*/


/*====================================================================
                                 Free
====================================================================*/


/*====================================================================
               Methods for access to Instance Variables
====================================================================*/


/*====================================================================
                            Public methods
====================================================================*/

/*--------------------------------------------------------------------
|-openFile: sender|

Return self.
--------------------------------------------------------------------*/
-openFile: sender
{
  id openDlg = [[FileDlg alloc] initForOpen: "Select database file"
		                 withFilter: "*.dbf"];
  unsigned long i;
  char buffer[1024];
  char fname[_MAX_FNAME],ext[_MAX_EXT];

  if (([openDlg runModalFor: dialog]) &&
      ([openDlg result] == DID_OK)) {

    if (database) {
      [container removeAllRecords: nil];
      [container removeAllColumns: nil];

      [[recordList freeObjects] free];
      [database free];

      recordList = nil;
    }

    database = [[DBFile alloc] init: [openDlg fileName]];

    if (!database) {
      WinMessageBox (HWND_DESKTOP,HWND_DESKTOP,
		     "File not found!","Database viewer",0,MB_OK | MB_WARNING);
      [openDlg free];
      [dialog setTitle: "Database Viewer - no file"];
      return nil;
    }

    [container detailView: sender];

    for (i = 0;i < [database fieldCount];i++) {
      [container addColumn: (char *) [[database field: i] propertyName]];
      [container setColumnTitleAttributes: [container columnTitleAttributes]
       | CFA_FITITLEREADONLY];
      [container setColumnDataAttributes: [container columnDataAttributes]
       | CFA_FIREADONLY];
    }

    recordList = [[DBList alloc] initForEntity: database];

    [recordList fetchAllRecords: nil];

    [container insertObjectList: recordList];

    [container invalidate];

    _splitpath ([openDlg fileName],NULL,NULL,fname,ext);

    sprintf (buffer,"Database Viewer - %s%s",fname,ext);
    [dialog setText: buffer];
  }

  [openDlg free];
  return self;
}


/*====================================================================
                           Private methods
====================================================================*/
/*--------------------------------------------------------------------
|-awakeFromInterfaceFile| 

Return self.
                                                          /1995-Oct-15
--------------------------------------------------------------------*/
-awakeFromInterfaceFile
{
  [container setSize: 0:0:[dialog width]:[dialog height]];
  [dialog bindCommand: 2000 withObject: self selector: @selector(openFile:)];
  return self;
}


/*--------------------------------------------------------------------
|-parse: (char **) argv count: (int) argc| 

Return self.
                                                          /1995-Oct-24
--------------------------------------------------------------------*/
-parse: (char **) argv count: (int) argc
{
  int i,j;

  for (i = 1;i < argc;i++)
    if (fileExists (argv[i])) {
      char buffer[1024];
      char fname[_MAX_FNAME],ext[_MAX_EXT];

      database = [[DBFile alloc] init: argv[i]];

      if (!database) {
	WinMessageBox (HWND_DESKTOP,HWND_DESKTOP,
		       "File not found!","Database viewer",0,
		       MB_OK | MB_WARNING);
	[dialog setTitle: "Database Viewer - no file"];
	return nil;
      }

      [container detailView: dialog];

      for (j = 0;j < [database fieldCount];j++) {
	[container addColumn: (char *) [[database field: j] propertyName]];
	[container setColumnTitleAttributes: [container columnTitleAttributes]
	 | CFA_FITITLEREADONLY];
	[container setColumnDataAttributes: [container columnDataAttributes]
	 | CFA_FIREADONLY];
      }

      recordList = [[DBList alloc] initForEntity: database];

      [recordList fetchAllRecords: nil];

      [container insertObjectList: recordList];

      [container invalidate];

      _splitpath (argv[i],NULL,NULL,fname,ext);

      sprintf (buffer,"Database Viewer - %s%s",fname,ext);
      [dialog setText: buffer];
      return self;
    }

  return self;
}


/*====================================================================
                          Archiving methods
====================================================================*/


@end
