/*------------------------------------------------------------------------*\
|                                                                          |
|           WINATMON.CMD - Version 1.0 - Version Date 1995-09-04           |
|                 Copyright (C) 1995 by C F S Nevada, Inc.                 |
|                                                                          |
|                  by Dick Goran  - Voice    702-732-9616                  |
|                                 - FAX      702-732-3847                  |
|                                 - CIS      71154,2002                    |
|                                 - Internet dgoran@cfsrexx.com            |
|                                 - WWW      <http://www.cfsrexx.com>      |
|                                                                          |
| ------------------------------------------------------------------------ |
|  Requires: REXXLIB.DLL  - OS/2 REXX external function library            |
|                           (c) Copyright 1992-95 Quercus Systems          |
|            WPTOOLS.DLL  - Henk Kelder (freeware)                         |
\*------------------------------------------------------------------------*/
/*

   This program will identify all WIN-OS/2 objects defined to the system
   via the PM_Abstract:Objects application name in the OS2.INI file.

   It will create a WINATMON.TXT in the same directory where this program
   exists. This file will contain the title, location, and updated setup
   string for only those WPProgram objects that are updated by this program.

   Each object's setup string will be checked, using WPTOOLS, for the
   WIN_ATM setup string. If WIN_ATM=n is omitted or if WIN_ATM=0 the
   object's setup string will be updated via REXXLIB.

   The version of REXXLIB included in this package is a demo version that
   will function correctly for only 30 distinct days from the time of its
   first use. REXXLIB is a program product from Quercus Systems and is
   used here with their expressed permission. Use beyond the 30 day limit
   requires purchase of a licensed copy of REXXLIB from Quercus Systems.

      Quercus Systems
      P.O. Box 2157
      Saratoga, CA 95070
      408-867-REXX (voice)
      408-867-7489 (FAX)
      408-867-7488 (BBS)
      CIS, PCVENA, Sec 11 (Charles Daney 75300,2450)
      <http://www.quercus-sys.com>

*/

GBL. = ''             /* initialize stem */
parse Arg             GBL.command_line
parse Version         GBL.REXX_version .
parse Source          GBL.operating_system,
                      GBL.calling_environment,
                      GBL.program_path_and_name
GBL.environment     = 'OS2ENVIRONMENT'
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_version = 1.0           /* version / mod of this program */
GBL.program_name    = FILESPEC( 'N', GBL.program_path_and_name )
GBL.program_path    = FILESPEC( 'D', GBL.program_path_and_name ) ||,
                      FILESPEC( 'P', GBL.program_path_and_name )

parse var GBL.program_name,
   GBL.program_fn '.',
   GBL.program_fe
call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
say 'Begin' TRANSLATE( GBL.program_name ) 'at' TIME('N')

/*------------------------*\
|  Enable trap processing  |
\*------------------------*/
   SIGNAL ON ERROR
   SIGNAL ON FAILURE
   SIGNAL ON HALT
   SIGNAL ON NOVALUE
   SIGNAL ON SYNTAX

/*---------------*\
|  Register APIs  |
\*---------------*/
/* REXXUTIL */
if RxFuncQuery( 'SysLoadFuncs' ) = 0 then
   do
      call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
      call SysLoadFuncs
   end

/* REXXLIB - (c) Quercus Systems */
if RxFuncQuery( 'rexxlibregister' ) = 0 then
   do
      if GBL.REXX_version = 'REXX/Personal' then
         do
            dll_name = 'QREXXLIB'
         end
      else
         do
            dll_name = 'REXXLIB'
         end
      call RxFuncAdd 'REXXLibRegister', dll_name, 'rexxlibregister'
      call REXXLibRegister
   end

/* WPTOOLS - Henk Kelder */
if RxFuncQuery( 'WPToolsLoadFuncs' ) = 0 then
   do
      call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
      call WPToolsLoadFuncs
   end

/*----------------------------------*\
|  Output file is program name .TXT  |
\*----------------------------------*/
GBL.output_file =,
   GBL.program_path ||,
   GBL.program_fn || '.TXT'
call SysFileDelete GBL.output_file

/*--------------------------*\
|  Windows PROGTYPE= values  |
\*--------------------------*/
windows_progtype_list =,
   'PROG_31_ENH',
   'PROG_31_ENHSEAMLESSCOMMON',
   'PROG_31_ENHSEAMLESSVDM',
   'SEPARATEWIN',
   'WIN',
   'WINDOWEDWIN',
   ''

/*-----------------------------------------*\
|  Get list of object handles from OS2.INI  |
\*-----------------------------------------*/
app = 'PM_Abstract:Objects'
call SysIni 'USER', app, 'ALL:', 'handle_stem'
if handle_stem.0 = 0 then
   do
      say '   Unable to locate ' ||,
          app                    ||,
          ' in '                 ||,
          VALUE( 'USER_INI',, 'OS2ENVIRONMENT' )
      call EOJ
   end

/*---------------------------------------*\
|  Process each PM_Abstract:Object entry  |
\*---------------------------------------*/
!tr! = VALUE('TRACE',,GBL.environment); if !tr! <> '' then do; TRACE(!tr!); nop; end
do h = 1 to handle_stem.0
   hex_handle = handle_stem.h
   dec_handle = X2D( '2' || RIGHT( hex_handle, 4, '0' ) )

   /*-----------------------------*\
   |  Process each program object  |
   \*-----------------------------*/
   hex_handle_string = '#2' || RIGHT( hex_handle, 4, '0' )
   call WPToolsQueryObject hex_handle_string,,
                           'class',,
                           'title',,
                           'setup_string',,
                           'location'
   if RESULT = 0 then
      do
         say '   WPToolsQueryObject was unsuccessful for object ' ||,
             hex_handle_string                                    ||,
             ' object ignored.'
         iterate h                  /* ignore this object */
      end

   /*-----------------------------------------------------*\
   |  Identify Windows or WIN-OS/2 programs via PROGTYPE=  |
   \*-----------------------------------------------------*/
   parse value setup_string with,
      'PROGTYPE=',
      object_progtype,
      ';'
   if object_progtype = '' then
      do
         iterate h                  /* ignore this object */
      end

   /* See if PROGTYPE value is in table */
   if WORDPOS( object_progtype, windows_progtype_list ) = 0 then
      do
         iterate h                  /* ignore this object */
      end

   /*----------------------------------------*\
   |  Ignore object if WIN_ATM=1 already set  |
   \*----------------------------------------*/
   win_atm_search_arg = 'WIN_ATM='
   win_atm_ptr        = POS( win_atm_search_arg, setup_string )
   if win_atm_ptr > 0 then
      do
         win_atm_value =,
             SUBSTR( setup_string,,
                     win_atm_ptr + LENGTH(win_atm_search_arg),,
                     1 )
         if win_atm_value = 1 then
            do
               iterate h            /* ignore this object */
            end
      end
      call UPDATE_SETUP_STRING

end
call STREAM GBL.output_file, 'C', 'CLOSE'

call EOJ 0


/*------------------------------------------------------------------------*\
|                                                                          |
|                Subroutine to update object's setup string                |
|                                                                          |
\*------------------------------------------------------------------------*/
UPDATE_SETUP_STRING:

output_line =,
   LEFT( title,    18 ),
   LEFT( location, 25 ),
   setup_string
call LINEOUT GBL.output_file, output_line

/* waiting for REXXLIB */
call WPSSetObjectData dec_handle, 'SET WIN_ATM=1;'
if RESULT = 1 then
   do
      say '   Unable to update setup string for ' ||,
          title                                   ||,
          ' (' || hex_handle_string || ')'
   end
return


/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:
   Procedure expose,
      GBL.

if ARG() = 0 then
   eoj_rc = 0
else
   eoj_rc = ARG(1)

elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds
if LEFT( micro_seconds, 1, 1 ) >= 5 then
   seconds = seconds + 1
ss = FORMAT( seconds // 60, 2 )
minutes = ( seconds - ss ) / 60
mm = FORMAT( minutes // 60, 2 )
hh = FORMAT( ( minutes - mm ) / 60, 2 )
duration = hh':'mm':'ss

program_name = TRANSLATE( FILESPEC( 'N', GBL.program_path_and_name ) )
say 'EOJ  ' program_name 'at' TIME('N') ||,
    ', duration' TRANSLATE( duration, '0', ' ' )
exit eoj_rc

/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC

/* Rev. 95/07/29 */
TRAP_PROCESSING:
   parse Source . . TRAP.path_and_program
   trap.line_nbr = ARG(1)
   if POS( ':', TRAP.path_and_program ) > 0 then
      /* get source line if it is available */
      do t = 1
         trap_source_line.t =  SOURCELINE( trap.line_nbr )
         trap_source_line.0 = t
         trap.line_nbr      = trap.line_nbr + 1
         if RIGHT( trap_source_line.t, 1 ) = ',' then
            do
               leave
            end
      end
   else
      /* program is running in macrospace */
      do
         TRAP.path_and_program = VALUE( 'TEMP',, 'OS2ENVIRONMENT' ) ||,
                                 '\' || TRAP.path_and_program
         trap_source_line.1 = 'Source line is not available.'
         trap_source_line.0 = 1
      end

   parse value FILESPEC( 'N', TRAP.path_and_program ) with,
      TRAP.fn '.' TRAP.fe
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,
                    FILESPEC( 'P', TRAP.path_and_program ) ||,
                    TRAP.fn || '.' || 'DMP'

   /*------------------------------------------*\
   |  check for reason not to create .DMP file  |
   \*------------------------------------------*/
   if ARG(2) = 'HALT' then
      do
         trap_file_name = ''
      end
   if RxFuncQuery( 'VARDUMP' ) <> 0 then
      do
         trap_file_name = ''
      end
   if POS( ':', trap_file_name ) = 0 then
      do
         trap_file_name = ''
      end

   /*------------------------*\
   |  Build trap message box  |
   \*------------------------*/
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   trap.red = '1B'x || '[1;37;41m'  /* bright white on red          */
   trap.dul = '1B'x || '[0m'        /* reset to normal              */

   say ' '
   trap_error_description =,
      'Error line = ' || ARG(1) ||,
      '; ' ||,
      ARG(2) ||,
      ' error.'
   if ARG(3) <> '' then
      trap_error_description = trap_error_description ||,
                               '  Return code = ' || ARG(3)
   trap.width = MAX( 74, LENGTH( trap_error_description ) )
   say trap.red || dbl.tl || COPIES( dbl.h,trap.width + 2 ) || dbl.tr || trap.dul
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( TRAP.fn'.CMD',trap.width )    dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( trap_error_description, trap.width ) dbl.v || trap.dul
   if trap_file_name <> '' then
      do
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v     CENTER( 'See: ' || trap_file_name,,
                                     trap.width )  dbl.v  || trap.dul
      end
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.bl || COPIES( dbl.h,trap.width + 2 ) || dbl.br || trap.dul
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul
   say trap.red || LEFT( 'Source line(s) at time of trap:', trap.width + 4 ) || trap.dul
   do t = 1 to trap_source_line.0
      say trap.red || LEFT( '   ' || trap_source_line.t, trap.width + 4 ) || trap.dul
   end
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul

   /*---------------------------------*\
   |  Create .DMP file if appropriate  |
   \*---------------------------------*/
   if trap_file_name <> '' then
      do
         call SysFileDelete trap_file_name
         /* remove meaningless labels from dump for clarity */
         drop dbl. TRAP. RC RESULT SIGL !tr!
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end
   exit 253
