#include <iframe.hpp>
#include <inotebk.hpp>
#include <icombobx.hpp>
#include <ilistbox.hpp>
#include <ispintxt.hpp>
#include <ipushbut.hpp>
#include <iradiobt.hpp>
#include <icheckbx.hpp>
#include <icmdhdr.hpp>
#include <iselhdr.hpp>
#include <ientryfd.hpp>
#include <ithread.hpp>
#include "notebook.h"
#include "\work\modemengine\modemengine.hpp"

class GeneralSettings : public IFrameWindow
                       ,public ICommandHandler
                       ,public ISelectHandler
                       {
public:
  GeneralSettings(unsigned long windowId);
  ~GeneralSettings();

private:
  IResourceLibrary reslib;
  INotebook      notebook;
  IPageHandle    tab1, tab2, tab3, tab4;
  IFrameWindow   wnd_tab1, wnd_tab2, wnd_tab3, wnd_tab4;
  IComboBox      comPort;
  IListBox       testOutput, statOutput, messages;
  ITextSpinButton quality, silenceVal, rings;
  ICheckBox      monitor, silenceDet, silenceDel, startOn, startMin;
  IPushButton    testbtn;
  IRadioButton   singleMbx, multipleMbx, powerOn, powerOff;
  IThread        testThread, answerThread;
  IEntryField    greeting;
  GeneralSettings (const GeneralSettings &);
GeneralSettings
  &operator= (const GeneralSettings &);
void
  loadSettings();
void
  saveSettings();
void
  saveTest(IListBox&);
void
  modemTest();
void
  selectGreeting();
void
  modemAnswer();
void
  modemTestThread();
void
  modemAnswerThread();
MODEM_ENGINE::MODEMRESPONSE
  modemResponse (MODEM_ENGINE & me, IListBox * lb, int timeout=600);
enum _power {off, on};
  _power power;

protected:
  Boolean command(ICommandEvent &cmdEvent);
  Boolean systemCommand(ICommandEvent &cmdEvent);
  Boolean selected(IControlEvent &event);
};
