;********************************************************************
;
; os2nlok - OS/2 Device driver to turn off NumLock state of keyboard.
;          Performs its function at initialization, does not
;          install itself.
;
; Copyright (c) 1988 PC Tech Journal and Ziff Communications Co.
;
;                   Written by Ted Mirecki
;
;********************************************************************

           .286                   ;enables 'push immediate' instr.

;********************************************************************
; Declarations:  OS/2 API functions;
;                Device driver request packet:
;                    - standard request header 
;                    - header extension specific to init request
;                Bimodal address of request packet is in ES:BX
;                at entry to strategy routine.  
;********************************************************************

           extrn   DosPutMessage:Far
           extrn   DosDevIOCTL:Far
           extrn   DosOpen:Far
           extrn   DosClose:Far

devpacket  struc                  ;Device driver request packet
req_len    db      ?              ;standard request packet header
req_unit   db      ?
req_comm   db      ?
req_status dw      ?
req_res    dd      ?
req_queue  dd      ?
                                  ;rest of packet for init request:
init_data1 db      ?              ;block count (zero for char device)
init_ecode dw      ?              ;resident segment lengths
init_edata dw      ?
init_ptr2  dd      ?              ;unused by char device
devpacket  ends

;********************************************************************
; DATA segment:  begin w/device header, follow w/local data
; 
; Use explicit segment declarations, not simplified ones,
;    to ensure proper segment order (data segment first).
;********************************************************************

data       segment
           assume ds:data
                                  ;DEVICE DRIVER HEADER:
devhdr     dd      -1             ;device header linkage
devattr    dw      8080h          ;bit 15 = char device,
                                  ;bit  7 = OS/2 driver
deventry   dw      offset strategy     ;offset in code segment
           dw      ?              ;reserved
devname    db      'OS2NLOK '     ;device name, must be 8 chars
           db      8 dup (?)      ;reserved
                                  ;end of header
CR         equ     0Dh
LF         equ     0Ah
RESET      equ     not 20h        ;reset num lock bit

signon     db      CR, LF, 'Numeric Unlock, OS/2 version', CR, LF
           db      '  Copyright (c) 1988 PC Tech Journal and'
           db      ' Ziff Communications Co.', CR, LF
           db      '  Written by Ted Mirecki', CR, LF, LF
lenmsg     equ     $-signon
                                  ;data for open call
kbd        db      'KBD$', 0
handle     dw      ?
action     dw      ?
                                  ;data area for IOCTL calls
shift      dw      ?              ;word for shift flags
nls        db      ?              ;byte for NLS shift status

data       ends

;********************************************************************
; CODE segment: strategy routine, performs initialization only.
; Processing: 1. Display message
;             2. Open KBD$ device
;             3. Get shift state w/IOCTL call
;             4. Change NumLock, call IOCTL to set shift state
;             5. Close KBD$ device
;             6. Return to kernel without installing.  
;********************************************************************

code       segment 'code'
           assume  cs:code
strategy   proc    far

; 1. call DosPutMessage(0, lenmsg, @signon)           
           push    1              ;handle 1 = std output
           push    lenmsg
           push    ds             ;far address of message
           push    offset signon
           call    DosPutMessage

; 2. call DosOpen("KBD$", @handle, @action, 0L, 0, 1, 12h, 0L)
           push    ds
           push    offset kbd     ;device name
           push    ds
           push    offset handle  ;returned handle
           push    ds
           push    offset action  ;returned new/existed flag
           xor     ax,ax
           push    ax             ;initial file length = dword 0
           push    ax
           push    ax             ;file attribute = word 0
           push    1              ;fail if file non-existent
           push    12h            ;not sharable, r/w access
           push    ax             ;reserved: dword zero
           push    ax
           call    DosOpen

; 3. Get shift status for handle opened above:
;    call DosDevIOCTL(@data, @parm, function, category, handle)
           push    ds             ;far addr of data area
           push    offset shift
           push    ds             ;use same addr as parm area
           push    offset shift
           push    73h            ;function 73: get shift status
           push    4              ;category 4: keyboard IOCTL
           push    handle         ;handle from previous open call
           call    DosDevIOCTL

; 4. Reset NumLock bit, call DosDevIOCTL as above to set shift status
           and     shift,RESET    ;reset bit in Kbd status word
           push    ds             ;far addr of data area
           push    offset shift
           push    ds             ;use same addr as parm area
           push    offset shift
           push    53h            ;function 53: set shift status
           push    4              ;category 4: keyboard IOCTL
           push    handle
           call    DosDevIOCTL

; 5. Close the KBD$ handle: call DosClose(handle)
           push    handle
           call    DosClose

; 6. Terminate w/o installing
           xor     ax,ax          ;set code & data lengths to zero
           mov     es:[bx].init_data1,ah
           mov     es:[bx].init_ecode,ax
           mov     es:[bx].init_edata,ax
           mov     es:[bx].req_status,810Ch ;set return status:
                                            ; bit 15 = error
                                            ; bit  8 = done
                                            ; bits 0-7 = error code
           ret
strategy   endp
code       ends
           end
