; ASKSYS.ASM - Implements dual-boot w/timeout for DOS & OS/2
;
; Copyright (C) 1988 Ziff Communications Co. and PC Tech Journal
; Written by Ted Mirecki
;
; Set default system by value of label DEFAULT
; Set timeout interval by value of label SECONDS

OS2        equ     13             ;Enter key starts OS/2
DOS        equ     27             ;Esc key starts DOS
DEFAULT    equ     DOS            ;If neither key pressed
SECONDS    equ     15             ;Timeout interval

group1     group   code,data
           assume  cs:group1, ds:group1

code       segment byte public    ;establish code segment first
code       ends

data       segment word           ;but define data seg first
time       dw      SECONDS*18
oldint8    label   dword
int8off    dw      0
int8seg    dw      0
bootaddr   dd      7C00h          ;0000:7C00h
msg$       db      "OS/2 - DOS Dual Boot feature", 0Dh, 0Ah
           db      "Copyright (C) 1988 Ziff Communications Co. "
           db      "and PC Tech Journal", 0Dh, 0Ah, 0Ah
           db      "Boot: Enter = OS/2, Esc = DOS", 0Dh, 0Ah, 7, 0
           even
dosboot    db      'QQQQ'         ;marker for patching in boot rec
           db      508 dup (0)    ;space for rest of boot rec
os2boot    db      512 dup (0)    ;space for other bootrec
data       ends

code       segment byte public    ;resume same code segment
asksys     proc
           push    ax
           push    bx
           push    cx
           push    si
           push    di
           push    ds
           push    es
           mov     ax,cs          ;set ds to code segment
           mov     ds,ax
           lea     si,msg$        ;get address of message
boot1:     lodsb
           or      al,al          ;null byte = end of message
           jz      boot2
           mov     ah,0Eh         ;write TTY function
           int     10h            ;BIOS video call
           jmp     boot1          ;loop til end of message
           int8 = 8*4             ;address of int 8 vector
boot2:     xor     ax,ax
           mov     es,ax          ;ES --> interrupt table
           mov     ax,es:int8     ;get int 8 address
           mov     bx,es:int8+2
           mov     int8off,ax     ;save it
           mov     int8seg,bx
           lea     bx,timertick   ;address of timer routine
           cli                    ;hold off interrupts
           mov     es:int8,bx     ;set timer interrupt
           mov     es:int8+2,cs
           sti                    ;allow interrupts
boot3:     mov     ah,1           ;get keyboard status
           int     16h
           jnz     boot4          ;key pressed if no zero flag
           cmp     time,0         ;else test for timeout
           jg      boot3          ;no timeout: test kb again
           mov     al,DEFAULT     ;set default keystroke
           jmp     short boot5    ;go process it
boot4:     xor     ah,ah          ;get the keystroke
           int     16h
           cmp     al,27          ;is it escape?
           je      boot5
           cmp     al,13          ;is it return?
           jne     boot3          ;if neither, read kb again
boot5:     mov     bx,int8off     ;get original int 8 vector
           mov     cx,int8seg
           cli
           mov     es:int8,bx     ;restore it in vector table
           mov     es:int8+2,cx
           sti
           lea     si,dosboot     ;load DOS boot record address
           cmp     al,27          ;escape = DOS
           je      boot6
           lea     si,os2boot     ;else load OS2 boot rec address
boot6:     les     di,bootaddr    ;ES:DI --> load addr for boot rec
           mov     cx,256         ;length of boot rec in words
           rep     movsw          ;insert boot rec at boot address
           pop     es             ;exit sequence
           pop     ds
           pop     di
           pop     si
           pop     cx
           pop     bx
           pop     ax
           jmp     cs:bootaddr    ;branch to boot record
asksys     endp

; Int 8, timer tick hardware interrupt, is repointed here.
; This routine counts down a time value and chains to original INT 8.

timertick  proc
           dec     cs:time
           jmp     cs:oldint8
timertick  endp
code       ends
           end
