/*******************************************************************
 * test.c                                                          *
 *******************************************************************
 * A test app to use the driver1 sample.                           *
 *******************************************************************
 * Warpstock Europe 1999                                           *
 * PDD workshop                                                    *
 *******************************************************************
 * Frank Meilinger                                                 *
 * Hirtesemuehle 1                                                 *
 * 65529 Waldems-Esch                                              *
 * e-mail: meilinger@wiesbaden.netsurf.de                          *
 * web: http://rover.wiesbaden.netsurf.de/~meile                   *
 *******************************************************************/

#define INCL_DOSFILEMGR
#include <os2.h>
#include <stdio.h>

int main(int argc, char *argv[])
{
 FILE *cfh;
 int  cret;
 char *p;
 char buffer[256];

 puts("\nWarpstock Europe 1999 !!!");
 puts("DRIVER1$ test application for driving the printer port\n");
 printf("open device: ");
 cfh = fopen("DRIVER1$","wb+");
 if (cfh == NULL)
 {
  puts("error!\n");
  return 1;
 }
 else
  puts("ok\n");

 puts("commands: r    -> read byte from 0x379 in hex notation");
 puts("          1    -> write byte 0xff to 0x378");
 puts("          0    -> write byte 0x00 to 0x378");
 puts("          q    -> quit\n");

 while(1)
 {
  printf("\ncommand: ");
  fflush(stdout);
  p = gets(buffer);

  if( (p==NULL) || (p[0]=='q') )
   break;

  if(p[0] == 'r')
  {
   cret = fgetc(cfh);
   fflush(cfh);
   if(cret == EOF)
    puts("echo read: error!");
   else
    printf("echo read: %x\n",cret);
   continue;
  }

  if(p[0] == '1')
  {
   cret = fputc(0xff,cfh);
   fflush(cfh);
   if(cret == EOF)
    puts("echo write 0xff: error!");
   else
    printf("echo write 0x%x: ok\n",cret);
   continue;
  }

  if(p[0] == '0')
  {
   cret = fputc(0x00,cfh);
   fflush(cfh);
   if(cret == EOF)
    puts("echo write 0x00: error!");
   else
    printf("echo write 0x%x: ok\n",cret);
   continue;
  }
 }
 puts("echo quit!\n");

 printf("close device: ");
 cret = fclose(cfh);
 if(cret)
 {
  puts("error!\n");
  return 1;
 }
 else
  puts("ok\n");

 return 0;
}

