
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.24
 */

/*******************************************************************************
* FILE NAME: sdb.cpp														
*																			
* DESCRIPTION:																
*	Class implementation of the class:										
*	  Sdb- a SOM compliant database 										
*******************************************************************************/

/*
 *	This file was generated by the SOM Compiler and Emitter Framework.
 *	Generated using:
 *		SOM Emitter emitxtm: 2.42
 */

#ifndef SOM_Module_sdb_Source
#define SOM_Module_sdb_Source
#endif
#define Sdb_Class_Source

#include "sdb.xih"
#include "general.h"
#include "isam.hpp"
#include <istring.hpp>

#define		MAXFIELDS			100
#define		FIELDDELIM			';'
#define		ERRORVALUE			-1
#define		ERROROFFSET			1000
#define		PHYSICALINDEX		-1
#define		NOLOCKID			-1
#define		IMPORTBUFSIZE		1000
#define		PHYSICALINDEXNAME	"physical index"
#define		NOIMPORTINDEX		-1

static char* SdbFields[MAXFIELDS];

/* Local prototypes */

uint unpackTokens(char* str, char delimiter, char* tokens[]);
uint indexNumber(ISAM* db, char* indexName);
short fieldNumber(ISAM* db, char* fieldName);
void removeChars(char* inStr, char* outStr);
boolean getImportFields(char* fieldNames[], char* fields[], ISAM* db);
void getImportIndexes(char* fieldNames[], short fieldIndexes[], ISAM* db);
boolean getImportFields(char* fieldNames[], short fieldIndexes[],
						char* fieldValues[], ISAM* db);

#ifdef __IBMC__
	#pragma linkage (SOMInitModule, system)
#endif

//------------------------------------------------------------------------------
// Sdb :: create
//
// Operation: Create in current directory and opens for exclusive access, read
// and modify.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK create(Sdb *somSelf,  Environment *ev, string dbName,
								  string fieldSpecs, short blockSize) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","create");

	IString specsCopy(fieldSpecs);
	uint numFields = unpackTokens(specsCopy.operator char*(), FIELDDELIM, SdbFields);
	if (numFields > MAXFIELDS) {
		somThis->iResult = Sdb_TOOMANYFIELDS + ERROROFFSET;
	} else if (numFields == 0) {
		somThis->iResult = Sdb_NOFIELDS + ERROROFFSET;
	} else {
	  	ISAM* db = (ISAM*) somThis->iDb;
	  	if (blockSize == 0) blockSize = DEFAULT_BLKSIZE;
	  	somThis->iReadOnly = false;
	  	somThis->iShare = false;
	  	strcpy(somThis->iName, dbName);
	  	somThis->iResult = db->create(dbName, SdbFields, blockSize);
	  	if (somThis->iResult == I_OK) {
			somThis->iResult = somSelf->selectIndex(ev, PHYSICALINDEXNAME);
	  	}
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: unpackTokens
//
// Operation: Unpack terminated tokens from a string.
//------------------------------------------------------------------------------
uint unpackTokens(char* str, char delimiter, char* tokens[]) {
	IBoolean emptyToken, emptyStr = true;
	uint curToken = 0;
	tokens[curToken] = str;
	while (*str != TERM) {
		if (*str == delimiter) {
			*str = TERM;
			str += 1;
	  		curToken += 1;
	  		emptyStr = false;
	  		emptyToken = true;
	  		tokens[curToken] = str;
		} else {
	  		str += 1;
	  		emptyStr = false;
	  		emptyToken = false;
		}
  	}
  	if (emptyToken) {
		tokens[curToken] = (char*) NULL;
  	} else {
		tokens[curToken + 1] = (char*) NULL;
  	}
  	if (!emptyStr && !emptyToken) curToken += 1;
  	return curToken;
}

//------------------------------------------------------------------------------
// Sdb :: open
//
// Operation: Open from current directory.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK open(Sdb *somSelf,  Environment *ev, string dbName,
								boolean readOnly, boolean share) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","open");

	ISAM* db = (ISAM*) somThis->iDb;
	uint mode;
	if (readOnly && share) {
		mode = I_SHARE | I_READONLY;
	} else if (readOnly) {
	  	mode = I_READONLY;
	} else if (share) {
	  	mode = I_SHARE;
	} else {
	  	mode = 0;
	}
	somThis->iReadOnly = readOnly;
	somThis->iShare = share;
	strcpy(somThis->iName, dbName);
	somThis->iResult = db->open(dbName, mode);
	if (somThis->iResult == I_OK) somThis->iResult =
									somSelf->selectIndex(ev, PHYSICALINDEXNAME);
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: close
//
// Operation: Close.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK close(Sdb *somSelf,	Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","close");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->close();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: destroy
//
// Operation: Delete from current directory.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK destroy(Sdb *somSelf,  Environment *ev, string dbName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","delete");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->destroy(dbName);
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: lastStatus
//
// Operation: Return last status.
//------------------------------------------------------------------------------
SOM_Scope Sdb_Status  SOMLINK lastStatus(Sdb *somSelf,	Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","lastStatus");

	Sdb_Status status;
	switch (somThis->iResult) {
		case I_OK:
			status = Sdb_OK;
			break;
	  	case I_BUSY:
	   	 	status = Sdb_NOLOCK;
			break;
	  	case I_BOI:
			status = Sdb_ATINDEXSTART;
			break;
	  	case I_EOI:
			status = Sdb_ATINDEXEND;
			break;
	  	case I_ERROR:
			status = Sdb_ERROR;
			break;
	  	case I_FOUND:
			status = Sdb_FOUND;
			break;
	  	case I_NOTFOUND:
			status = Sdb_NOTFOUND;
			break;
	  	case (Sdb_TOOMANYFIELDS + ERROROFFSET):
			status = Sdb_TOOMANYFIELDS;
			break;
	  	case (Sdb_TYPEMISMATCH + ERROROFFSET):
			status = Sdb_TYPEMISMATCH;
			break;
	  	case (Sdb_NOFIELDS + ERROROFFSET):
			status = Sdb_NOFIELDS;
			break;
	}
	return status;
}

//------------------------------------------------------------------------------
// Sdb :: addRec
//
// Operation: Add record.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK addRec(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","addRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->addRec();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: getRec
//
// Operation: Get record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK getRec(Sdb *somSelf,  Environment *ev, boolean lock) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","getRec");

	ISAM* db = (ISAM*) somThis->iDb;
	short Lock = (lock ? I_LOCK : 0);
	somThis->iResult = db->getRec(Lock);
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: delRec
//
// Operation: Delete record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK delRec(Sdb *somSelf,  Environment *ev)
{
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","delRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->delRec();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: findHeadRec
//
// Operation: Find head record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK findHeadRec(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","findHeadRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->findHead();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: findNextRec
//
// Operation: Find next record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK findNextRec(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","findNextRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->findNext();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: findPrevRec
//
// Operation: Find previous record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK findPrevRec(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","findPrevRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->findPrev();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: findTailRec
//
// Operation: Find tail record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK findTailRec(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","findTailRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->findTail();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: modRec
//
// Operation: Modify record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK modRec(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","modRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->modRec();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: createIndex
//
// Operation: Create an index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK createIndex(Sdb *somSelf,  Environment *ev,
									   string indexName, string indexFields) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","createIndex");

	IString fieldsCopy(indexFields);
	uint numFields = unpackTokens(fieldsCopy.operator char*(), FIELDDELIM,
								  SdbFields);
	if (numFields == 0) {
	  	somThis->iResult = Sdb_NOFIELDS + ERROROFFSET;
	} else {
	  	ISAM* db = (ISAM*) somThis->iDb;
	  	somThis->iResult = db->index(indexName, SdbFields);
	  	db->close();
	  	somThis->iResult = somSelf->open(ev, somThis->iName, somThis->iReadOnly,
									somThis->iShare);
	  	if (somThis->iResult == I_OK) somThis->iResult =
	  									somSelf->selectIndex(ev, indexName);
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: selectIndex
//
// Operation: Select index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK selectIndex(Sdb *somSelf,  Environment *ev,
									   string indexName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","selectIndex");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->selectIndex(indexName);
	if (somThis->iResult == I_OK) {
	  	uint indexNum = indexNumber(db, indexName);
	  	if (indexNum != ERRORVALUE) {
			somThis->iCurIndex = indexNum;
			strcpy(somThis->iCurIndexName, indexName);
	  	} else somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: indexNumber
//
// Operation: Return index number.
//------------------------------------------------------------------------------
uint indexNumber(ISAM* db, char* indexName) {
  	IBoolean found = false;
  	uint indexNum;
  	IString name(indexName);
  	name.lowerCase();
  	IString anIndexName;
  	StrList indexes = db->getIndexNameList();
  	indexNum = 0;
  	while (indexes[indexNum] != NULL) {
   		anIndexName = indexes[indexNum];
		anIndexName.lowerCase();
		if (!anIndexName.isLike(name)) {
	  		indexNum += 1;
		} else {
	  		found = true;
	  		break;
		}
	}
  	if (!found) indexNum = ERRORVALUE;
  	return (indexNum);
}

//------------------------------------------------------------------------------
// Sdb :: deleteIndex
//
// Operation: Delete index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK deleteIndex(Sdb *somSelf,  Environment *ev,
									   string indexName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","deleteIndex");

	ISAM* db = (ISAM*) somThis->iDb;
	if (strcmp (somThis->iCurIndexName, indexName) == 0) {
	  	somThis->iResult = I_ERROR;
	} else {
	  	somThis->iResult = db->removeIndex(indexName);
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: binaryFieldLen
//
// Operation: Return binary field length.
//------------------------------------------------------------------------------
SOM_Scope short  SOMLINK binaryFieldLen(Sdb *somSelf,  Environment *ev,
										string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","binaryFieldLen");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->getFieldLength(fieldName);
	short result;
	if (somThis->iResult == I_ERROR) {
	  	result = ERRORVALUE;
	} else if (somThis->iResult == 0) {
	  	result = ERRORVALUE;
	  	somThis->iResult = I_ERROR;
	} else {
	  	result = somThis->iResult;
	  	somThis->iResult = I_OK;
	}
	return result;
}

//------------------------------------------------------------------------------
// Sdb :: numIndexes
//
// Operation: Return number of indexes.
//------------------------------------------------------------------------------
SOM_Scope short  SOMLINK numIndexes(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","numIndexes");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->getIndexCount();
	short result;
	if (somThis->iResult == I_ERROR) {
	  	result = ERRORVALUE;
	} else {
	  	result = somThis->iResult;
	  	somThis->iResult = I_OK;
	}
	return result;
}

//------------------------------------------------------------------------------
// Sdb :: numIndexFields
//
// Operation: Return number of fields for selected index.
//------------------------------------------------------------------------------
SOM_Scope short  SOMLINK numIndexFields(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","numIndexFields");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->getKeyCount();
	short result;
	if (somThis->iResult == I_ERROR) {
	  	result = ERRORVALUE;
	} else {
	  	result = somThis->iResult;
	  	somThis->iResult = I_OK;
	}
	return result;
}

//------------------------------------------------------------------------------
// Sdb :: indexSpec
//
// Operation: Return specification of selected index.
//------------------------------------------------------------------------------
SOM_Scope string  SOMLINK indexSpec(Sdb *somSelf,  Environment *ev,
									string indexName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","indexSpec");

	char* value = (char*) NULL;
   	somThis->iResult = I_ERROR;
	ISAM* db = (ISAM*) somThis->iDb;
	StrList indexFields = db->getKeyDescList();
	if (indexFields != NULL) {
	  	uint indexNum = indexNumber(db, indexName);
   		if (indexNum != ERRORVALUE) {
   			somThis->iResult = I_OK;
			IString spec = indexFields[indexNum];
			value = spec.operator char*();
		}
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: copy
//
// Operation: Copy.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK copy(Sdb *somSelf,  Environment *ev, string curName,
								string copyName, short blockSize) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","copy");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->copy(curName, copyName, 0, blockSize);
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: fileName
//
// Operation: Return file name (full path).
//------------------------------------------------------------------------------
SOM_Scope string  SOMLINK fileName(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","fileName");

	char* value;
	ISAM* db = (ISAM*) somThis->iDb;
	IString name(db->getFileName());
	if (name.length() > 0) {
	  	somThis->iResult = I_OK;
	  	value = name.operator char*();
	} else {
	  	somThis->iResult = I_ERROR;
	  	value = (char*) NULL;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: findRec
//
// Operation: Find record for index.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK findRec(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","findRec");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->findKey();
	return (somThis->iResult == I_FOUND);
}

//------------------------------------------------------------------------------
// Sdb :: flush
//
// Operation: Flush.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK flush(Sdb *somSelf,	Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","flush");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->flush();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: lock
//
// Operation: Lock database.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK lock(Sdb *somSelf,  Environment *ev,
								boolean readPermitted) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","lock");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iLastLockType = (readPermitted ? I_READLOCK : I_WRITELOCK);
	somThis->iResult = db->lockFile(somThis->iLastLockType);
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: unlock
//
// Operation: Unlock database.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK unlock(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","unlock");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->unlockFile(somThis->iLastLockType);
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: numFields
//
// Operation: Return number of fields.
//------------------------------------------------------------------------------
SOM_Scope short  SOMLINK numFields(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","numFields");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->getFieldCount();
	short result = ERRORVALUE;
	if (somThis->iResult != I_ERROR) {
	  	result = somThis->iResult;
	  	somThis->iResult = I_OK;
	}
	return result;
}

//------------------------------------------------------------------------------
// Sdb :: fieldSpec
//
// Operation: Return field specification.
//------------------------------------------------------------------------------
SOM_Scope string  SOMLINK fieldSpec(Sdb *somSelf,  Environment *ev,
									string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","fieldSpec");

	static IString spec;
	spec = "";
	char* value;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	char* aSpec = (char*) db->getFieldDesc(fieldNum);
	  	spec = aSpec;
	  	somThis->iResult = I_OK;
	  	value = spec.operator char*();
	} else {
	  	somThis->iResult = I_ERROR;
	  	value = (char*) NULL;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: fieldSpecs
//
// Operation: Return field specifications.
//------------------------------------------------------------------------------
SOM_Scope string  SOMLINK fieldSpecs(Sdb *somSelf,	Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","fieldSpecs");

	static IString spec;
	spec = "";
	char* value;
	ISAM* db = (ISAM*) somThis->iDb;
	short numFields = somSelf->numFields(ev);
	short fieldNum = 0;
	while (fieldNum < numFields) {
	  	char* fieldSpec = (char*) db->getFieldDesc(fieldNum);
	  	spec += fieldSpec;
	  	spec += FIELDDELIM;
	  	fieldNum += 1;
	}
	value = spec.operator char*();
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: fieldNum
//
// Operation: Return field number.
//------------------------------------------------------------------------------
short fieldNumber(ISAM* db, char* fieldName) {
	short result = db->getFieldNumber(fieldName);
  	if (result == I_ERROR) result = ERRORVALUE;
  	return result;
}

//------------------------------------------------------------------------------
// Sdb :: clearFields
//
// Operation: Clear buffer fields.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK clearFields(Sdb *somSelf,  Environment *ev) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","clearFields");

	ISAM* db = (ISAM*) somThis->iDb;
	somThis->iResult = db->setFieldClear();
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: setStrField
//
// Operation: Set string field.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK setStrField(Sdb *somSelf,  Environment *ev,
									   string fieldName, string value) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","setStrField");

	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	int fieldType = db->getFieldType(fieldNum);
	  	if ((fieldType == I_STRING) || (fieldType == I_CSTRING)) {
			somThis->iResult = db->setField(fieldNum, value);
	  	} else {
	   	 	somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: setBinaryField
//
// Operation: Set binary field.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK setBinaryField(Sdb *somSelf,  Environment *ev,
										  string fieldName, string value) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","setBinaryField");

	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_BINARY) {
			somThis->iResult = db->setField(fieldNum, (void*) value);
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: strField
//
// Operation: Return string field (copy not made)
//------------------------------------------------------------------------------
SOM_Scope string  SOMLINK strField(Sdb *somSelf,  Environment *ev,
								   string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","strField");

	char* value;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	int fieldType = db->getFieldType(fieldNum);
	  	if ((fieldType == I_STRING) || (fieldType == I_CSTRING)) {
			value = (char*) db->getField(fieldNum);
			somThis->iResult = I_OK;
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	value = (char*) NULL;
	  	somThis->iResult = I_ERROR;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: setShortField
//
// Operation: Set short integer field.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK setShortField(Sdb *somSelf,	Environment *ev,
										 string fieldName, short value) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","setShortField");

	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_INTEGER) {
			somThis->iResult = db->setField(fieldNum, value);
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: shortField
//
// Operation: Return short integer field.
//------------------------------------------------------------------------------
SOM_Scope short  SOMLINK shortField(Sdb *somSelf,  Environment *ev,
									string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","shortField");

	short value = 0;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_INTEGER) {
			db->getField(fieldNum, value);
			somThis->iResult = I_OK;
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: setUShortField
//
// Operation: Set unsigned short integer field.
//------------------------------------------------------------------------------

SOM_Scope boolean  SOMLINK setUShortField(Sdb *somSelf,  Environment *ev,
										  string fieldName, unsigned short value) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","setUShortField");

	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_UNSIGNED) {
			somThis->iResult = db->setField(fieldNum, value);
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: ushortField
//
// Operation: Return unsigned short integer field.
//------------------------------------------------------------------------------
SOM_Scope unsigned short  SOMLINK ushortField(Sdb *somSelf,  Environment *ev,
											  string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","ushortField");

	unsigned short value = 0;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_UNSIGNED) {
			db->getField(fieldNum, value);
			somThis->iResult = I_OK;
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: setLongField
//
// Operation: Set long integer field.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK setLongField(Sdb *somSelf,  Environment *ev,
										string fieldName, long value) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","setLongField");

	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_LONG) {
			somThis->iResult = db->setField(fieldNum, value);
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: longField
//
// Operation: Return long integer field.
//------------------------------------------------------------------------------
SOM_Scope long	SOMLINK longField(Sdb *somSelf,  Environment *ev,
								  string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","longField");

	long value = 0;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_LONG) {
			db->getField(fieldNum, value);
			somThis->iResult = I_OK;
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: setFloatField
//
// Operation: Set float field.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK setFloatField(Sdb *somSelf,	Environment *ev,
										 string fieldName, float value) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","setFloatField");

	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_FLOAT) {
			somThis->iResult = db->setField(fieldNum, value);
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: floatField
//
// Operation: Return float field.
//------------------------------------------------------------------------------
SOM_Scope float  SOMLINK floatField(Sdb *somSelf,  Environment *ev,
									string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","floatField");

	float value = 0.0;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_FLOAT) {
			db->getField(fieldNum, value);
			somThis->iResult = I_OK;
	  	} else {
	  		somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: setDoubleField
//
// Operation: Set double field.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK setDoubleField(Sdb *somSelf,  Environment *ev,
										  string fieldName, double value) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","setdoubleField");

	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  if (db->getFieldType(fieldNum) == I_DOUBLE) {
			somThis->iResult = db->setField(fieldNum, value);
	  } else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  }
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return (somThis->iResult == I_OK);
}

//------------------------------------------------------------------------------
// Sdb :: doubleField
//
// Operation: Return double field.
//------------------------------------------------------------------------------
SOM_Scope double  SOMLINK doubleField(Sdb *somSelf,  Environment *ev,
									  string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","doubleField");

	double value = 0.0;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_DOUBLE) {
			db->getField(fieldNum, value);
			somThis->iResult = I_OK;
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: SOMInitModule
//
// Operation: Initialize class.
//------------------------------------------------------------------------------
SOMEXTERN void SOMLINK SOMInitModule (long majorVersion, long minorVersion,
									  string className) {
  	SOM_IgnoreWarning (majorVersion);
  	SOM_IgnoreWarning (minorVersion);
  	SOM_IgnoreWarning (className);
  	SdbNewClass (0, 0);
  	SdbMetaNewClass (0, 0);
}

//------------------------------------------------------------------------------
// Sdb :: binaryField
//
// Operation: Return binary field (copy not made)
//------------------------------------------------------------------------------
SOM_Scope string  SOMLINK binaryField(Sdb *somSelf,  Environment *ev,
									  string fieldName) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","binaryField");

	char* value;
	ISAM* db = (ISAM*) somThis->iDb;
	short fieldNum = fieldNumber(db, fieldName);
	if (fieldNum != ERRORVALUE) {
	  	if (db->getFieldType(fieldNum) == I_BINARY) {
			value = (char*) db->getField(fieldNum);
			somThis->iResult = I_OK;
	  	} else {
			somThis->iResult = Sdb_TYPEMISMATCH + ERROROFFSET;
	  	}
	} else {
	  	value = (char*) NULL;
	  	somThis->iResult = I_ERROR;
	}
	return value;
}

//------------------------------------------------------------------------------
// Sdb :: importRecs
//
// Operation: Import records from an ASCII file.  Binary fields can not be
//			  imported.
//------------------------------------------------------------------------------
SOM_Scope boolean  SOMLINK importRecs(Sdb *somSelf,  Environment *ev,
									  string fileName, char delimiter) {
	SdbData *somThis = SdbGetData(somSelf);
	SdbMethodDebug("Sdb","importRecs");

	boolean result = false;
	File* inFile = fopen (fileName, "r");
	if (inFile != NULL) {
		ISAM* db = (ISAM*) somThis->iDb;
	  	short fieldIndexes[MAXFIELDS];
	  	char* fieldValues[MAXFIELDS];
	  	char* fieldNames[MAXFIELDS];
	  	char fieldValuesBuf[IMPORTBUFSIZE];
	  	char fieldNamesBuf[IMPORTBUFSIZE];
	  	char IOBuf[IMPORTBUFSIZE];
	  	char* lastChar = fgets(IOBuf, IMPORTBUFSIZE, inFile);
	  	if (lastChar != NULL) {
			removeChars(IOBuf, fieldNamesBuf);
			unpackTokens(fieldNamesBuf, delimiter, fieldNames);
			getImportIndexes(fieldNames, fieldIndexes, db);
			result = true;
			while (result) {
		  		lastChar = fgets(IOBuf, IMPORTBUFSIZE, inFile);
		  		if (lastChar != NULL) {
					removeChars(IOBuf, fieldValuesBuf);
					unpackTokens(fieldValuesBuf, delimiter, fieldValues);
					result = getImportFields(fieldNames, fieldIndexes, fieldValues, db);
					if (result) somSelf->addRec(ev);
		  		} else {
					break;
		  		}
			}
	  	}
	  	fclose (inFile);
	}
	if (result) {
	  	somThis->iResult = I_OK;
	} else {
	  	somThis->iResult = I_ERROR;
	}
	return result;
}

//------------------------------------------------------------------------------
// Sdb :: SdbGetImportIndexes
//
// Operation: Get field indexes for import.
//------------------------------------------------------------------------------
void getImportIndexes(char* fieldNames[], short fieldIndexes[], ISAM* db) {
  	short numFields = db->getFieldCount();
  	for (short fieldNum = 0; fieldNum < numFields; fieldNum++) {
		fieldIndexes[fieldNum] = NOIMPORTINDEX;
		char* fieldName = (char*) db->getFieldName(fieldNum);
		short index = 0;
		while (fieldNames[index] != NULL) {
	  		if (stricmp (fieldName, fieldNames[index]) != 0) {
				index += 1;
	  		} else {
				fieldIndexes[fieldNum] = index;
				break;
	  		}
		}
  	}
  	return;
}

//------------------------------------------------------------------------------
// Sdb :: getImportFields
//
// Operation: Get fields from import buffer.
//------------------------------------------------------------------------------
boolean getImportFields(char* fieldNames[], short fieldIndexes[],
						char* fieldValues[], ISAM* db) {
  	boolean result = true;
  	long iValue;
  	double fValue;
  	short index, numFields = db->getFieldCount();
  	for (short fieldNum = 0; fieldNum < numFields; fieldNum++) {
  		if ((index = fieldIndexes[fieldNum]) != NOIMPORTINDEX) {
	  		int fieldType = db->getFieldType(fieldNum);
	  		switch (fieldType) {
				case I_STRING:
				case I_CSTRING:
		  			result = db->setField(fieldNum, fieldValues[index]);
		  			break;
				case I_INTEGER:
		  			iValue = atol(fieldValues[index]);
		  			result = db->setField(fieldNum, (int) iValue);
		  			break;
				case I_UNSIGNED:
		  			iValue = atol(fieldValues[index]);
		  			result = db->setField(fieldNum, (uint) iValue);
		  			break;
				case I_LONG:
		  			iValue = atol(fieldValues[index]);
		  			result = db->setField(fieldNum, iValue);
		  			break;
				case I_FLOAT:
		  			fValue = atof(fieldValues[index]);
		  			result = db->setField(fieldNum, (float) fValue);
		  			break;
				case I_DOUBLE:
		  			fValue = atof(fieldValues[index]);
		  			result = db->setField(fieldNum, fValue);
		  			break;
	  		}
	  	if (!result) break;
		}
  	}
  	return result;
}

//------------------------------------------------------------------------------
// Sdb :: SdbRemoveChars
//
// Operation: Remove quotes and newline from a string.
//------------------------------------------------------------------------------
void removeChars(char* inStr, char* outStr) {
  	while (*inStr != TERM) {
		if ((*inStr != '"') && (*inStr != '\n')) {
	  		*outStr = *inStr;
	  		outStr += 1;
		}
		inStr += 1;
  	}
  	*outStr = TERM;
  	return;
}

//------------------------------------------------------------------------------
// Sdb :: somDefaultInit
//
// Operation: Initialize object
//------------------------------------------------------------------------------

/*
 * SOM_Scope void SOMLINK somDefaultInit(Sdb *somSelf, somInitCtrl* ctrl)
 */

/*
 * The prototype for somDefaultInit was replaced by the following prototype:
 */
SOM_Scope void SOMLINK somDefaultInit(Sdb *somSelf, som3InitCtrl* ctrl)
{
	SdbData *somThis; /* set in BeginInitializer */
	somInitCtrl globalCtrl;
	somBooleanVector myMask;
	SdbMethodDebug("Sdb","somDefaultInit");
	Sdb_BeginInitializer_somDefaultInit;

	Sdb_Init_SOMObject_somDefaultInit(somSelf, ctrl);

	/*
	 * local Sdb initialization code added by programmer
	 */

	somThis->iDb = (void*) new ISAM;
	somThis->iResult = I_OK;
	somThis->iLastLockType = 0;
	somThis->iReadOnly = false;
	somThis->iShare = false;
	strcpy(somThis->iName, "");
	strcpy(somThis->iCurIndexName, PHYSICALINDEXNAME);
	somThis->iCurIndex = PHYSICALINDEX;
}

//------------------------------------------------------------------------------
// Sdb :: somDestruct
//
// Operation: Destroy object
//------------------------------------------------------------------------------

/*
 * SOM_Scope void SOMLINK somDestruct(Sdb *somSelf, octet doFree,
 * 								   somDestructCtrl* ctrl)
 */

/*
 * The prototype for somDestruct was replaced by the following prototype:
 */
SOM_Scope void SOMLINK somDestruct(Sdb *somSelf, octet doFree,
                                   som3DestructCtrl* ctrl)
{
	SdbData *somThis; /* set in BeginDestructor */
	somDestructCtrl globalCtrl;
	somBooleanVector myMask;
	SdbMethodDebug("Sdb","somDestruct");
	Sdb_BeginDestructor;

	/*
	 * local Sdb deinitialization code added by programmer
	 */

	delete (ISAM*) somThis->iDb;
	Sdb_EndDestructor;
}
