/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         ApplyMethod
*/
ApplyMethod: arg method
    ok = VRMethod( "LB_1", "GetSelectedStringList", "window." )
    if ok = 1 then do
        do i = 1 to window.0
            w = word( window.i, 1 )
            call vrmethod w, method
        end
    end
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    call Refresh
    drop window
return

/*:VRX         Menu2_Click
*/
Menu2_Click:
    call VRLoadSecondary "SW_1"
return

/*:VRX         Menu4_Click
*/
Menu4_Click:
    call Shake
return

/*:VRX         Menu5_Click
*/
Menu5_Click:
    call ApplyMethod "Minimize"

return

/*:VRX         Menu6_Click
*/
Menu6_Click:
    call ApplyMethod "Maximize"
return

/*:VRX         Menu7_Click
*/
Menu7_Click:
    call ApplyMethod "Restore"

return

/*:VRX         PB_1_Click
*/
PB_1_Click:
    call refresh
return

/*:VRX         PB_2_Click
*/
PB_2_Click:
    call ApplyMethod "Minimize"
return

/*:VRX         PB_3_Click
*/
PB_3_Click:
    call ApplyMethod "Restore"
    return

/*:VRX         PB_4_Click
*/
PB_4_Click:
    call Shake
return

/*:VRX         PB_5_Click
*/
PB_5_Click:
    call VRDestroy "SW_1"
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Refresh
*/
Refresh:
    call vrset "LB_1", "Painting", 0
    call vrmethod "LB_1", "Clear"
    ok = vrmethod( "application", "ListWindows", "window." )
    if ok = 1 then do
        do i = 1 to window.0
            w = word( window.i, 1 )
            if vrget( w, "visible" ) = 1 then do
                x = w "---" vrget( w, "Caption" )
                call vrmethod "LB_1", "AddString", x
            end
        end
    end
    call vrset "LB_1", "Painting", 1       
return

/*:VRX         Shake
*/
Shake:
    delta = 50
    ok = VRMethod( "LB_1", "GetSelectedStringList", "window." )
    if ok = 1 then do
        do i = 1 to window.0
            w = word( window.i, 1 )
            left = vrget( w, "Left" )
            top = vrget( w, "Top" )

            call vrset w, "Top", top - delta
            call vrset w, "Top", top + 2 * delta
            call vrset w, "Top", top 

            call vrset w, "Left", left - delta
            call vrset w, "Left", left + 2 * delta
            call vrset w, "Left", left 

        end
    end

return

/*:VRX         SW_1_Close
*/
SW_1_Close:
    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

