/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, 'visible', 'false'
    drop window
    call sqldbs 'STOP USING DATABASE'
    call sqldbs 'STOP DATABASE MANAGER'
return '0'

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    call VRSet "pb_next", "Enabled", 0
    if Rxfuncquery('SQLDBS') <> 0 then
        rcy = rxfuncadd( 'SQLDBS', 'SQLAR', 'SQLDBS' )
    if rXFUNCQUERY('SQLEXEC') <> 0 then
        rcy = rxfuncadd( 'SQLEXEC', 'SQLAR', 'SQLEXEC' )

    dbname = "sample"
    call sqldbs 'START DATABASE MANAGER'
    if ( SQLCA.SQLCODE <> 0 & SQLCA.SQLCODE \= -1026) then do
        call VRMessage VRWindow(), "Database Manager could not be started: SQLCODE = " SQLCA.SQLCODE, 'Error'
        return
    end

    call sqldbs 'START USING DATABASE' dbname
    if (SQLCA.SQLCODE <> 0  & SQLCA.SQLCODE \= -1098) then do
        call VRMessage VRWindow(), "Start DB error: SQLCODE = " SQLCA.SQLCODE, 'Error'
        return
    end

    call sqlexec "DECLARE c1 cursor for s1"
return
/*:VRX         pb_clear_Click
*/
pb_clear_Click:
        call VRSet 'EF_id', 'value', ''
        call VRSet 'EF_name', 'value', ''
        call VRSet 'EF_job', 'value', ''
        call VRSet 'EF_years', 'value', ''
        call VRSet 'EF_department_name', 'value', ''

        call VRSet 'pb_search', 'enabled', 'true'
        call VRSet 'pb_next', 'enabled', 'false'

        call sqlexec 'CLOSE c1'
return
/*:VRX         pb_exit_Click
*/
pb_exit_Click:
        call sqlexec 'CLOSE c1'
        call Quit
return
/*:VRX         pb_next_Click
*/
pb_next_Click:

        call VRSet 'EF_id', 'value', idnum
        call VRSet 'EF_name', 'value', staff_name
        call VRSet 'EF_job', 'value', job_name
        call VRSet 'EF_years', 'value', year_num
        call VRSet 'EF_department_name', 'value', location

        call sqlexec 'FETCH c1 INTO :idnum, :staff_name, :job_name, :year_num, :location'
        if( SQLCA.SQLCODE <> 0)then do
                call VRSet 'pb_next', 'enabled', 'false'
          end

return
/*:VRX         pb_search_Click
*/
pb_search_Click:
        prep_string = "SELECT id, name, job, years, deptname from staff, org where staff.dept=org.deptnumb"

        call sqlexec 'PREPARE s1 FROM :prep_string'
        if( SQLCA.SQLCODE <> 0 ) then do
                call VRMessage VRWindow(), "Error preparing statement: SQLCODE = " sqlca.sqlcode
                return
        end

        call sqlexec 'OPEN c1'
        call sqlexec 'FETCH c1 INTO :idnum, :staff_name, :job_name, :year_num, :location'
        if( SQLCA.SQLCODE = 0) then do
                call VRSet 'pb_search', 'enabled', 'false'
                call VRSet 'pb_next', 'enabled', 'true'
                call pb_next_Click
        end
        else call VRMessage VRWindow(), "No records found in the database." SQLCA.SQLCODE
return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, 'shutdown', 'true'
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return
