/*  PATCH.CMD
*/
 
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
 
say 'About to apply the D level patches...'
say
say 'Note: To be patched correctly, all of the VX-REXX DLLs must exist in the'
say 'VX-REXX directory. If you have moved your DLLs to another location you'
say 'must copy them back to the VX-REXX directory before applying the patch.'
say
say 'If the DLLs are not in the VX-REXX directory, press X now to exit and'
say 'restore them before applying the patch.'
say
say 'Press C to apply the patch or X to exit.'
c = SysGetKey( NOECHO )
if( c \= 'C' & c \= 'c' ) then do
    say '*** Patch process aborted ***'
    return
end    

say "Patching files..."
if( Stream("A2Z.INF", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching A2Z.INF"
    "@bpatch -p DPATCHES\INF\A2Z.D" 
end
if( Stream("PMDBG.EXE", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching PMDBG.EXE"
    "@bpatch -p DPATCHES\EXE\PMDBG.D" 
end
if( Stream("PROGGUID.INF", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching PROGGUID.INF"
    "@bpatch -p DPATCHES\INF\PROGGUID.D" 
end
if( Stream("README.INF", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching README.INF"
    "@bpatch -p DPATCHES\INF\README.D" 
end
if( Stream("VREDIT.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VREDIT.DLL"
    "@bpatch -p DPATCHES\DLL\VREDIT.D" 
end
if( Stream("VROBJ.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VROBJ.DLL"
    "@bpatch -p DPATCHES\DLL\VROBJ.D" 
end
if( Stream("VRSED.DLL", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRSED.DLL"
    "@bpatch -p DPATCHES\DLL\VRSED.D" 
end
if( Stream("VRXEDIT.EXE", "C","QUERY EXISTS" ) \= "" ) then do
    say "Patching VRXEDIT.EXE"
    "@bpatch -p DPATCHES\EXE\VRXEDIT.D" 
end

call BUILDVRX.CMD
 
say "You can now erase the DPATCHES directory"
say
say "The patch process has saved an original copy of each file that has been"
say "patched. These files have a .BAK extension and may be used to restore the"
say "original files or may be deleted."

