/************************************************/
/* BUILDVRX.CMD : Build VX-REXX Desktop objects */
/************************************************/

address CMD

'@echo off'

call RXFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

call setlocal

target_dir   = ''
szVideoMode = ''

parse arg target_dir szVideoMode

if( target_dir = '?' | target_dir = '/?') then
    call Usage

if (szVideoMode \= "1024x768" & szVideoMode \= "800x600" & szVideoMode \= "640x480") then do
   szVideoMode = "640x480"
end

if (szVideoMode = "") then do
   szVideoMode = "640x480"
end

folder_title = 'Watcom VX-REXX'


if( target_dir = '' )then
    target_dir = directory()
else do
    if( lastpos( "\", target_dir ) = length( target_dir ) ) then do
        target_dir = left( target_dir, length( target_dir ) - 1 )
    end
end

if( directory( target_dir ) = '' )then
    call Usage

target_dir = directory( target_dir )

bldDemo = 0
if( FileExists( target_dir || '\TUTBOOK.INF' ) )then do
    bldDemo = 1
end

call CleanIni

call AddTemplate

/* Accomodate for different resolution modes */


x = 5;
if (szVideoMode = "1024x768") then do
   y = 45;
   nDeltaY = -10;
   nDeltaX = 13;
end
if (szVideoMode = "640x480") then do
   y = 60;
   nDeltaY = -15;
   nDeltaX = 15;
end
if (szVideoMode = "800x600") then do
   y = 60;
   nDeltaY = -15;
   nDeltaX = 15;
end

/* Create main folder object */

say 'Building Workplace Shell VX-REXX Objects...'

classname = 'WPFolder'
title     = folder_title
location  = '<WP_DESKTOP>'
iconparm  = 'ICONFILE=' || target_dir || '\watcom2.ico;'
setup     = 'OBJECTID=<VXREXX_FOLDER>;' || iconparm

call SysCreateObject classname, title, location, setup, 'r'



/* Create the Readme program object */

x = 5;
y = y + nDeltaY;
classname = 'WPProgram'
title     = 'Read Me First'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=' || target_dir || '\readme.inf;' ||,
            'ICONPOS=' || x || ',' || y || ';' ||,
            'STARTUPDIR=' || target_dir || ';'
call SysCreateObject classname, title, location, setup, 'r'

/* Create tutorial (demo only) */

if( bldDemo = 1 )then do
    x = x + nDeltaX;
    classname = 'WPProgram'
    title     = 'VX-REXX' || '0a'x || 'Tutorial'
    location  = '<VXREXX_FOLDER>'
    setup     = 'EXENAME=view.exe;' ||,
                'PROGTYPE=PM;' ||,
                'PARAMETERS=' || target_dir || '\TUTBOOK.INF;' ||,
                'ICONPOS=' x || "," || y || ";" ||,
                'STARTUPDIR=' || target_dir || ';'
    call SysCreateObject classname, title, location, setup, 'r'
end

/* Create Programmer's Guide Object */

x = x + nDeltaX;
classname = 'WPProgram'
title     = "VX-REXX" || "0a"x || "Programmer's Guide"
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=' || target_dir || '\ProgGuid.INF;' ||,
            'ICONPOS=' x || "," || y || ";" ||,
            'STARTUPDIR=' || target_dir || ';'
call SysCreateObject classname, title, location, setup, 'r'


/* Create VX-REXX Reference Object */

x = x + nDeltaX;
classname = 'WPProgram'
title     = 'VX-REXX' || '0a'x || 'Reference'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'PARAMETERS=' || target_dir || '\A2Z.INF;' ||,
            'ICONPOS=' x || "," || y || ";" ||,
            'STARTUPDIR=' || target_dir || ';'
call SysCreateObject classname, title, location, setup, 'r'


/* Create a shadow of the REXX information */

x = x + nDeltaX;
classname = 'WPProgram'
title     = 'REXX Information'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=view.exe;' ||,
            'PROGTYPE=PM;' ||,
            'ICONPOS=' x || ',' || y || ';' ||,
            'PARAMETERS=rexx.inf;'

call SysCreateObject classname, title, location, setup, 'r'

/* Create a Color Palette */

x = x + nDeltaX;
classname = 'WPColorPalette'
title     = 'Color Palette'
location  = '<VXREXX_FOLDER>'
setup     = 'ICONPOS=' || x || "," || y || ";"

call SysCreateObject classname, title, location, setup, 'r'

/* Create a Font Palette */

x = x + nDeltaX
classname = 'WPFontPalette'
title     = 'Font Palette'
location  = '<VXREXX_FOLDER>'
setup     = 'ICONPOS=' || x || "," || y || ";"

call SysCreateObject classname, title, location, setup, 'r'

/* Create the VX REXX program object */

x = 5;
y = y + nDeltaY;
classname = 'WPProgram'
title     = 'VX-REXX'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=' || target_dir || '\vrxedit.exe;' ||,
            'PROGTYPE=PM;' ||,
            'ICONPOS=' || x || "," || y || ";" ||,
            'ASSOCFILTER=*.VRP;' ||,
            'ASSOCTYPE=VX-REXX Project;'

call SysCreateObject classname, title, location, setup, 'r'

/* Create the projects folder */

/* Put project template shadow in the directory to be shadowed */

classname = 'WPShadow'
title     = 'VX-REXX Project'
location  = target_dir||"\PROJECTS"
setup     = 'SHADOWID=<VXREXX_TEMPLATE>;OBJECTID=<VXREXX_PROJECTS>'

call SysCreateObject classname, title, location, setup, 'r'

x = x + nDeltaX;
classname = 'WPShadow'
title     = 'Projects'
location  = '<VXREXX_FOLDER>'
setup     = 'SHADOWID=' || target_dir || "\PROJECTS;ICONPOS=" x || "," || y || ";OBJECTID=<VXREXX_PROJ>"

call SysCreateObject classname, title, location, setup, 'r'

/* Create a shadow of the shared directory */

x = x + nDeltaX;
classname = 'WPShadow'
title     = 'Shared'
location  = '<VXREXX_FOLDER>'
setup     = 'SHADOWID=' || target_dir || "\SHARED;ICONPOS=" x || "," || y || ";OBJECTID=<VXREXX_SHARED>"

call SysCreateObject classname, title, location, setup, 'r'

/* Create the Samples folder */

x = x + nDeltaX;
classname = 'WPFolder'
title     = 'Samples'
location  = '<VXREXX_FOLDER>'
setup     = 'ICONPOS=' x || "," || y || ";OBJECTID=<VXREXX_SAMPLES>;"

call SysCreateObject classname, title, location, setup, 'r'

/* Create the Macros folder */

x = x + nDeltaX;
classname = 'WPShadow'
title     = 'Macros'
location  = '<VXREXX_FOLDER>'
setup     = 'SHADOWID=' || target_dir || '\MACROS;ICONPOS=' x || "," || y || ";OBJECTID=<VXREXX_MACROS>;"
call SysCreateObject classname, title, location, setup, 'r'

x = x + nDeltaX;
classname = 'WPShadow'
title     = 'Icons'
location  = '<VXREXX_FOLDER>'
setup     = 'SHADOWID=' || target_dir || '\ICONS;ICONPOS=' x || "," || y || ";OBJECTID=<VXREXX_ICONS>;"
call SysCreateObject classname, title, location, setup, 'r'

/* Create a Source Folder under Samples */

classname = 'WPFolder'
title     = 'Source'
location  = '<VXREXX_SAMPLES>'
setup     = 'OBJECTID=<SAMPLE_SOURCE>'
call SysCreateObject classname, title, location, setup, 'r'



/* Create the VX REXX macro-launcher object */

/*
    Don't include this for now.
    Its presence in the VX-REXX folder is confusing.  People click on it and
    expect something to happen.  Nothing does.

    We don't really expect people to drag and drop macros, or to rename them *.VRM and
    double click on them.  Macro's are really only run from applications.
*/
/*
classname = 'WPProgram'
title     = 'VX-REXX Macro'
location  = '<VXREXX_FOLDER>'
setup     = 'EXENAME=' || target_dir || '\vrx.exe;' ||,
            'PROGTYPE=PM;' ||,
            'ASSOCFILTER=*.VRM;' ||,
            'ASSOCTYPE=VX-REXX Macro;'

call SysCreateObject classname, title, location, setup, 'r'
*/

/*
 * Set the executable icon.
 */
call AddSample "Bounce",    "Bounce",           "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Button",    "Button",           "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Calc",      "Calculator",       "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "DDE",       "DDE Explorer",     "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "DragDrop",  "DragDrop",         "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "FileBro",   "File browser",     "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Focus",     "Hocus focus",      "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "HintHelp",  "Hint and Help",    "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "MindGame",  "Mind Game",        "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "MMW",       "MMW",              "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Movies",    "Movies",           "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Notebook",  "Notebook",         "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Popup",     "Popup",            "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Printing",  "Printing",         "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "RGB",       "RGB",              "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Threads",   "Threads",          "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Employee",  "Employee Database",  "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "WinCtrl",   "Window Controller","<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "Scan", "Scan", "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"
call AddSample "CUA91", "CUA 91 Skeleton", "<VXREXX_SAMPLES>", "SAMPLES", "<SAMPLE_SOURCE>"

exit

/* Add templates */

AddTemplate:

    classname = 'WPFolder'
    title     = 'VX-REXX Project'
    location  = '<WP_TEMPS>'
    setup     = 'OBJECTID=<VXREXX_TEMPLATE>;' ||,
                'TEMPLATE=yes;'

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Project.VRP'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Window1.VRY'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    classname = 'WPDataFile'
    title     = 'Window1.VRX'
    location  = '<VXREXX_TEMPLATE>'
    setup     = ''

    call SysCreateObject classname, title, location, setup, 'r'

    return


AddSample: procedure expose target_dir
/*********
    Parms:  1   directory name
            2   long name
            3   location
            4   sample directory
            5   source folder location

*/


   szDirName = arg(1)
   szLongName = arg(2)
   szLocation = arg(3)
   szSampleDir = arg(4)
   szSourceLocation = arg(5)

   szStartUp = target_dir || "\" || szSampleDir || "\" || szDirName;

   szExeName = szDirName || ".EXE";
   szIcoName = szDirName || ".ICO";
   szVRPName = szDirName || ".VRP";

/* Create Shadow of source directory in the sample source folder */

   classname = "WPShadow"
   title     = szLongName
   location  = szSourceLocation
   setup     = "SHADOWID=" || szStartUp || ";"

   call SysCreateObject classname, title, location, setup, 'r'

    if( szDirName = "Scan" ) then do
        /*  Handle case with EPM w/ scan sample 
        */
        classname = "WPProgram"
        title     = "EPM with Scan"
        location  = szLocation
        setup     = "EXENAME=EPM.EXE;PROGTYPE=PM;STARTUPDIR=" || szStartUp || ";PARAMETERS=SCAN.ERX;ICONFILE=" || szStartUp || "\" || szIcoName || ";"
    end
    else do
        /*  Create the executable icon 
        */
        classname = "WPProgram"
        title = szLongName
        location = szLocation
        setup = "EXENAME=" || szStartUp || "\" || szExeName || ";PROGTYPE=PM;ICONFILE=" || szStartUp || "\" || szIcoName || ";STARTUPDIR=" || szStartUp || ";"
    end
    call SysCreateObject classname, title, location, setup, 'r'


   return


/*
 * CleanIni -- Clean up the .INI file out of old VX-REXX information.
 *             Cleans up old beta stuff, too.
 */

CleanIni:
    call SysIni 'user', 'PMWP_ASSOC_FILTER', '*.VRP', 'DELETE:'
    call SysIni 'user', 'PMWP_ASSOC_TYPE', 'VX-REXX Project', 'DELETE:'
    call SysIni 'user', 'PMWP_ASSOC_TYPE', 'VRx Project', 'DELETE:'

    call sysini 'user', 'PM_Workplace:Templates', 'All:', 'ids.'
    do i = 1 to ids.0
        if( pos( 'REXX', ids.i ) \= 0 & pos( 'VX', ids.i ) \= 0 & ,
            pos( 'Project', ids.i ) \= 0 )then do
            call SysIni 'user', 'PM_Workplace:Templates', ids.i, 'DELETE:'
        end
    
        if( pos( 'VRx', ids.i ) \= 0 & pos( 'Project', ids.i ) \= 0 )then do
            call SysIni 'user', 'PM_Workplace:Templates', ids.i, 'DELETE:'
        end
    end

    call SysDestroyObject '<VXREXX_SAMPLES>'
    call SysDestroyObject '<VXREXX_TEMPLATE>'
    call SysDestroyObject '<VXREXX_PROJECTS>'
    call SysDestroyObject '<VXREXX_MACROS>'
    call SysDestroyObject '<VXREXX_FOLDER>'

    return
    
/*
 * FileExists
 */
    
FileExists:
    return( stream( arg(1), 'c', 'query exists' ) <> '' )

/*
 * Usage
 */

Usage:
    say ''
    say 'Usage: buildvrx [target_dir] [resolution]'
    say ''
    say '    target_dir   = path where Watcom VX-REXX has been installed'
    say '    resolution   = 640x480, 800x600, 1024x768 where 640x480 is the default'
    say ''
    say 'This program builds/rebuilds the various Workplace Shell objects'
    say 'needed to run WATCOM VX-REXX.'
    exit
