/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal'
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__:
/*
#append shared\object.vrs
*/
return
/*:VRX         CN_Main_Init
*/
CN_Main_Init:  procedure expose Globals.
    /* Add records to the container */
    group = "Order"
    Globals.!RecHandle.group = VRMethod( "CN_MainList", "AddRecord", , "First", "Order", "OFOLD.ICO", ,  )
    group = "Product"
    Globals.!RecHandle.group = VRMethod( "CN_MainList", "AddRecord", , "First", "Product", "PFOLD.ICO", ,  )
    group = "Customer"
    Globals.!RecHandle.group = VRMethod( "CN_MainList", "AddRecord", , "First", "Customer", "CUSTFOLD.ICO", ,  )
    ok = VRMethod( "CN_MainList", "SetRecordAttr", Globals.!recHandle.group, "Selected", 1 )
    ok = VRMethod( "CN_MainList", "Arrange" )
return

/*:VRX         CN_MainList_DoubleClick
*/
CN_MainList_DoubleClick:  procedure expose Globals.
    record = VRInfo( "Record" )
    if( record \= "" ) then do
        caption = VRMethod( "CN_MainList", "GetRecordAttr",,
                                         record, "Caption" )
        call ObjectOpen "CN_MainList", record, "SW_"||caption
    end
return

/*:VRX         CN_QRY_Customer_ContextMenu
*/
CN_QRY_Customer_ContextMenu: procedure expose Globals.
    call VRMethod "Popup_Customer", "Popup"
return

/*:VRX         CN_QRY_Customer_DoubleClick
*/
CN_QRY_Customer_DoubleClick: procedure expose Globals.
    record = VRInfo( "Record" )
    if( record \= "" ) then do
        call OpenDetail "CN_QRY_Customer", record, "custnum", "SW_CustDetail"
    end
return

/*:VRX         CN_QRY_Customer_EndEdit
*/
CN_QRY_Customer_EndEdit:  procedure expose Globals.
    record = VRInfo( "Record" )
    if( VRInfo("Cancelled") = 1 ) then do
        ok = VRMethod( "CN_QRY_Customer", "DBReset", record )
        if( \ok ) then do
            status = VRGet( "QRY_Customer", "Status" )
            call VRMessage VRWindow(), "Could not reset record:" status, "Error", "E"
        end
    end
    else do
        ok = VRMethod( "CN_QRY_Customer", "DBUpdate", record )
        if( \ok ) then do
            status = VRGet( "QRY_Customer", "Status" )
            call VRMessage VRWindow(), "Could not update record:" status, "Error", "E"
        end
    end

return
/*:VRX         CN_QRY_Customer_Init
*/
CN_QRY_Customer_Init: procedure expose Globals.
    fieldHandle = VRMethod( "CN_QRY_Customer", "AddField", "ULong", "No.", "custnum" )
    fieldHandle = VRMethod( "CN_QRY_Customer", "AddField", "String", "Name", "name" )
    fieldHandle = VRMethod( "CN_QRY_Customer", "AddField", "String", "Street address", "street" )
    fieldHandle = VRMethod( "CN_QRY_Customer", "AddField", "String", "City", "city" )
    fieldHandle = VRMethod( "CN_QRY_Customer", "AddField", "String", "State", "state" )
    fieldHandle = VRMethod( "CN_QRY_Customer", "AddField", "String", "Phone no.", "phone" )
    fieldHandle = VRMethod( "CN_QRY_Customer", "AddField", "String", "Zip", "zip" )
    ok = VRSet( "CN_QRY_Customer", "DetailSort", "custnum" )
return

/*:VRX         CN_QRY_Customer_Refresh
*/
CN_QRY_Customer_Refresh: procedure expose Globals.

    ok = VRSet( "CN_QRY_Customer", "Painting", 0 )

    ok = VRMethod( "QRY_Customer", "Close" )
    if( ok ) then do 
       call ObjectListClosed "CN_QRY_Customer"
    end

    call QRY_Customer_Init
    
    ok = VRMethod( "CN_QRY_Customer", "SortRecords" )

    keyFields.0 = 2
    keyFields.1 = "name"            /* First key must be a string */
    keyFields.2 = "custnum"         /* This is the real key but its a ULong */
    call ObjectListOpened "Customer", "CN_QRY_Customer"

    ok = VRSet( "CN_QRY_Customer", "Painting", 1 )
return

/*:VRX         CN_QRY_Order_ContextMenu
*/
CN_QRY_Order_ContextMenu: procedure expose Globals.
    call VRMethod "Popup_Order", "Popup"
return

/*:VRX         CN_QRY_Order_DoubleClick
*/
CN_QRY_Order_DoubleClick: procedure expose Globals.
    record = VRInfo( "Record" )
    if( record \= "" ) then do
        call OpenDetail "CN_QRY_Order", record, "ordernum", "SW_OrderDetail"
    end
return

/*:VRX         CN_QRY_Order_EndEdit
*/
CN_QRY_Order_EndEdit: procedure expose Globals.
    record = VRInfo( "Record" )
    if( VRInfo("Cancelled") = 1 ) then do
        ok = VRMethod( "CN_QRY_Order", "DBReset", record )
        if( \ok ) then do
            status = VRGet( "QRY_Order", "Status" )
            call VRMessage VRWindow(), "Could not reset record:" status, "Error", "E"
        end
    end
    else do
        ok = VRMethod( "CN_QRY_Order", "DBUpdate", record )
        if( \ok ) then do
            status = VRGet( "QRY_Order", "Status" )
            call VRMessage VRWindow(), "Could not update record:" status, "Error", "E"
        end
    end

return
/*:VRX         CN_QRY_Order_Init
*/
/*
    call CN_QRY_Order_Init

    - Predefine some of the columns in the order container to set the type and
    caption.
*/
CN_QRY_Order_Init: procedure expose Globals.
    fieldHandle = VRMethod( "CN_QRY_Order", "AddField", "ULong", "No.", "ordernum" )
    fieldHandle = VRMethod( "CN_QRY_Order", "AddField", "String", "Customer name", "name" )
    fieldHandle = VRMethod( "CN_QRY_Order", "AddField", "String", "Date", "orderdat" )
    ok = VRSet( "CN_QRY_Order", "DetailSort", "ordernum" )
return

/*:VRX         CN_QRY_Order_Refresh
*/
CN_QRY_Order_Refresh: procedure expose Globals.
    ok = VRSet( "CN_QRY_Order", "Painting", 0 )

    ok = VRMethod( "QRY_Order", "Close" )
    if( ok ) then do
        call ObjectListClosed "CN_QRY_Order"
    end

    call QRY_Order_Init
    
    ok = VRMethod( "CN_QRY_Order", "SortRecords" )

    keyFields.0 = 2
    keyFields.1 = "name"            /* Must be a string */
    keyFields.2 = "OrderNum"        /* Real key */
    call ObjectListOpened "Order", "CN_QRY_Order"

    ok = VRSet( "CN_QRY_Order", "Painting", 1 )
return

/*:VRX         CN_QRY_OrderItem_BeginEdit
*/
CN_QRY_OrderItem_BeginEdit: procedure expose Globals.
    record = VRInfo( "Record" )
    ok = VRMethod( "CN_QRY_OrderItem", "SetRecordAttr", record, "UserData", "Update" )
return

/*:VRX         CN_QRY_OrderItem_DoubleClick
*/
CN_QRY_OrderItem_DoubleClick: procedure expose Globals.
    record = VRInfo( "Record" )
    if( VRMethod( "CN_QRY_OrderItem", "ValidateRecord", record ) ) then do
        win = VRInfo( "Window" )
        oldprim = VRWindow( win )
        window = ObjectOpen( "CN_QRY_OrderItem", record, "SW_OrderItem" )
        call VRWindow( oldprim )
        call VRSet window, "UserData", record
    end
return

/*:VRX         CN_QRY_OrderItem_DragDrop
*/
CN_QRY_OrderItem_DragDrop: procedure expose Globals.
    call DragDropItem
return

/*:VRX         CN_QRY_OrderItem_EndEdit
*/
CN_QRY_OrderItem_EndEdit: procedure expose Globals.
    ok = VRSet( "PB_OrderDetail_Ok", "Enabled", 1 )
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "Quantity", "ReadOnly", 1 )
return

/*:VRX         CN_QRY_OrderItem_Fini
*/
CN_QRY_OrderItem_Fini: procedure expose Globals.
    retcode = 1
    ok = VRMethod( "CNCT_1", "Execute", "Begin SubTransaction" )

    ok = VRMethod( "CN_QRY_OrderItem", "GetRecordList", "All", "reclist." )
    n = 0
    do i = 1 to reclist.0
        data = VRMethod( "CN_QRY_OrderItem", "GetRecordAttr", reclist.i, "UserData" )
        if( data \= "" ) then do
            n = n + 1
            updateRec.n = reclist.i
        end
    end
    updateRec.0 = n

    if( updateRec.0 > 0 ) then do
        ok = VRMethod( "CN_QRY_OrderItem", "DBUpdate", "updateRec." )
        if( ok \= 1 ) then do
            buttons.0 = 2
            buttons.1 = "~Ignore"
            buttons.2 = "~Cancel"
            ret = VRMessage( VRWindow(), "Error updating record: "||,
                  VRGet( "QRY_OrderItem", "Status" ), "Error", "E",,
                  "buttons.", 1, 2 )
            if( ret = 2 ) then do
                ok = VRMethod( "CNCT_1", "Execute", "RollBack SubTransaction" )
                retcode = 0
                signal CN_QRY_OrderItem_Fini_Done
            end
        end
    end

    ok = VRMethod( "CNCT_1", "Execute", "End SubTransaction" )
    call ObjectListClosed "CN_QRY_OrderItem"
    call QRY_OrderItem_Fini

CN_QRY_OrderItem_Fini_Done:
return retcode

/*:VRX         CN_QRY_OrderItem_Init
*/
CN_QRY_OrderItem_Init: procedure expose Globals.
    parse arg ordernum
    
    ok = VRSet( "CN_QRY_OrderItem", "Painting", 0 )
    fieldHandle = VRMethod( "CN_QRY_OrderItem", "AddField", "String", "Description", "Descript" )

    call QRY_OrderItem_Init ordernum

    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "ordernum", "Visible", 0 )
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "item", "Visible", 0 )
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "Descript", "ReadOnly", 1 )
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "ProdNum", "ReadOnly", 1, "Title", "Product No." )
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "Quantity", "ReadOnly", 1, "Title", "Quantity" )
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "Price", "ReadOnly", 1, "Title", "Price" )

    ok = VRMethod( "CN_QRY_OrderItem", "GetRecordList", "All", "records." )
    do i = 1 to records.0
        call GetDesc records.i
    end

    keyfields.0 = 2
    keyfields.1 = "ordernum"
    keyfields.2 = "item"
    call ObjectListOpened "OrderItem", "CN_QRY_OrderItem"

    ok = VRSet( "CN_QRY_OrderItem", "Painting", 1 )
return

/*:VRX         CN_QRY_Product_ContextMenu
*/
CN_QRY_Product_ContextMenu: procedure expose Globals.
    call VRMethod "Popup_Product", "Popup"
return

/*:VRX         CN_QRY_Product_DoubleClick
*/
CN_QRY_Product_DoubleClick: procedure expose Globals.
    record = VRInfo( "Record" )
    if( record \= "" ) then do
        call OpenDetail "CN_QRY_Product", record, "prodnum", "SW_ProdDetail"
    end
return

/*:VRX         CN_QRY_Product_EndEdit
*/
CN_QRY_Product_EndEdit:  procedure expose Globals.
    record = VRInfo( "Record" )
    if( VRInfo("Cancelled") = 1 ) then do
        ok = VRMethod( "CN_QRY_Product", "DBReset", record )
        if( \ok ) then do
            status = VRGet( "QRY_Product", "Status" )
            call VRMessage VRWindow(), "Could not reset record:" status, "Error", "E"
        end
    end
    else do
        ok = VRMethod( "CN_QRY_Product", "DBUpdate", record )
        if( \ok ) then do
            status = VRGet( "QRY_Product", "Status" )
            call VRMessage VRWindow(), "Could not update record:" status, "Error", "E"
        end
    end

return
/*:VRX         CN_QRY_Product_Init
*/
CN_QRY_Product_Init: procedure expose Globals.
    fieldHandle = VRMethod( "CN_QRY_Product", "AddField", "Icon", "Icon", "icon" )
    fieldHandle = VRMethod( "CN_QRY_Product", "AddField", "ULong", "No.", "prodnum" )
    fieldHandle = VRMethod( "CN_QRY_Product", "AddField", "String", "Description", "descript" )
    fieldHandle = VRMethod( "CN_QRY_Product", "AddField", "String", "List price", "price" )
    ok = VRSet( "CN_QRY_Product", "DetailSort", "prodnum" )
    ok = VRSet( "CN_QRY_Product", "DBIconField", "icon" )
return

/*:VRX         CN_QRY_Product_Refresh
*/
CN_QRY_Product_Refresh: procedure expose Globals.
    ok = VRSet( "CN_QRY_Product", "Painting", 0 )
    ok = VRMethod( "QRY_Product", "Close" )
    if( ok ) then do
        call ObjectListClosed "CN_QRY_Product"
    end

    call QRY_Product_Init

    ok = VRMethod( "CN_QRY_Product", "SortRecords" )

    keyFields.0 = 2
    keyFields.1 = "Descript"        /* Must be a string */
    keyFields.2 = "ProdNum"         /* Real key */
    call ObjectListOpened "Product", "CN_QRY_Product"

    ok = VRSet( "CN_QRY_Product", "Painting", 1 )
return

/*:VRX         CNCT_1_Fini
*/
CNCT_1_Fini:  procedure expose Globals.
    /*  Disconnect from the database
    */
    if( VRGet( "CNCT_1", "Connected" ) = 1 ) then do
        if( VRGet( "CNCT_1", "Changed" ) = 1 ) then do
            __message = "Changes have been made. Press Save to save them or Discard to throw them away."
            __button.0 = 2
            __button.1 = "~Save"
            __button.2 = "~Discard"
            __retcode = VRMessage( VRWindow(), __message, "Confirm", "Q", "__button.", 1, 2 )
            if( __retcode = 1 ) then do
              __method = "Commit"
            end
            else do
              __method = "Rollback"
            end
            if( VRMethod( "CNCT_1", __method ) = 0 ) then do
                call VRMessage VRWindow(), method "failed:",
                    VRGet( "CNCT_1", "Status" ), "Error", "E"
            end
        end
        if( VRMethod( "CNCT_1", "Disconnect" ) = 0 ) then do
            call VRMessage VRWindow(), "Could not close connection:",
                VRGet( "CNCT_1", "Status" ), "Error", "E"
        end
    end
return

/*:VRX         CNCT_1_Init
*/
CNCT_1_Init:  procedure expose Globals.
    /* Choose a database type */

    database_type = DBCnct( VRWindow() )

    if( database_type = "Abort" ) then do
        call Halt
    end
    
    /* Modify the connection object according to the selected database type.
    */

    if( database_type = "WSQL" ) then do
        call VRSet "CNCT_1", "DataSource", "WATCOM SQL" 
        call VRSet "CNCT_1", "userid", "dba" 
        call VRSet "CNCT_1", "password", "sql" 

        fspec = FindSampleDB()
        call VRSet "CNCT_1", "database", fspec         
    end
    else do
        /* IBM DB2/2 was choosen
        */

        call VRSet "CNCT_1", "DataSource", "IBM DB2/2"    
        call VRSet "CNCT_1", "userid", "" 
        call VRSet "CNCT_1", "password", "" 
        call VRSet "CNCT_1", "database", "wsample" 
    end
 
    /*  Connect to the database
    */
    if( VRMethod( "CNCT_1", "Connect" ) = 0 ) then do
            Lines.1 = "Could not open connection: "
            Lines.2 = VRGet( "CNCT_1", "Status" )
            Lines.3 = ""
            Lines.4 = "Exiting program."
            Lines.0 = 4

            Buttons.1 = "OK"
            Buttons.0 = 1
            id = VRMessageStem( VRWindow(), "Lines.", "Error", "E", "Buttons.", 1,  )
            
       call Halt
    end
return
/*:VRX         DDCB_QRY_OrderDetail_custnum_Change
*/
DDCB_QRY_OrderDetail_custnum_Change: procedure expose Globals.
    call QRY_CustName_Fini
    call QRY_CustName_Init
    call QRY_OrderDetail_TextBox_Change
return

/*:VRX         DDCB_QRY_OrderDetail_custnum_DragDrop
*/
DDCB_QRY_OrderDetail_custnum_DragDrop: procedure expose Globals.
    call DragDropCustomer
return

/*:VRX         DDCB_QRY_OrderItem_Prodnum_Change
*/
DDCB_QRY_OrderItem_Prodnum_Change: procedure expose Globals.
    call QRY_GetProdDesc_Fini
    call QRY_GetProdDesc_Init 1
    call QRY_OrderItemDetail_TextBox_Change
return

/*:VRX         DDCB_QRY_OrderItem_Prodnum_DragDrop
*/
DDCB_QRY_OrderItem_Prodnum_DragDrop: procedure expose Globals.
    srcCtn = VRInfo( "SourceObject" )
    srcRec = VRInfo( "SourceRecord" )

    name = VRGet( srcCtn, "Name" )
    parse VAR name "CN_QRY_" name
    if( translate( name )= "PRODUCT" ) then do
        value = VRMethod( srcCtn, "GetFieldData", srcRec, "prodnum" )
        ok = VRSet( "DDCB_QRY_OrderItem_Prodnum", "Value", value )
    end
return

/*:VRX         DragDropCustomer
*/
DragDropCustomer: procedure expose Globals.
/*  This routine handles the dragging and dropping of a 
    customer.
*/
    srcCtn = VRInfo( "SourceObject" )
    srcRec = VRInfo( "SourceRecord" )

    name = VRGet( srcCtn, "Name" )
    parse VAR name "CN_QRY_" name
    if( translate( name )= "CUSTOMER" ) then do
        value = VRMethod( srcCtn, "GetFieldData", srcRec, "custnum" )
        ok = VRSet( "DDCB_QRY_OrderDetail_custnum", "Value", value )
    end
return

/*:VRX         DragDropItem
*/
DragDropItem: procedure expose Globals.
/*  This routine handles the drag and drop of a product.
*/
    srcCtn = VRInfo( "SourceObject" )
    srcRec = VRInfo( "SourceRecord" )

    name = VRGet( srcCtn, "Name" )
    parse VAR name "CN_QRY_" name
    if( translate( name )= "PRODUCT" ) then do
        item = GetNextItemNum()
        ordernum = VRGet( "EF_QRY_OrderDetail_ordernum", "Value" )
    
        value = VRMethod( srcCtn, "GetFieldData", srcRec, "values." )
        record = VRMethod( 'CN_QRY_OrderItem', 'AddRecord',, "Last" )

        ok = VRMethod( "CN_QRY_OrderItem", "SetFieldData", record, ,
                       "prodnum", values.!prodnum,,
                       "Descript", values.!descript,,
                       "price", values.!price,,
                       "ordernum", ordernum,,
                       "item", item )

        ok = VRMethod( "CN_QRY_OrderItem", "SetFieldAttr", "Quantity", "ReadOnly", 0 )
        call VRMethod 'CN_QRY_OrderItem', 'OpenEdit', record, "quantity"
    end        
return

/*:VRX         DT_QRY_CustName_name_DragDrop
*/
DT_QRY_CustName_name_DragDrop: procedure expose Globals.
    call DragDropCustomer
return

/*:VRX         DT_QRY_OrderDetail_custnum_DragDrop
*/
DT_QRY_OrderDetail_custnum_DragDrop: procedure expose Globals.
    call DragDropCustomer
return

/*:VRX         EF_QRY_CustDetail_city_Change
*/
EF_QRY_CustDetail_city_Change:  procedure expose Globals.
    call QRY_CustDetail_TextBox_Change
return
/*:VRX         EF_QRY_CustDetail_name_Change
*/
EF_QRY_CustDetail_name_Change: procedure expose Globals.
    call QRY_CustDetail_TextBox_Change
return
/*:VRX         EF_QRY_CustDetail_phone_Change
*/
EF_QRY_CustDetail_phone_Change: procedure expose Globals.
    call QRY_CustDetail_TextBox_Change
return
/*:VRX         EF_QRY_CustDetail_state_Change
*/
EF_QRY_CustDetail_state_Change: procedure expose Globals.
    call QRY_CustDetail_TextBox_Change
return
/*:VRX         EF_QRY_CustDetail_street_Change
*/
EF_QRY_CustDetail_street_Change: procedure expose Globals.
    call QRY_CustDetail_TextBox_Change
return
/*:VRX         EF_QRY_CustDetail_zip_Change
*/
EF_QRY_CustDetail_zip_Change: procedure expose Globals.
    call QRY_CustDetail_TextBox_Change
return
/*:VRX         EF_QRY_CustName_name_Change
*/
EF_QRY_CustName_name_Change: procedure expose Globals.
    call QRY_CustName_TextBox_Change
return
/*:VRX         EF_QRY_CustName_name_DragDrop
*/
EF_QRY_CustName_name_DragDrop: procedure expose Globals.
    call DragDropCustomer
return

/*:VRX         EF_QRY_OrderDetail_note_Change
*/
EF_QRY_OrderDetail_note_Change: procedure expose Globals.
    call QRY_OrderDetail_TextBox_Change
return
/*:VRX         EF_QRY_OrderDetail_order_date_Change
*/
EF_QRY_OrderDetail_order_date_Change: procedure expose Globals.
    call QRY_OrderDetail_TextBox_Change
return
/*:VRX         EF_QRY_OrderItem_price_Change
*/
EF_QRY_OrderItem_price_Change: procedure expose Globals.
    call QRY_OrderItemDetail_TextBox_Change
return
/*:VRX         EF_QRY_OrderItem_quantity_Change
*/
EF_QRY_OrderItem_quantity_Change: procedure expose Globals.
    call QRY_OrderItemDetail_TextBox_Change
return
/*:VRX         EF_QRY_ProdDetail_description_Change
*/
EF_QRY_ProdDetail_description_Change: procedure expose Globals.
    call QRY_ProdDetail_TextBox_Change
return

/*:VRX         EF_QRY_ProdDetail_Icon_Change
*/
EF_QRY_ProdDetail_Icon_Change: procedure expose Globals.
    object = VRInfo( "Object" )
    firstrecord = VRGet( "CN_ProdDetail_Icon", "FirstRecord" )
    ok = VRMethod( "CN_ProdDetail_Icon", "SetRecordAttr",,
                   firstrecord, "Icon", VRGet( object, "Value" ) )
    call QRY_ProdDetail_TextBox_Change
return
/*:VRX         EF_QRY_ProdDetail_list_price_Change
*/
EF_QRY_ProdDetail_list_price_Change: procedure expose Globals.
    call QRY_ProdDetail_TextBox_Change
return
/*:VRX         FillDDCBList
*/
FillDDCBList: procedure expose Globals.
    parse arg qry, ddcb
    ok = VRMethod( qry, "Open" )
    ok = VRMethod( qry, "MoveFirst" )

    i = 0
    do While( ok )
        i = i + 1
        ok = VRMethod( qry, "RowData", "data." )
        list.i = data.1
        ok = VRMethod( qry, "MoveNext" )
    end
    list.0 = i

    ok = VRMethod( qry, "Close" )
    ok = VRMethod( ddcb, "Clear" )
    ok = VRMethod( ddcb, "AddStringList", "list." )
return

/*:VRX         FindSampleDB
*/
FindSampleDB: procedure
    /* Finds the location of the WATCOM SQL VX-Rexx database
    */

    vxdir = VALUE( 'vxrexx', , 'os2environment' )

    if( RIGHT(vxdir, 1) = '\' ) then do 
        vxdir = LEFT( vxdir, LENGTH(vxdir) - 1 )
    end
    
    vxdir = vxdir || "\wsample.db"
    
return vxdir
/*:VRX         Fini
*/
Fini: procedure expose Globals.
    call IniSave
    call CNCT_1_Fini
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         GB_Customer_Click
*/
GB_Customer_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_OrderItem", "CloseEdit" )
return

/*:VRX         GB_Customer_DragDrop
*/
GB_Customer_DragDrop: procedure expose Globals.
    call DragDropCustomer
return

/*:VRX         GB_OrderItem_Click
*/
GB_OrderItem_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_OrderItem", "CloseEdit" )
return

/*:VRX         GB_OrderItem_DragDrop
*/
GB_OrderItem_DragDrop: procedure expose Globals.
    call DragDropItem
return

/*:VRX         GetDesc
*/
GetDesc: procedure expose Globals.
/*  Get the description of a prodnum for a certain record.
*/
    parse arg record

    /* Get the product number from the record
    */
    prodnum = VRMethod( "CN_QRY_OrderItem", "GetFieldData", record, "prodnum" )

    /* Use the RowData method to the data needed
    */
    ok = VRMethod( "QRY_GetDesc", "Open" )
    ok = VRMethod( "QRY_GetDesc", "RowData", "data." )
    ok = VRMethod( "QRY_GetDesc", "Close" )
    if( DataType( data.2 ) \= "NUM" ) then signal GetDesc_Done

    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldData", record, "Descript", data.1 )

GetDesc_Done:
return

/*:VRX         GetMaxNum
*/
GetMaxNum: procedure expose Globals.
/*  Get the maximum index number for a group.
*/
    parse arg name

    /* Get the max number
    */
    max = ""
    if( ( translate( name ) = "CUSTOMER" ) | ,
        ( translate( name ) = "ORDER" ) ) then do
        query = "QRY_GetMax"||name
        ok = VRMethod( query, "Open" )
        ok = VRMethod( query, "RowData", "data." )
        ok = VRMethod( query, "Close" )
        if( DataType( data.1 ) = "NUM" ) then do
            max = data.1
        end
        else do
            max = 1
        end
    end    
return max

/*:VRX         GetNextItemNum
*/
GetNextItemNum: procedure expose Globals.
/*  Get the next item number for an order
*/
    lastrecord = VRGet( "CN_QRY_OrderItem", "LastRecord" )
    if( VRMethod( "CN_QRY_OrderItem", "ValidateRecord", lastrecord ) ) then do
        item = VRMethod( "CN_QRY_OrderItem", "GetFieldData", lastrecord, "item" ) + 1
    end
    else do
        item = 1
    end 
return item

/*:VRX         Halt
*/
Halt: procedure expose Globals.
    signal _VREHalt
return

/*:VRX         IniGet
*/
IniGet: procedure expose Globals.
    /* Get information from the ini file and set the
       environment.
    */
    group = "Customer"
    Globals.!View.group = "Detail"
    group = "Order"
    Globals.!View.group = "Detail"

    group = "Product"
    Globals.!View.group =  "Icon"

    custwin = VRGetIni( "CUSTOMER", "OPEN", Globals.!iniFile, "NoClose" )
    if( DataType( custwin ) = "NUM" ) then do
        /* Assume the ini file is valid
        */
        prodwin = VRGetIni( "PRODUCT", "OPEN", Globals.!iniFile, "NoClose" )
        ordwin = VRGetIni( "ORDER", "OPEN", Globals.!iniFile, "NoClose" )

        group = "Customer"
        Globals.!View.group = VRGetIni( "CUSTOMER", "VIEW", Globals.!iniFile, "NoClose" )
        if( custwin = 1 ) then do
            call ObjectOpen "CN_MainList", Globals.!RecHandle.group, "SW_Customer"
        end

        group = "Product"
        Globals.!View.group = VRGetIni( "PRODUCT", "VIEW", Globals.!iniFile, "NoClose" )
        if( prodwin = 1 ) then do
            call ObjectOpen "CN_MainList", Globals.!RecHandle.group, "SW_Product"
        end

        group = "Order"
        Globals.!View.group = VRGetIni( "ORDER", "VIEW", Globals.!iniFile, "NoClose" )
        if( ordwin = 1 ) then do
            call ObjectOpen "CN_MainList", Globals.!RecHandle.group, "SW_Order"
        end
    end
return

/*:VRX         IniSave
*/
IniSave: procedure expose Globals.
    /* Save the status information to the ini file
    */

    group = "Customer"
    ok = VRSetIni( "CUSTOMER", "OPEN", VRIsValidObject( "SW_Customer" ), ,
                     Globals.!iniFile, "NoClose" )
    ok = VRSetIni( "CUSTOMER", "VIEW", Globals.!View.group, ,
                     Globals.!iniFile, "NoClose" )

    group = "Product"
    ok = VRSetIni( "PRODUCT", "OPEN", VRIsValidObject( "SW_Product" ), ,
                     Globals.!iniFile, "NoClose" )
    ok = VRSetIni( "PRODUCT", "VIEW", Globals.!View.group, ,
                     Globals.!iniFile, "NoClose" )

    group = "Order"
    ok = VRSetIni( "ORDER", "OPEN", VRIsValidObject( "SW_Order" ), ,
                     Globals.!iniFile, "NoClose" )
    ok = VRSetIni( "ORDER", "VIEW", Globals.!View.group, ,
                     Globals.!iniFile )
return

/*:VRX         Init
*/
Init: procedure expose Globals.
    window = VRWindow()

    /* Turn off console unless run from the design environment */    
    program = VRGet( "Application", "Program" )
    if program \= "" then do
        ok = VRRedirectStdIO( "Off" )
    end

    /* Set path to INI file */
    Globals.!iniFile = VRIniDir() || "\VROrder.ini"

    /* connect to the database */
    call CNCT_1_Init

    /* Set up the window */
    call CN_Main_init

    keyFields.0 = 0
    call ObjectListOpened "Main", "CN_MainList"

    /* Set up the enviroment */
    call IniGet

    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MI_Customer_Edit_Click
*/
MI_Customer_Edit_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Customer", "GetRecordList", "SourceOrSelected", "records." )
    do i = 1 to records.0
        call OpenDetail "CN_QRY_Customer", records.i, "custnum", "SW_CustDetail"
    end
return

/*:VRX         MI_Customer_New_Click
*/
MI_Customer_New_Click: procedure expose Globals.
    call OpenDetail "CN_QRY_Customer", "NEW", "custnum", "SW_CustDetail"
return

/*:VRX         MI_CustomerSort_City_Click
*/
MI_CustomerSort_City_Click: procedure expose Globals.
    call SetCustSort "City"
return

/*:VRX         MI_CustomerSort_Custnum_Click
*/
MI_CustomerSort_Custnum_Click: procedure expose Globals.
    call SetCustSort "custnum"
return

/*:VRX         MI_CustomerSort_Name_Click
*/
MI_CustomerSort_Name_Click: procedure expose Globals.
    call SetCustSort "Name"
return

/*:VRX         MI_CustomerSort_Phone_Click
*/
MI_CustomerSort_Phone_Click: procedure expose Globals.
    call SetCustSort "Phone"
return

/*:VRX         MI_CustomerSort_State_Click
*/
MI_CustomerSort_State_Click: procedure expose Globals.
    call SetCustSort "State"
return

/*:VRX         MI_CustomerSort_Street_Click
*/
MI_CustomerSort_Street_Click: procedure expose Globals.
    call SetCustSort "Street"
return

/*:VRX         MI_CustomerSort_Zip_Click
*/
MI_CustomerSort_Zip_Click: procedure expose Globals.
    call SetCustSort "Zip"
return

/*:VRX         MI_CustomerView_Arrange_Click
*/
MI_CustomerView_Arrange_Click:  procedure expose Globals.
    ok = VRMethod( "CN_QRY_Customer", "Arrange" )
return

/*:VRX         MI_CustomerView_Detail_Click
*/
MI_CustomerView_Detail_Click: procedure expose Globals.
     call SetViews "Customer", "Detail"
return

/*:VRX         MI_CustomerView_Icon_Click
*/
MI_CustomerView_Icon_Click: procedure expose Globals.
     call SetViews "Customer", "Icon"
return

/*:VRX         MI_MainHelp_ProdInf_Click
*/
MI_MainHelp_ProdInf_Click: procedure expose Globals.
    Call prodinfo VRWindow()
return

/*:VRX         MI_Order_Edit_Click
*/
MI_Order_Edit_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Order", "GetRecordList", "SourceOrSelected", "records." )
    do i = 1 to records.0
        call OpenDetail "CN_QRY_Order", records.i, "ordernum", "SW_OrderDetail"
    end
return

/*:VRX         MI_Order_New_Click
*/
MI_Order_New_Click: procedure expose Globals.
    call OpenDetail "CN_QRY_Order", "NEW", "ordernum", "SW_OrderDetail"
return

/*:VRX         MI_OrderSort_name_Click
*/
MI_OrderSort_name_Click: procedure expose Globals.
    call SetOrderSort "name"
return

/*:VRX         MI_OrderSort_OrderDat_Click
*/
MI_OrderSort_OrderDat_Click: procedure expose Globals.
    call SetOrderSort "orderdat"
return

/*:VRX         MI_OrderSort_ordernum_Click
*/
MI_OrderSort_ordernum_Click: procedure expose Globals.
    call SetOrderSort "ordernum"
return

/*:VRX         MI_OrderView_Detail_Click
*/
MI_OrderView_Detail_Click: procedure expose Globals.
     call SetViews "Order", "Detail"
return

/*:VRX         MI_OrderView_Icon_Click
*/
MI_OrderView_Icon_Click: procedure expose Globals.
     call SetViews "Order", "Icon"
return

/*:VRX         MI_OrderView_Sort_Click
*/
MI_OrderView_Sort_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Order", "Arrange" )
return

/*:VRX         MI_Product_Edit_Click
*/
MI_Product_Edit_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Product", "GetRecordList", "SourceOrSelected", "records." )
    do i = 1 to records.0
        call OpenDetail "CN_QRY_Product", records.i, "prodnum", "SW_ProdDetail"
    end
return

/*:VRX         MI_Product_New_Click
*/
MI_Product_New_Click: procedure expose Globals.
    call OpenDetail "CN_QRY_Product", "NEW", "prodnum", "SW_ProdDetail"
return

/*:VRX         MI_Product_Sales_Click
*/
MI_Product_Sales_Click: procedure expose Globals.
    call VRLoadSecondary( "SW_Chart" )
return

/*:VRX         MI_ProductSort_Descript_Click
*/
MI_ProductSort_Descript_Click: procedure expose Globals.
    call SetProdSort "Descript"
return

/*:VRX         MI_ProductSort_Prodnum_Click
*/
MI_ProductSort_Prodnum_Click: procedure expose Globals.
    call SetProdSort "Prodnum"
return

/*:VRX         MI_ProductView_Arrange_Click
*/
MI_ProductView_Arrange_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Product", "Arrange" )
return

/*:VRX         MI_ProductView_Detail_Click
*/
MI_ProductView_Detail_Click: procedure expose Globals.
     call SetViews "Product", "Detail"
return

/*:VRX         MI_ProductView_Icon_Click
*/
MI_ProductView_Icon_Click: procedure expose Globals.
     call SetViews "Product", "Icon"
return

/*:VRX         OpenDetail
*/
/* This function opens a detail view.
*/
OpenDetail: procedure expose Globals.
    parse arg ctn, record, field, window

    parse VAR ctn "CN_QRY_" name

    record = translate( record )

    /* For a new record
    */
    if( record = "NEW" ) then do
        num = GetMaxNum( name )

        if( DataType( num ) \= "NUM" ) then do
            num = ""
        end

        /* If it is already opened bring it up again,
           otherwise open a new window.
        */
        If( VRIsValidObject( Globals.!__NewWin.name ) ) then do
            window = Globals.!__NewWin.name
            call VRMethod window, "Activate" 
        end
        else do
            window = VRLoadSecondary( window )
            Globals.!__NewWin.name = window
        end
    end
    else do
        num = VRMethod( ctn, "GetFieldData", record, field )
        window = ObjectOpen( ctn, record, window )
    end

    /* Pass the parameter to the window */
    call VRSet window, "UserData", record || "." || num

OpenDetail_Done:            
return

/*:VRX         OrderApp_Close
*/
OrderApp_Close: procedure expose Globals.
    call Quit
return

/*:VRX         PB_CustDetail_Cancel_Click
*/
PB_CustDetail_Cancel_Click: procedure expose Globals.
    call SW_CustDetail_FIni
return

/*:VRX         PB_CustDetail_Ok_Click
*/
PB_CustDetail_Ok_Click: procedure expose Globals.
    window = VRInfo( "Window" )
    
    data = VRGet( window, "UserData" )
    parse VAR data record "." num

    if( record = "NEW" ) then do
        opr = "Insert"
    end
    else do
        opr = "Update"
    end
    ok = VRMethod( "QRY_CustDetail", opr )
    
    keys.0 = 1
    keys.0 = num
    call ObjectRefresh "Customer", ""

    call QRY_CustDetail_Fini

    window = VRInfo( "Window" )
    call ObjectClosed( window )
    call VRDestroy window
    drop window
return

/*:VRX         PB_OrderDetail_Cancel_Click
*/
PB_OrderDetail_Cancel_Click: procedure expose Globals.
    call SW_OrderDetail_Fini
return

/*:VRX         PB_OrderDetail_Ok_Click
*/
PB_OrderDetail_Ok_Click: procedure expose Globals.

    ok = VRMethod( "CN_QRY_OrderItem", "CloseEdit" )
    window = VRInfo( "Window" )
    
    data = VRGet( window, "UserData" )
    parse VAR data record "." num

    if( record = "NEW" ) then do
        opr = "Insert"
    end
    else do
        opr = "Update"
    end
    ok = VRMethod( "QRY_OrderDetail", opr )

    if( \ok ) then do
        call VRMessage VRWindow(), "Could not update database:",
        VRGet( "QRY_OrderDetail", "Status" ),,"I"
        signal PB_OrderDetail_Ok_Click_Done
    end

    
    ok = CN_QRY_OrderItem_Fini()
    if( \ok ) then signal PB_OrderDetail_Ok_Click_Done

    call QRY_CustName_Fini
    call QRY_OrderDetail_Fini

    keys.0 = 1
    keys.0 = num
    call ObjectRefresh "Order", ""

    call ObjectClosed window
    call VRDestroy window
    drop window

PB_OrderDetail_Ok_Click_Done:
return

/*:VRX         PB_OrderItem_Add_Click
*/
PB_OrderItem_Add_Click: procedure expose Globals.

    ok = VRMethod( "CN_QRY_OrderItem", "CloseEdit" )

    win = VRInfo( "Window" )
    item = GetNextItemNum()
    ordernum = VRGet( "EF_QRY_OrderDetail_ordernum", "Value" )

    record = VRMethod( 'CN_QRY_OrderItem', 'AddRecord',, "Last" )
    
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldData", record, "ordernum", ordernum, "item", item )
    if( VRIsValidObject( Globals.!__NewWin.OrderItem.win ) ) then do
        window = Globals.!__NewWin.OrderItem.win
        call VRMethod window, "Activate" 
    end
    else do
        oldprim = VRWindow( win )
        window = ObjectOpen( "CN_QRY_OrderItem", record, "SW_OrderItem" )
        call VRWindow( oldprim )
        Globals.!__NewWin.OrderItem.win = window 
    end
    drop win
    call VRSet window, "UserData", record
return
/*:VRX         PB_OrderItem_Add_DragDrop
*/
PB_OrderItem_Add_DragDrop: procedure expose Globals.
    call DragDropItem
return

/*:VRX         PB_OrderItem_Cancel_Click
*/
PB_OrderItem_Cancel_Click: procedure expose Globals.
    call SW_OrderItem_Fini
return

/*:VRX         PB_OrderItem_Ok_Click
*/
PB_OrderItem_Ok_Click: procedure expose Globals.
    window = VRInfo( "Window" )
    record = VRGet( window, "UserData" )
    
    prodnum = VRGet( "DDCB_QRY_OrderItem_Prodnum", "Value" )
    description = VRGet( "EF_QRY_GetProdDesc_Description", "Value" )
    price = VRGet( "EF_QRY_OrderItem_price", "Value" )
    quantity = VRGet( "EF_QRY_OrderItem_quantity", "Value" )
    ok = VRMethod( "CN_QRY_OrderItem", "SetFieldData", record,,
                   "descript", description,,
                   "price", price,,
                   "quantity", quantity,,
                   "prodnum", prodnum )
    
    ok = VRMethod( "CN_QRY_OrderItem", "SetRecordAttr", record, "UserData", "Update" )

    call QRY_GetProdDesc_Fini
    call ObjectClosed window


    call QRY_OrderDetail_TextBox_Change
    call VRDestroy window
    drop window
return

/*:VRX         PB_ProdDetail_Cancel_Click
*/
PB_ProdDetail_Cancel_Click: procedure expose Globals.
    call SW_ProdDetail_Fini
return

/*:VRX         PB_ProdDetail_Find_Click
*/
PB_ProdDetail_Find_Click: procedure expose Globals.
    iconName = VRFileDialog( VRInfo("Window"), "Icon", "O", "*.ICO" )
    if iconName \= "" then do
        ok = VRSet( "EF_QRY_ProdDetail_Icon", "Value", iconName )
    end
return

/*:VRX         PB_ProdDetail_Ok_Click
*/
PB_ProdDetail_Ok_Click: procedure expose Globals.
    window = VRInfo( "Window" )
    data = VRGet( window, "UserData" )
    parse VAR data record "." .
    prodnum = VRGet( "EF_QRY_ProdDetail_prodnum", "Value" )
    
    if( record = "NEW" ) then do
        call QRY_CheckProdNum_Init prodnum
        ok = VRMethod( "QRY_CheckProdNum", "RowData", "data." )
        call QRY_CheckProdNum_Fini    
        if( DataType( data.1 ) = "NUM" ) then do
            call VRMessage window, "Product number is not unique!",,
                 "Error", "E"
            signal PB_ProdDetail_Ok_Click_Done
        end

        opr = "Insert"
    end
    else do
        opr = "Update"
    end

    ok = VRMethod( "QRY_ProdDetail", opr )

    keys.0 = 1
    keys.0 = prodnum
    call ObjectRefresh "Product", ""

    call QRY_ProdDetail_Fini
    window = VRInfo( "Window" )
    call ObjectClosed window

    call VRDestroy window
    drop window
PB_ProdDetail_Ok_Click_Done:
return

/*:VRX         Popup_Customer_Arrange_Click
*/
Popup_Customer_Arrange_Click: procedure expose Globals.
    call ResetSource "CN_QRY_Customer"
    ok = VRMethod( "CN_QRY_Customer", "Arrange" )
return

/*:VRX         Popup_Customer_Edit_Click
*/
Popup_Customer_Edit_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Customer", "GetRecordList", "SourceOrSelected", "records." )
    do i = 1 to records.0
        call OpenDetail "CN_QRY_Customer", records.i, "custnum", "SW_CustDetail"
    end
    call ResetSource "CN_QRY_Customer"
return

/*:VRX         Popup_Customer_New_Click
*/
Popup_Customer_New_Click: procedure expose Globals.
    call ResetSource "CN_QRY_Customer"
    call OpenDetail "CN_QRY_Customer", "NEW", "custnum", "SW_CustDetail"
return

/*:VRX         Popup_CustomerSort_City_Click
*/
Popup_CustomerSort_City_Click: procedure expose Globals.
    call SetCustSort "City"
return

/*:VRX         Popup_CustomerSort_Custnum_Click
*/
Popup_CustomerSort_Custnum_Click: procedure expose Globals.
    call SetCustSort "Custnum"
return

/*:VRX         Popup_CustomerSort_Name_Click
*/
Popup_CustomerSort_Name_Click: procedure expose Globals.
    call SetCustSort "Name"
return

/*:VRX         Popup_CustomerSort_Phone_Click
*/
Popup_CustomerSort_Phone_Click: procedure expose Globals.
    call SetCustSort "Phone"
return

/*:VRX         Popup_CustomerSort_State_Click
*/
Popup_CustomerSort_State_Click: procedure expose Globals.
    call SetCustSort "State"
return

/*:VRX         Popup_CustomerSort_Street_Click
*/
Popup_CustomerSort_Street_Click: procedure expose Globals.
    call SetCustSort "Street"
return

/*:VRX         Popup_CustomerSort_Zip_Click
*/
Popup_CustomerSort_Zip_Click: procedure expose Globals.
    call SetCustSort "Zip"
return

/*:VRX         Popup_Order_Arrange_Click
*/
Popup_Order_Arrange_Click: procedure expose Globals.
    call ResetSource "CN_QRY_Order"
    ok = VRMethod( "CN_QRY_Order", "Arrange" )
return

/*:VRX         Popup_Order_Edit_Click
*/
Popup_Order_Edit_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Order", "GetRecordList", "SourceOrSelected", "records." )
    do i = 1 to records.0
        call OpenDetail "CN_QRY_Order", records.i, "ordernum", "SW_OrderDetail"
    end
    call ResetSource "CN_QRY_Order"
return

/*:VRX         Popup_Order_New_Click
*/
Popup_Order_New_Click: procedure expose Globals.
    call ResetSource "CN_QRY_Order"
    call OpenDetail "CN_QRY_Order", "NEW", "ordernum", "SW_OrderDetail"
return

/*:VRX         Popup_OrderSort_name_Click
*/
Popup_OrderSort_name_Click: procedure expose Globals.
    call SetOrderSort "name"
return

/*:VRX         Popup_OrderSort_OrderDat_Click
*/
Popup_OrderSort_OrderDat_Click: procedure expose Globals.
    call SetOrderSort "orderdate"
return

/*:VRX         Popup_OrderSort_ordernum_Click
*/
Popup_OrderSort_ordernum_Click: procedure expose Globals.
    call SetOrderSort "ordernum"
return

/*:VRX         Popup_Product_Arrange_Click
*/
Popup_Product_Arrange_Click: procedure expose Globals.
    call ResetSource "CN_QRY_Product"
    ok = VRMethod( "CN_QRY_Product", "Arrange" )
return

/*:VRX         Popup_Product_Edit_Click
*/
Popup_Product_Edit_Click: procedure expose Globals.
    ok = VRMethod( "CN_QRY_Product", "GetRecordList", "SourceOrSelected", "records." )
    do i = 1 to records.0
        call OpenDetail "CN_QRY_Product", records.i, "prodnum", "SW_ProdDetail"
    end
    call ResetSource "CN_QRY_Product"
return

/*:VRX         Popup_Product_New_Click
*/
Popup_Product_New_Click: procedure expose Globals.
    call ResetSource "CN_QRY_Product"
    call OpenDetail "CN_QRY_Product", "NEW", "prodnum", "SW_ProdDetail"
return

/*:VRX         Popup_ProductSort_Descript_Click
*/
Popup_ProductSort_Descript_Click: procedure expose Globals.
    call SetProdSort "Description"
return

/*:VRX         Popup_ProductSort_Prodnum_Click
*/
Popup_ProductSort_Prodnum_Click: procedure expose Globals.
    call SetProdSort "Prodnum"
return

/*:VRX         QRY_CheckProdNum_Fini
*/
QRY_CheckProdNum_Fini: procedure expose Globals.
 
    /*  Close a query
    */
    if( VRMethod( "QRY_CheckProdNum", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_CheckProdNum", "Status" ),,"I"
    end
return
/*:VRX         QRY_CheckProdNum_Init
*/
QRY_CheckProdNum_Init: procedure expose Globals.
    parse arg prodnum

    /*  Open the query
    */
    if( VRMethod( "QRY_CheckProdNum", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_CheckProdNum", "Status" )
    end
return
/*:VRX         QRY_CustDetail_Fini
*/
QRY_CustDetail_Fini: procedure expose Globals.
 
    /*  Close a query
    */
    if( VRMethod( "QRY_CustDetail", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_CustDetail", "Status" ),,"I"
    end
return
/*:VRX         QRY_CustDetail_Init
*/
QRY_CustDetail_Init: procedure expose Globals.
    parse arg custnum

    /*  Open the query
    */
    if( VRMethod( "QRY_CustDetail", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_CustDetail", "Status" )
    end
return
/*:VRX         QRY_CustDetail_TextBox_Change
*/
QRY_CustDetail_TextBox_Change: procedure expose Globals.
    value = VRGet( "EF_QRY_CustDetail_name", "Value" )
    if( value = "" ) then do
        ok = VRSet( "PB_CustDetail_Ok", "Enabled", 0 )
    end
    else do
        ok = VRSet( "PB_CustDetail_Ok", "Enabled", 1 )
    end
return
/*:VRX         QRY_CustName_Fini
*/
QRY_CustName_Fini: procedure expose Globals.
    ok = VRMethod( "QRY_CustName", "Close" )
return

/*:VRX         QRY_CustName_Init
*/
QRY_CustName_Init: procedure expose Globals.
    custnum = VRGet( "DDCB_QRY_OrderDetail_custnum", "Value" )
    ok = VRMethod( "QRY_CustName", "Open" )
return

/*:VRX         QRY_Customer_Fini
*/
QRY_Customer_Fini: procedure expose Globals.
 
    /*  Close a query
    */
    if( VRMethod( "QRY_Customer", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_Customer", "Status" ),,"I"
    end
return
/*:VRX         QRY_Customer_Init
*/
QRY_Customer_Init: procedure expose Globals.
 
    /*  Open the query
    */
    if( VRMethod( "QRY_Customer", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_Customer", "Status" )
    end
return
/*:VRX         QRY_GetMaxOrder_Fini
*/
QRY_GetMaxOrder_Fini: procedure expose Globals.
    /* Close a query.
    */
    if( VRMethod( "QRY_GetMaxOrder", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_GetMaxOrder", "Status" ),,"I"
    end
return
/*:VRX         QRY_GetMaxOrder_Init
*/
QRY_GetMaxOrder_Init: procedure expose Globals.
 
    /*  Open the query
    */
    if( VRMethod( "QRY_GetMaxOrder", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_GetMaxOrder", "Status" )
    end
return
/*:VRX         QRY_GetProdDesc_Fini
*/
QRY_GetProdDesc_Fini: procedure expose Globals.
    ok = VRMethod( "QRY_GetProdDesc", "Close" )
return

/*:VRX         QRY_GetProdDesc_Init
*/
QRY_GetProdDesc_Init: procedure expose Globals.
    parse arg setprice

    prodnum = VRGet( "DDCB_QRY_OrderItem_Prodnum", "Value" )
    ok = VRMethod( "QRY_GetProdDesc", "Open" )
    if( setprice = 1 ) then do
        ok = VRMethod( "QRY_GetProdDesc", "RowData", "data." )
        if( DataType( data.2 ) = "NUM" ) then do
            ok = VRSet( "EF_QRY_OrderItem_price", "Value", data.2 )
        end
    end
return

/*:VRX         QRY_Order_Fini
*/
QRY_Order_Fini: procedure expose Globals.
 
    /*  Close a query
    */
    if( VRMethod( "QRY_Order", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_Order", "Status" ),,"I"
    end
return
/*:VRX         QRY_Order_Init
*/
QRY_Order_Init: procedure expose Globals.
 
    /*  Open the query
    */
    if( VRMethod( "QRY_Order", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_Order", "Status" )
    end
return
/*:VRX         QRY_OrderDetail_Fini
*/
QRY_OrderDetail_Fini: procedure expose Globals.
 
    /*  Close a query
    */
    if( VRMethod( "QRY_OrderDetail", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_OrderDetail", "Status" ),,"I"
    end
return
/*:VRX         QRY_OrderDetail_Init
*/
QRY_OrderDetail_Init: procedure expose Globals.
    parse arg ordernum 
    /*  Open the query
    */
    if( VRMethod( "QRY_OrderDetail", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_OrderDetail", "Status" )
    end
return
/*:VRX         QRY_OrderDetail_TextBox_Change
*/
QRY_OrderDetail_TextBox_Change: procedure expose Globals.
    value = VRGet( "EF_QRY_CustName_name", "Value" )
    if( value \= "" ) then do
        ok = VRSet( "PB_OrderDetail_Ok", "Enabled", 1 )
    end
    else do
        ok = VRSet( "PB_OrderDetail_Ok", "Enabled", 0 )
    end
return
/*:VRX         QRY_OrderItem_Fini
*/
QRY_OrderItem_Fini: procedure expose Globals.
     /*  Close a query
    */
    if( VRMethod( "QRY_OrderItem", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_OrderItem", "Status" ),,"I"
    end
return

/*:VRX         QRY_OrderItem_Init
*/
QRY_OrderItem_Init: procedure expose Globals.
    parse arg ordernum
 
    /*  Open the query
    */
    if( VRMethod( "QRY_OrderItem", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_OrderItem", "Status" )
    end
return

/*:VRX         QRY_OrderItemDetail_TextBox_Change
*/
QRY_OrderItemDetail_TextBox_Change: procedure expose Globals.
    prodnum = VRGet( "DDCB_QRY_OrderItem_Prodnum", "Value" )
    desc = VRGet( "EF_QRY_GetProdDesc_Description", "Value" )
    price = VRGet( "EF_QRY_OrderItem_price", "Value" )
    quantity = VRGet( "EF_QRY_OrderItem_quantity", "Value" )
    if( ( DataType( price )\= "NUM" ) |,
        ( prodnum= "" ) | (quantity = "" )|(desc = "" ) ) then do
        ok = VRSet( "PB_OrderItem_Ok", "Enabled", 0 )
    end
    else do
        ok = VRSet( "PB_OrderItem_Ok", "Enabled", 1 )
    end
return

/*:VRX         QRY_ProdDetail_Fini
*/
QRY_ProdDetail_Fini: procedure expose Globals.
 
    /*  Close a query
    */
    if( VRMethod( "QRY_ProdDetail", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_ProdDetail", "Status" ),,"I"
    end
return
/*:VRX         QRY_ProdDetail_Init
*/
QRY_ProdDetail_Init: procedure expose Globals.
    parse arg prodnum
 
    /*  Open the query
    */
    if( DataType( prodnum ) \= "NUM" ) then do
        prodnum = "10000"
    end
    if( VRMethod( "QRY_ProdDetail", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_ProdDetail", "Status" )
    end
return
/*:VRX         QRY_ProdDetail_TextBox_Change
*/
QRY_ProdDetail_TextBox_Change: procedure expose Globals.
    desc = VRGet( "EF_QRY_ProdDetail_Icon", "Value" )
    price = VRGet( "EF_QRY_ProdDetail_list_price", "Value" )
    if( ( desc = "" ) | (DataType(price) \= "NUM" ) )then do
        ok = VRSet( "PB_ProdDetail_Ok", "Enabled", 0 )
    end
    else do
        ok = VRSet( "PB_ProdDetail_Ok", "Enabled", 1 )
    end
return
/*:VRX         QRY_Product_Fini
*/
QRY_Product_Fini: procedure expose Globals.
 
    if( VRMethod( "QRY_Product", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_Product", "Status" ),,"I"
    end
return
/*:VRX         QRY_Product_Init
*/
QRY_Product_Init: procedure expose Globals.
 
    /*  Open the query
    */
    if( VRMethod( "QRY_Product", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_Product", "Status" )
    end
return
/*:VRX         QRY_ProductSales_Fini
*/
QRY_ProductSales_Fini: procedure expose Globals.
 
    /*  Close a query
    */
    if( VRMethod( "QRY_ProductSales", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_ProductSales", "Status" ),,"I"
    end
return
/*:VRX         QRY_ProductSales_Init
*/
QRY_ProductSales_Init: procedure expose Globals.
 
    /*  Open the query
    */
    if( VRMethod( "QRY_ProductSales", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_ProductSales", "Status" )
    end
return
/*:VRX         Quit
*/
Quit: procedure expose Globals.
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         ResetSource
*/
/*
    call ResetSource container

    - Call after a context menu event to clear any source emphasis in the
    specified container 
*/
ResetSource: procedure
    parse arg container
    ok = VRMethod( container, "SetRecordAttr", "All", "Source", 0 )
    ok = VRSet( container, "Source", 0 )
return

/*:VRX         SetCustSort
*/
SetCustSort: procedure expose Globals.
    parse arg menu    

    Menus.0 = 7
    Menus.1 = "name"
    Menus.2 = "custnum"
    Menus.3 = "street"
    Menus.4 = "city"
    Menus.5 = "state"
    Menus.6 = "phone"
    Menus.7 = "zip"

    menu = translate( menu )
    do i = 1 to Menus.0
        if( translate( Menus.i ) = menu ) then do
            checked = i
            leave
        end
    end
    
    call SetSort "CN_QRY_Customer", "MI_CustomerSort_", "Popup_CustomerSort_", checked
return

/*:VRX         SetOrderSort
*/
SetOrderSort: procedure expose Globals.
    parse arg menu    

    Menus.0 = 3
    Menus.1 = "ordernum"
    Menus.2 = "name"
    Menus.3 = "orderdat"

    menu = translate( menu )
    do i = 1 to Menus.0
        if( translate( Menus.i ) = menu ) then do
            checked = i
            leave
        end
    end
    
    call SetSort "CN_QRY_Order", "MI_OrderSort_", "Popup_OrderSort_", checked
return

/*:VRX         SetProdSort
*/
SetProdSort: procedure expose Globals.
    parse arg menu    

    Menus.0 = 2
    Menus.1 = "Descript"
    Menus.2 = "Prodnum"

    menu = translate( menu )
    do i = 1 to Menus.0
        if( translate( Menus.i ) = menu ) then do
            checked = i
            leave
        end
    end
    
    call SetSort "CN_QRY_Product", "MI_ProductSort_", "Popup_ProductSort_", checked

return

/*:VRX         SetSort
*/
SetSort: procedure expose Globals. Menus.
    parse arg ctn, prefix, popup, checked

    call VRSet ctn, "Painting", 0 

    call ResetSource ctn

    if( \VRGet( prefix || Menus.checked, "Checked" ) ) then do    
        do i = 1 to Menus.0
            ok = VRSet( prefix || Menus.i, "Checked", 0 )
            ok = VRSet( popup || Menus.i, "Checked", 0 )
        end
        ok = VRSet( prefix || Menus.checked, "Checked", 1 )
        ok = VRSet( popup || Menus.checked, "Checked", 1 )
        ok = VRSet( ctn, "DetailSort", Menus.checked )
    end    
    ok = VRMethod( ctn, "SortRecords" )

    call VRSet ctn, "Painting", 1 

return

/*:VRX         SetViews
*/
/*  This function is responsible for the enabling and
    disabling of the menu items, when a user changes
    the view.
*/
SetViews: procedure expose Globals.
    parse arg group, view

    icon = "MI_"group"View_Icon"
    detail = "MI_"group"View_Detail"
    arrange = "MI_"group"View_Arrange"
    popupArrange = "Popup_"group"_Arrange"
    sort = "MI_"group"View_Sort"
    popupSort = "Popup_"group"_Sort"

    ok = VRSet( "CN_QRY_"group, "View", view )
    ok = VRMethod( "CN_QRY_"group, "SortRecords" )

    enabled = ( Translate( view ) \= "DETAIL" )
    ok = VRSet( icon, "Enabled", \enabled )
    ok = VRSet( arrange, "Enabled",  enabled )
    ok = VRSet( popupArrange, "Enabled",  enabled )
    ok = VRSet( sort, "Enabled",  \enabled )
    ok = VRSet( popupsort, "Enabled",  \enabled )
    ok = VRSet( detail, "Enabled", enabled )

    Globals.!View.group = view
return

/*:VRX         SW_Chart_Close
*/
SW_Chart_Close:procedure expose Globals.
    call SW_Chart_Fini
return

/*:VRX         SW_Chart_Create
*/
SW_Chart_Create:procedure expose Globals.
    call SW_Chart_Init
return

/*:VRX         SW_Chart_Fini
*/
SW_Chart_Fini:procedure expose Globals.
    call QRY_ProductSales_Fini
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return




/*:VRX         SW_Chart_Init
*/
SW_Chart_Init:procedure expose Globals.
    call QRY_ProductSales_Init
    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return





/*:VRX         SW_CustDetail_Close
*/
SW_CustDetail_Close: procedure expose Globals.
    call SW_CustDetail_Fini
return

/*:VRX         SW_CustDetail_Create
*/
SW_CustDetail_Create: procedure expose Globals.
    call SW_CustDetail_Init
return

/*:VRX         SW_CustDetail_Fini
*/
SW_CustDetail_Fini: procedure expose Globals.
    ok = VRMethod( "QRY_CustDetail", "Reset" )
    ok = VRMethod( "QRY_CustDetail", "Close" )
    window = VRInfo( "Window" )
    call ObjectClosed( window )
    call VRDestroy window
    drop window
return

/*:VRX         SW_CustDetail_Init
*/
SW_CustDetail_Init: procedure expose Globals.
    window = VRInfo( "Object" )
    
    data = VRGet( window, "UserData" )
    parse VAR data record "." custnum
    call QRY_CustDetail_Init custnum
    if( record = "NEW" ) then do
        ok = VRSet( "EF_QRY_CustDetail_custnum", "Value", custnum )
    end

    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return


/*:VRX         SW_CustDetail_Refresh
*/
SW_CustDetail_Refresh: procedure expose Globals.

return

/*:VRX         SW_Customer_Close
*/
SW_Customer_Close: procedure expose Globals.
    call SW_Customer_Fini
return

/*:VRX         SW_Customer_Create
*/
SW_Customer_Create: procedure expose Globals.
    call SW_Customer_Init
return

/*:VRX         SW_Customer_Fini
*/
SW_Customer_Fini: procedure expose Globals.
    window = VRInfo( "Window" )
    ok = VRSet( window, "Visible", 0 )
    call QRY_Customer_Fini
    call ObjectListClosed "CN_QRY_Customer"
    call ObjectClosed window 
    call VRDestroy window
    drop window
return


/*:VRX         SW_Customer_Init
*/
SW_Customer_Init: procedure expose Globals.
    call CN_QRY_Customer_Init
    call CN_QRY_Customer_Refresh
    group = "Customer"
    call SetViews group, Globals.!View.group
    call SetCustSort "Name"

    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return



/*:VRX         SW_Order_Close
*/
SW_Order_Close: procedure expose Globals.
    call SW_Order_Fini
return

/*:VRX         SW_Order_Create
*/
SW_Order_Create: procedure expose Globals.
    call SW_Order_Init
return

/*:VRX         SW_Order_Fini
*/
SW_Order_Fini: procedure expose Globals.
    window = VRInfo( "Window" )
    ok = VRSet( window, "Visible", 0 )
    call QRY_Order_Fini
    call ObjectListClosed "CN_QRY_Order"
    call ObjectClosed window
    call VRDestroy window
    drop window
return



/*:VRX         SW_Order_Init
*/
SW_Order_Init: procedure expose Globals.
    call CN_QRY_Order_Init
    call QRY_Order_Init
    call CN_QRY_Order_Refresh
    group = "Order"
    call SetViews group, Globals.!View.group
    call SetOrderSort "ordernum"

    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return




/*:VRX         SW_OrderDetail_Close
*/
SW_OrderDetail_Close:procedure expose Globals.
    call SW_OrderDetail_Fini
return

/*:VRX         SW_OrderDetail_Create
*/
SW_OrderDetail_Create:procedure expose Globals.
    call SW_OrderDetail_Init
return

/*:VRX         SW_OrderDetail_Fini
*/
SW_OrderDetail_Fini:procedure expose Globals.
    ok = VRMethod( "QRY_OrderItem", "Reset" )
    ok = VRMethod( "QRY_CustName", "Reset" )
    ok = VRMethod( "QRY_OrderDetail", "Reset" )
    ok = VRMethod( "QRY_OrderItem", "Close" )
    ok = VRMethod( "QRY_CustName", "Close" )
    ok = VRMethod( "QRY_OrderDetail", "Close" )
    window = VRInfo( "Window" )
    call ObjectListClosed "CN_QRY_OrderItem"
    call ObjectClosed window
    call VRDestroy window
    drop window
return









/*:VRX         SW_OrderDetail_Init
*/
SW_OrderDetail_Init:procedure expose Globals.
    window = VRInfo( "Object" )
    data = VRGet( window, "UserData" )
    parse VAR data record "." ordernum

    call FillDDCBList "QRY_CustNumList", "DDCB_QRY_OrderDetail_custnum"
    call QRY_OrderDetail_Init ordernum
    call CN_QRY_OrderItem_Init ordernum
    call QRY_CustName_Init

    if( record = "NEW" ) then do
        ok = VRSet( "EF_QRY_OrderDetail_ordernum", "Value", ordernum )
        date = INSERT( "-", DATE( "S" ), 4 )
        date = INSERT( "-", date, 7 )
        ok = VRSet( "EF_QRY_OrderDetail_order_date", "Value", date )
    end

    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return










/*:VRX         SW_OrderItem_Close
*/
SW_OrderItem_Close:procedure expose Globals.
    call SW_OrderItem_Fini
return

/*:VRX         SW_OrderItem_Create
*/
SW_OrderItem_Create:procedure expose Globals.
    call SW_OrderItem_Init
return

/*:VRX         SW_OrderItem_Fini
*/
SW_OrderItem_Fini:procedure expose Globals.
    call QRY_GetProdDesc_Fini
    window = VRInfo( "Window" )
    win = VRGet( window, "Parent" )
    record = VRGet( window, "UserData" )
    if( window = Globals.!__NewWin.OrderItem.win ) then do 
        ok = VRMethod( "CN_QRY_OrderItem", "RemoveRecord", record )
    end
    call ObjectClosed window
    call VRDestroy window
    drop window
return



/*:VRX         SW_OrderItem_Init
*/
SW_OrderItem_Init:procedure expose Globals.
    window = VRInfo( "Object" )
    record = VRGet( window, "UserData" )

    call FillDDCBList "QRY_ProdNumList", "DDCB_QRY_OrderItem_Prodnum"
 
    value = VRMethod( "CN_QRY_OrderItem", "GetFieldData", record, "values." )

    ok = VRSet( "DT_OrderNum", "Caption", values.!ordernum )
    ok = VRSet( "DT_item", "Caption",  values.!item )
    ok = VRSet( "DDCB_QRY_OrderItem_Prodnum", "Value", values.!prodnum )
    ok = VRFlush( "Change", "DDCB_QRY_OrderItem_Prodnum" )
    ok = VRSet( "EF_QRY_GetProdDesc_Description", "Value", values.!descript )
    ok = VRSet( "EF_QRY_OrderItem_price", "Value", values.!price )
    ok = VRFlush( "Change", "EF_QRY_OrderItem_price" )
    ok = VRSet( "EF_QRY_OrderItem_quantity", "Value", values.!quantity )
    ok = VRFlush( "Change", "EF_QRY_OrderItem_quantity" )
 
    call QRY_GetProdDesc_Init 0

    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return




/*:VRX         SW_ProdDetail_Close
*/
SW_ProdDetail_Close:procedure expose Globals.
    call SW_ProdDetail_Fini
return

/*:VRX         SW_ProdDetail_Create
*/
SW_ProdDetail_Create:procedure expose Globals.
    call SW_ProdDetail_Init
return

/*:VRX         SW_ProdDetail_Fini
*/
SW_ProdDetail_Fini:procedure expose Globals.
    ok = VRMethod( "QRY_ProdDetail", "Reset" )
    ok = VRMethod( "QRY_ProdDetail", "Close" )
    window = VRInfo( "Window" )
    call ObjectClosed window
    call VRDestroy window
    drop window
return


/*:VRX         SW_ProdDetail_Init
*/
SW_ProdDetail_Init:procedure expose Globals.
    window = VRInfo( "Object" )

    data = VRGet( window, "UserData" )
    parse VAR data record "." prodnum
    call QRY_ProdDetail_Init prodnum
    if( record = "NEW" ) then do
        ok = VRSet( "EF_QRY_ProdDetail_prodnum", "ReadOnly", 0 )
    end
    icon = VRGet( "EF_QRY_ProdDetail_Icon", "Value" )
    recordHandle = VRMethod( "CN_ProdDetail_Icon", "AddRecord", , "First", , Icon, ,  )
    ok = VRMethod( "CN_ProdDetail_Icon", "Arrange" )

    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return



/*:VRX         SW_Product_Close
*/
SW_Product_Close: procedure expose Globals.
    call SW_Product_Fini
return

/*:VRX         SW_Product_Create
*/
SW_Product_Create: procedure expose Globals.
    call SW_Product_Init
return

/*:VRX         SW_Product_Fini
*/
SW_Product_Fini: procedure expose Globals.
    window = VRInfo( "Window" )
    ok = VRSet( window, "Visible", 0 )
    call QRY_Product_Fini
    call ObjectListClosed "CN_QRY_Product"
    call ObjectClosed window 
    call VRDestroy window
    drop window
return


/*:VRX         SW_Product_Init
*/
SW_Product_Init: procedure expose Globals.
    call CN_QRY_Product_Init
    call CN_QRY_Product_Refresh

    group = "Product"
    call SetViews group, Globals.!View.group

    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return


