/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         EnableButtons
*/
EnableButtons:
    /* Enable the buttons only if there are available
       printers.
    */

    selected = VRGet( "Printers", "Selected" )
    enabled = ( selected \= 0 )

    call VRSet "PB_Print", "Enabled", enabled
    call VRSet "PrintSetup", "Enabled", selected
return

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* The product information is displayed as a mutli-line
       message dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 4
    message.1 = "Chart Print Sample"
    message.2 = ""
    message.3 = "This sample application shows how"
    message.4 = "to print a chart."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1
return

/*:VRX         PB_Cancel_Click
*/
PB_Cancel_Click:
    /* Destroy the print window
    */    

    call VRDestroy "WI_Print"
    call VRSet VRWindow(), "Enabled", 1
    call VRMethod VRWindow(), "Activate"
return

/*:VRX         PB_GoPrint_Click
*/
PB_GoPrint_Click:
    /* Create the print window
    */

    call VRSet "Window1", "Enabled", 0
    if( \VRIsValidObject( "WI_Print" ) )then do
        call VRLoadSecondary "WI_Print"
    end
    call VRMethod "WI_Print", "Activate"

    /*  Build the list of printers
    */
    call VRMethod "Application", "ListPrinters", "printer."
    do i = 1 to printer.0
        parse var printer.i queue ";" printer ";" driver
        call VRMethod "Printers", "AddString", queue ,, printer
        JobData.i = VRPrintJobDialog( VRWindow(), printer, "Default" )
    end
    
    /*  Select the first printer
    */
    call VRSet "Printers", "Selected", 1
return

/*:VRX         PB_Print_Click
*/
PB_Print_Click:
    /*  Get the printer name from the item data stored in the list
    */
    selection = VRGet( "Printers", "Selected" )
    printer = VRMethod( "Printers", "GetItemData", selection )

    ok = VRMethod( "WC_Chart", "PrintChart", printer,,
                   JobData.selection, "FitToMargins", ,
                    ".1", ".1", ".1", ".1", 0, 0 )
    call VRDestroy "WI_Print"
    call VRSet VRWindow(), "Enabled", 1
    call VRMethod VRWindow(), "Activate"
return

/*:VRX         Printers_Click
*/
Printers_Click:
    /* The buttons are enabled only when there is a selected
       printer.
    */

    call EnableButtons
return

/*:VRX         PrintSetup_Click
*/
PrintSetup_Click:
    /* The standard printer dialogs.
    */

    w = VRWindow()
    prt_idx = VRGet( "Printers", "Selected" )
    data = VRPrintJobDialog( w, printer, jobData.prt_idx )
    if( data \= "" ) then do
        JobData.prt_idx = data
    end
return

/*:VRX         Quit
*/
Quit:
    /* Close the application
    */
    
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         WI_Print_Close
*/
WI_Print_Close:
    /* Destroy the window
    */

    window = VRInfo( "Object" )
    call VRDestroy window
    drop window
return
/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

