/** Notesrd.cmd **/
/*********************************************/
/*                                           */
/* Command line syntax:                      */
/*                                           */
/* notesrd                                   */
/*                                           */
/*                                           */
/*********************************************/
'@echo off'
'@cls'
Say 'RexxVIM Message Read Demonstration Program'
Say 'for Lotus Notes'
Say

/* Unload the function upon error */
SIGNAL ON ERROR NAME done


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   Say 'Functions have been released.  Retry program.'
   signal done
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
rc = RxVIMInitialize()
if (rc > 0) then call vimerr


/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
rc = RxVIMOpenSession('','','',Session)
Say 'Opening the session'
if (RxVIMStatus(rc) = 'VIMSTS_PASS_REQUIRED') then do
   Say
   Say 'Enter your password -'
   parse pull user_pw .
   rc = RxVIMOpenSession('','',user_pw,Session)
   if (rc >0) then call vimerr
end  /* Do */


/* Open the default message container -- Inbox */
rc = RxVIMOpenMessageContainer(Session,'','Inbox')
Say 'Opening the message container'
if (rc > 0) then call vimerr


/* Display all messages in Inbox if they exist */

     /* Enumerate messages in container -- Inbox */
     pos = ''                           /* Start at the beginning of the container */
     skipcnt = 1                        /* Move forward through the container one at a time */
     mcount  = 1                        /* Retrieve 1 message for each call */
     filter  = 'VIMSEL_NO_FILTER'       /* No filter, return all messages in inbox */
     fdata   = ''                       /* No filter data */
     flags   = 'VIM_NO_FLAGS'           /* No enumeration flags, return all messages in inbox */
     more    = ''                       /* Set the value of more to nul */
     action  = 'N'                      /* Set the value of repeat loop indicator to N */

     AttrDesc.0 = 3                               /* Retrieve 3 attributes for each message */
     AttrDesc.1.Selector = 'VIMSEL_REF'           /* 1st attribute is the message reference number */
     AttrDesc.1.Buffer   = 'MsgRefNo'             /* store results in this stem variable */
     AttrDesc.2.Selector = 'VIMSEL_SUBJECT'       /* 2nd attribute is the message subject */
     AttrDesc.2.Buffer   = 'Subject'              /* store results in this stem variable */
     AttrDesc.3.Selector = 'VIMSEL_UNREAD_MAIL'   /* 3rd attribute is if unread */
     AttrDesc.3.Buffer   = 'Unread'               /* store results in this stem variable */

     do until TRANSLATE(SUBSTR(action,1,1)) = 'X'

          /* Continue retrieving message info until user enters N */

          rc = RxVIMEnumerateMessages(Inbox,'pos',skipcnt,'AttrDesc','mcount',filter,fdata,flags,'more')
          Say 'Retrieving messages from in-box'
          if (rc > 0) then call vimerr

          /* Display results */
         'cls'
          Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
          Say
          Say 'Message Read Demo'
          Say
          Say '--------------------------------------------------------'
          Say '    Message =' MsgRefNo.1
          Say '    Subject =' Subject.1
          Say '    Unread  =' Unread.1
          Say '--------------------------------------------------------'
          Say
          Say 'Select an action for this message'
          Say
          Say '   N - Display the next message'
          Say '   I - Display message items'
          Say '   A - Display message recipients'
          Say '   R - Read the first 60 characters of first message item'
          Say '   E - Extract the message to the EXTRACT.tst file'
          Say '   L - Display the message items for the extracted file'
          Say '   X - Exit demo now'
          Say
          Say 'Enter your selection below:'
          PULL action

          /* Process the selection entered.  X will fall through the select statement */
          select
             when TRANSLATE(SUBSTR(action,1,1)) = 'I' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Retrieve all of the items for this message */
                ipos      = ''
                icount   = 2
                imore    = ''
                ItemDesc = ''
                ifilter   = 'VIMSEL_NO_FILTER'
                ifdata    = ''

                rc = RxVIMEnumerateMessageItems(MsgHandle,'ipos',1,'icount','ItemDesc',,
                                                ifilter,ifdata,'imore')
                if (rc > 0) then call vimerr

                'cls'
                Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
                Say
                Say ' Message Information with Item Detail'
                Say '--------------------------------------------------------'
                Say '    Message =' MsgRefNo.1
                Say '    Subject =' Subject.1
                Say '    Unread  =' Unread.1
                Say '--------------------------------------------------------'

                loopcnt = 1
                do while (loopcnt <= icount)
                   /* Display each item descriptor entry */
                   Say '    Item Class  -' ItemDesc.loopcnt.CLASS
                   Say '    Item Type   -' ItemDesc.loopcnt.TYPE
                   Say '    Item Name   -' ItemDesc.loopcnt.NAME
                   Say '    Item Path   -' ItemDesc.loopcnt.PATH
                   Say '    Item Size   -' ItemDesc.loopcnt.SIZE
                   Say '    Item Ref No -' ItemDesc.loopcnt.REF
                   Say '--------------------------------------------------------'

                   loopcnt = loopcnt + 1
                end /* do */
                'pause'
                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'R' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Retrieve all of the items for this message */
                ipos      = ''
                icount    = 20
                imore     = ''
                ItemDesc  = ''
                ifilter   = 'VIMSEL_CLASS'        /* Filter on item class */
                ifdata    = 'VIMSEL_NOTE_PART'    /* Retrieve only text items */

                rc = RxVIMEnumerateMessageItems(MsgHandle,'ipos',1,'icount','ItemDesc',,
                                                ifilter,ifdata,'imore')
                if (rc > 0) then call vimerr 
                /* Retrieve the text for the first message item */
                tconvert          = 'VIM_TEXT'         /* Use text conversion   */
                tflags            = ''                 /* No conversion flags   */

                /* Open the first message item */
                rc = RxVIMOpenMessageItem(MsgHandle,ItemDesc.1.REF,tconvert,tflags,'ItemPtr')
                if (rc > 0) then call vimerr

                /* Read the text from the open message */
                BufDesc.Buffer    = 'ItemText'         /* Return buffer name    */
                BufDesc.Size      = 60                 /* Size of return buffer */

                rc = RxVIMReadMessageItem(ItemPtr,'BufDesc')

                'cls'
                Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
                Say
                Say ' Message Information with Item Detail'
                Say '--------------------------------------------------------'
                Say '    Message =' MsgRefNo.1
                Say '    Subject =' Subject.1
                Say '    Unread  =' Unread.1
                Say '--------------------------------------------------------'

                /* Display each item descriptor entry */
                Say '    Item Class  -' ItemDesc.1.CLASS
                Say '    Item Type   -' ItemDesc.1.TYPE
                Say '    Item Name   -' ItemDesc.1.NAME
                Say '    Item Path   -' ItemDesc.1.PATH
                Say '    Item Size   -' ItemDesc.1.SIZE
                Say '    Item Ref No -' ItemDesc.1.REF
                Say '--------------------------------------------------------'
                Say ' Message Contents for first item (max 60 characters) -'
                Say
                Say SUBSTR(ItemText,1,60)
                Say '--------------------------------------------------------'
                'pause'

                /* Close the message item */
                rc = RxVIMCloseMessageItem( ItemPtr )
                if (rc > 0) then call vimerr

                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'A' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Retrieve all of the items for this message */
                Receipt.0 = 1                               /* Retrieve 1 attributes for each recipient */
                Receipt.1.Selector = 'VIMSEL_NAME'          /* 1st attribute is the addressee */
                Receipt.1.Buffer   = 'SentTo'               /* store results in this stem variable */
                rtype   = 'VIMSEL_TO'
                rpos    = ''
                rcount  = 20
                rmore   = ''

                rc = RxVIMEnumerateMessageRecipients(MsgHandle,rtype,'rpos',1,'Receipt','rcount','rmore')
                if (rc > 0) then call vimerr

                'cls'
                Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
                Say
                Say ' Message Information with Item Detail'
                Say '--------------------------------------------------------'
                Say '    Message =' MsgRefNo.1
                Say '    Subject =' Subject.1
                Say '    Unread  =' Unread.1
                Say '--------------------------------------------------------'

                loopcnt = 1
                do while (loopcnt <= rcount)
                   /* Display each item descriptor entry */
                   Say '    Sent To  -' SentTo.loopcnt
                   Say '--------------------------------------------------------'

                   loopcnt = loopcnt + 1
                end /* do */
                'pause'
                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'E' then do
                /* Open message */
                rc = RxVIMOpenMessage(Inbox,MsgRefNo.1,'','MsgHandle')
                if (rc > 0) then call vimerr

                /* Extract the message to the file EXTRACT.tst */
                'erase extract.tst'
                rc = RxVIMExtractMessage(MsgHandle,'VIM_NO_FLAGS','extract.tst')
                if (rc > 0) then call vimerr

                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
             when TRANSLATE(SUBSTR(action,1,1)) = 'L' then do
                /* Open extracted message */
                rc = RxVIMOpenExtractedMessage(Session,'extract.tst','MsgHandle')
                if (rc > 0) then call vimerr

                /* Retrieve all of the items for this message */
                ipos      = ''
                icount   = 20
                imore    = ''
                ItemDesc = ''
                ifilter   = 'VIMSEL_NO_FILTER'
                ifdata    = ''

                rc = RxVIMEnumerateMessageItems(MsgHandle,'ipos',1,'icount','ItemDesc',,
                                                ifilter,ifdata,'imore')
                if (rc > 0) then call vimerr

                'cls'
                Say 'RexxVIM - (c) Innovative Business Technologies, Inc'
                Say
                Say ' Message Information with Item Detail'
                Say '--------------------------------------------------------'
                Say '    Extracted Message = EXTRACT.tst'
                Say '--------------------------------------------------------'

                loopcnt = 1
                do while (loopcnt <= icount)
                   /* Display each item descriptor entry */
                   Say '    Item Class  -' ItemDesc.loopcnt.CLASS
                   Say '    Item Type   -' ItemDesc.loopcnt.TYPE
                   Say '    Item Name   -' ItemDesc.loopcnt.NAME
                   Say '    Item Path   -' ItemDesc.loopcnt.PATH
                   Say '    Item Size   -' ItemDesc.loopcnt.SIZE
                   Say '    Item Ref No -' ItemDesc.loopcnt.REF
                   Say '--------------------------------------------------------'

                   loopcnt = loopcnt + 1
                end /* do */
                'pause'
                /* Close the message */
                rc = RxVIMCloseMessage(MsgHandle)
                if (rc > 0) then call vimerr
             end  /* Do */
          otherwise
          end  /* select */

          /* End the loop if no more messages to retrieve */
          if more = 'False' then do
             Say 'All messages have been retrieved'
             action = 'X'
          end  /* Do */

     end /* do */


/* Close the message container -- Inbox */
rc = RxVIMCloseMessageContainer(Inbox)
if (rc > 0) then call vimerr


/* Close the session with the postoffice */
rc = RxVIMCloseSession(Session)
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

erc = RxVIMStatusText(Session,rc,'Status')
Say
Say '|-Error Information ------------------------------------|'
Say '  Error Text -' status.1
Say
Say '  Ext Status -' status.2
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|-------------------------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
