/** Message.cmd **/
/******************************************/
/*                                        */
/* Command line syntax:                   */
/*                                        */
/* demo db_path user_password user_name   */
/*                                        */
/*                                        */
/******************************************/
ARG db_path user_pw user_name
'@echo off'
'@cls'
Say 'RexxVIM Message Demonstration Program'
Say


/* Prompt for the parameters if not passed on the */
/* command line                                   */
if LENGTH(STRIP(db_path)) = 0 then do
   Say 'Enter Postoffice Directory -'
   PARSE PULL db_path .
   Say
   Say 'Enter User Name -'
   PARSE PULL user_name
   Say 'Enter Password -'
   PARSE PULL user_pw
end  /* Do */


/* Load the RexxVIM extensions to Rexx */
rc = RxFuncAdd('RxVIMLoadFuncs', 'REXXVIM', 'RxVIMLoadFuncs')
if rc <> 0 then do
   Say
   Say 'RexxVIM failed to load, return code' rc
   Say
   return
end  /* Do */
call RxVIMLoadFuncs
Say 'Functions are now loaded'
Say


/* Initialize the VIM subsystem */
rc = RxVIMInitialize()
Say
Say '|-Call To Routine ---------------RC--|'
Say '  RxVIMInitialize -              ' rc
if (rc > 0) then call vimerr



/* Open a session with the postoffice using the parameters */
/* provided by the user                                    */
rc = RxVIMOpenSession(db_path,user_name,user_pw)
Say '  RxVIMOpenSession -             ' rc
if (rc > 0) then call vimerr


/* Create a new message of type VIM_MAIL */
rc = RxVIMCreateMessage('VIM_MAIL')
Say '  RxVIMCreateMessage -           ' rc
if (rc > 0) then call vimerr


/* Set the header text */
hdrtext = user_name"'s config.sys file"
rc = RxVIMSetMessageHeader('VIMSEL_SUBJECT', hdrtext)
Say '  RxVIMSetMessageHeader -        ' rc
if (rc > 0) then call vimerr


/* Set the priority to high */
rc = RxVIMSetMessageHeader('VIMSEL_PRIORITY', 'VIM_HIGH_PRIORITY')
Say '  RxVIMSetMessageHeader -        ' rc
if (rc > 0) then call vimerr


/* Set the recipient to the user that is logged on */
/* This will send the message back to ourselves    */
rc = RxVIMSetMessageRecipient('VIMSEL_TO','VIMSEL_ENTITY','','',,
                user_name,'','')
Say '  RxVIMSetMessageRecipient -     ' rc
if (rc > 0) then call vimerr


/* Add some text to the message */
itemtxt = 'This message was created using the VIM Toolkit for Rexx!!'
rc = RxVIMSetMessageItem('VIMSEL_NOTE_PART','VIM_TEXT','VIMSEL_NATIVE',,
         'Message Demo',itemtxt,'')
Say '  RxVIMSetMessageItem -          ' rc
if (rc > 0) then call vimerr


/* Add the config.sys as a file attachment in the message */
rc = RxVIMSetMessageItem('VIMSEL_ATTACH','VIM_TEXT','VIMSEL_NATIVE',,
         'config.sys','','c:\config.sys')
Say '  RxVIMSetMessageItem -          ' rc
if (rc > 0) then call vimerr


/* Send the message */
rc = RxVIMSendMessage()
Say '  RxVIMSendMessage -             ' rc
if (rc > 0) then call vimerr


/* Close the session with the postoffice */
rc = RxVIMCloseSession()
Say '  RxVIMCloseSession -            ' rc
if (rc > 0) then call vimerr


/* Terminate the active VIM subsystem connection */
rc = RxVIMTerminate()
Say '  RxVIMTerminate -               ' rc
if (rc > 0) then call vimerr
signal done


/***** VIMErr *******/

/* If an error occurs, this function will return the text */
/* associated with the error.  Extended text may be       */
/* displayed if it exists for the specified error.        */

VIMERR:

rc = RxVIMStatusText(rc,'Status')
Say
Say '|-Error Information -----------------|'
Say '  Error Text -' status.1
Say
Say '  Ext Status -' status.2
rc = RxVIMTerminate()
signal done


/* The done section will unload the RexxVIM extensions */
/* and exit the program                                */
DONE:
/*** Drop all of the external functions ***/
call RxVIMDropFuncs
Say '|------------------------------------|'
Say 'Demo Complete.  All functions released'
'pause'
exit
