/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import netrexx.lang.BadNumericException;
import netrexx.lang.Rexx;

public final class RexxSet {
    private static final Rexx $01 = new Rexx('1');
    private static final String $0 = "RexxSet.nrx";
    public static final byte SCIENTIFIC = 0;
    public static final byte ENGINEERING = 1;
    public static final byte PLAIN = 2;
    public static final byte DEFAULT_FORM = 0;
    public static final int DEFAULT_DIGITS = 9;
    public int digits = 9;
    public byte form = 0;

    public RexxSet() {
    }

    public RexxSet(int n) {
        this();
        this.digits = n;
    }

    public RexxSet(int n, byte by) {
        this();
        this.digits = n;
        this.form = by;
    }

    public RexxSet(RexxSet rexxSet) {
        this();
        this.digits = rexxSet.digits;
        this.form = rexxSet.form;
    }

    public Rexx formword() {
        if (this.form == 0) {
            return Rexx.toRexx("scientific");
        }
        return Rexx.toRexx("engineering");
    }

    public void setDigits(Rexx rexx) {
        Rexx rexx2 = rexx.OpPlus(this);
        if (rexx2.ind == 1 && rexx2.datatype(new Rexx('w')).OpEqS(null, $01) && rexx2.mant.length + rexx2.exp <= 9) {
            this.digits = rexx2.toint();
            return;
        }
        throw new BadNumericException(Rexx.toString(rexx));
    }

    public void setForm(Rexx rexx) {
        if (rexx.OpEq(null, Rexx.toRexx("engineering"))) {
            this.form = 1;
        } else if (rexx.OpEq(null, Rexx.toRexx("scientific"))) {
            this.form = 0;
        } else {
            throw new BadNumericException(Rexx.toString(rexx));
        }
    }
}

