/* REXX *********************************************/
/*                                                  */
/* Program name: SAVEPRE                            */
/* Function    : Save current installation - an     */
/*               example for the pre-install exit   */
/*                                                  */
/* Syntax      : Call from the INSTALL.DAT via:     */
/*    START_REXX_BY_START_INSTALL=SAVEPRE dest_path */
/*                                                  */
/* Changes     :                                    */
/*                                                  */
/* Made use of GREED.  21 May 1996 / 19:50:29   JRK */
/****************************************************/
Parse Arg destPath
/*-------------(Write lines into file)--------------*/
filename    = destPath'\install.log'
rc = LineOut( filename, 'Destination Directory:' destPath)

/*==============(Exception handling)================*/
Signal On Failure Name CLEARUP
Signal On Halt    Name CLEARUP
Signal On Syntax  Name CLEARUP

Call On NOTREADY

/*==========(Initialize RexxUtil support)===========*/
If RxFuncQuery('SysLoadFuncs') Then Do
  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs
End /* If RxFuncQuery... */

"ATTRIB -r -h -s *.*>>NUL"
/* delRC = SysFileDelete( destPath'\greed.ini' ) */
/*--------------(Save directory)---------------*/
directory = destPath||'\DfltFNCs'
rc = SysMkDir( directory )
/*--------------(Make directory)---------------*/
directory = destPath||'\SAVEPREV'
rc = LineOut( filename, 'Save Directory:' directory )
rc = SysMkDir( directory )
if rc = 0 | rc = 5 then do
  ret = LineOut( filename, 'Make Save Directory RC='rc )
  rc = LineOut( filename, "Save" destPath||"\*.*" directory"\" )
  rc = SysFileTree( destPath||"\*.*", fileList, 'FO', '**---' )
  /*-------------(Delete an application)--------------*/
  /* appl    = 'RACF Callable Services' */       /* Application name */
  /* result = SysIni( destPath||"\TSOISPF.FNC", appl, 'DELETE:' ) */ 
  /* appl    = 'User' */                         /* Application name */
  /* result = SysIni( destPath||"\TSOISPF.FNC", appl, 'DELETE:' ) */
  Do i = 1 To fileList.0
    name  = FileSpec( "Name", fileList.i )  /* FILENAME.EXT */
    If Translate(name) \= 'INSTALL.LOG' Then Do
      delFile = directory'\'name
      rc = SysDestroyObject( delFile )
      rc = SysCopyObject( fileList.i, directory )
    End
  End
  rc = LineOut( filename, 'Save Previous Installation RC='rc )
End
Else ret = LineOut( filename, 'Make Save Directory RC='rc )
/*----------(Set command for file system)-----------*/
status = Stream( filename, 'C', 'Close' )

/*================(End this program)================*/
Exit

CLEARUP:
NOTREADY:
  rc = LineOut( filename, 'Signal on error in the SavePrev exit' )
Exit
