/* WPS Enhanced ERexxTry */
SIGNAL ON SYNTAX NAME RESTART
CALL CHAROUT ,D2C(27)"[44m"D2C(27)"[2J"
CALL SQLDBS "START DATABASE MANAGER"
RESTART:
PARSE SOURCE SOURCE
PARSE SOURCE SYSRX . PROCRX
REMINDRX="Enter 'exit' to end."
HELPRX="      Or '?' for online REXX help."
PROCRX=SUBSTR(PROCRX,LASTPOS("\",PROCRX)+1)
BORDRX=RIGHT(" "PROCRX" on "SYSRX,68,".")
SAY "  "procrx" lets you interactively try REXX statements."
SAY "    Each string is executed when you hit Enter."
SAY "      Enter 'call tell' for a description of the features."
SAY "  Go on - try a few...             "remindrx
MAIN:
SIGNAL ON SYNTAX
SIGNAL ON HALT NAME MAIN
!_!_!_!_!FLAG!_!_!_!_!="In main SQLREXX"
CALL CHAROUT ,D2C(27)"[44m"
DO FOREVER
	PARSE VERSION _VER
	SAY "  --- Current REXX interpreter is: "_VER
	SAY "  --- extended keys are active, F1 = online help ---"
	INPUTRX=CMDLINE()
	SELECT
		WHEN INPUTRX="" THEN SAY "  "PROCRX":  "REMINDRX HELPRX
		WHEN INPUTRX="?" THEN "VIEW REXX.INF"
		WHEN TRANSLATE(WORD(INPUTRX,1))="SQL" THEN CALL SQLEXEC SUBWORD(INPUTRX,2)
		OTHERWISE
			RC="X"
			INTERPRET INPUTRX
			CALL TRACE "O"
			CALL BORDER
	END
END

BORDER:
IF RC="X" THEN SAY "  "BORDRX
ELSE SAY "  "OVERLAY("rc = "RC" ",BORDRX)
RETURN

SYNTAX:
CALL TRACE "O"
IF !_!_!_!_!FLAG!_!_!_!_!="!_!_!_!_!FLAG!_!_!_!_!" THEN RETURN "Error "RC
SAY "  Oooops ! ... try again.     "ERRORTEXT(RC)
CALL BORDER
SIGNAL MAIN

/* Start of CMDLine code (originally by Albert Crosby, tidied up by Chris Esstu) */
CMDLINE: PROCEDURE EXPOSE !HISTORY.
SIGNAL ON SYNTAX NAME CMDLINEERROR
PARSE VALUE SYSCURPOS() WITH X Y
IF SYMBOL("!HISTORY.INSERT")="LIT" THEN !HISTORY.INSERT=1
IF SYMBOL("!HISTORY.0")="LIT" THEN !HISTORY.0=0
HISTORICAL=-1
WORD=""
POS=0
SIGNAL ON HALT NAME KEEPGOING
KEEPGOING:
DO FOREVER
	KEY=SYSGETKEY("NOECHO")
	SELECT
		WHEN KEY="0D"x THEN LEAVE
		WHEN KEY="08"x THEN IF POS>0 THEN DO
			WORD=DELSTR(WORD,POS,1)
			CALL RUBOUT 1
			POS=POS-1
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)" "COPIES("08"x,LENGTH(WORD)-POS+1)
		END
		WHEN KEY="1B"x THEN DO
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
			CALL RUBOUT LENGTH(WORD)
			WORD=""
			POS=0
		END
		WHEN KEY="0A"x THEN NOP /* Ctrl-Enter ignored */
		WHEN KEY="09"x THEN NOP /* Tab ignored */
		WHEN (KEY="E0"x)|(KEY="00"x) THEN DO
			KEY=SYSGETKEY("NOECHO")
			SELECT
				WHEN KEY="<" THEN DO /* F2 */
					SAY
					SAY "Enter file/device name to dump history to:"
					PARSE PULL FILE
					DO I=1 TO !HISTORY.0
						CALL LINEOUT FILE,!HISTORY.I
					END
					CALL LINEOUT FILE
					SAY
					WORD=""
					LEAVE
				END
				WHEN KEY="U" THEN DO /* Shift-F2 */
					WORD="'E' WORD(SOURCE,3)"
					LEAVE
				END
				WHEN (KEY="k")|(KEY="=") THEN DO /* Alt-F4, F3 */
					WORD="EXIT"
					LEAVE
				END
				WHEN KEY="H" THEN IF !HISTORY.0>0 THEN DO
					IF ABS(HISTORICAL)=1 THEN HISTORICAL=!HISTORY.0
					ELSE HISTORICAL=HISTORICAL-1
					IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
					CALL RUBOUT LENGTH(WORD)
					WORD=!HISTORY.HISTORICAL
					POS=LENGTH(WORD)
					CALL CHAROUT ,WORD
				END
				WHEN KEY="P" THEN IF !HISTORY.0>0 THEN DO
					IF (HISTORICAL=-1)|(HISTORICAL=!HISTORY.0) THEN HISTORICAL=1
					ELSE HISTORICAL=HISTORICAL+1
					IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
					CALL RUBOUT LENGTH(WORD)
					WORD=!HISTORY.HISTORICAL
					POS=LENGTH(WORD)
					CALL CHAROUT ,WORD
				END
				WHEN KEY="K" THEN IF POS>0 THEN DO
					CALL CHAROUT ,D2C(8)
					POS=POS-1
				END
				WHEN KEY="M" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,SUBSTR(WORD,POS+1,1)
					POS=POS+1
				END
				WHEN KEY="s" THEN IF POS>0 THEN DO
					NEWPOS=LASTPOS(" ",WORD,POS)
					IF NEWPOS=POS THEN NEWPOS=LASTPOS(" ",WORD,POS-1)
					CALL CHAROUT ,COPIES("08"x,POS-NEWPOS)
					POS=NEWPOS
				END
				WHEN KEY="t" THEN IF POS<LENGTH(WORD) THEN DO
					NEWPOS=POS(" ",WORD,MAX(POS,1))
					IF NEWPOS=POS THEN NEWPOS=POS(" ",WORD,POS+1)
					IF NEWPOS=0 THEN NEWPOS=LENGTH(WORD)
					CALL CHAROUT ,SUBSTR(WORD,POS+1,NEWPOS-POS)
					POS=NEWPOS
				END
				WHEN KEY="S" THEN IF POS<LENGTH(WORD) THEN DO
					WORD=DELSTR(WORD,POS+1,1)
					CALL CHAROUT ,SUBSTR(WORD,POS+1)" "
					CALL CHAROUT ,COPIES("08"x,LENGTH(WORD)-POS+1)
				END
				WHEN KEY="R" THEN !HISTORY.INSERT=\!HISTORY.INSERT
				WHEN KEY="O" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,SUBSTR(WORD,POS+1)
					POS=LENGTH(WORD)
				END
				WHEN KEY="G" THEN IF POS>0 THEN DO
					CALL CHAROUT ,COPIES("08"x,POS)
					POS=0
				END
				WHEN KEY="u" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,COPIES(" ",LENGTH(WORD)-POS)COPIES("08"x,LENGTH(WORD)-POS)
					WORD=LEFT(WORD,POS)
				END
				WHEN KEY="w" THEN IF POS>0 THEN DO
					IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
					CALL RUBOUT LENGTH(WORD)
					WORD=SUBSTR(WORD,POS+1)
					CALL CHAROUT ,WORD||COPIES("08"x,LENGTH(WORD))
					POS=0
				END
				OTHERWISE NOP
			END
		END
		OTHERWISE
			CALL CHAROUT ,KEY
			IF !HISTORY.INSERT THEN WORD=INSERT(KEY,WORD,POS); ELSE WORD=OVERLAY(KEY,WORD,POS+1)
			POS=POS+1
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)COPIES("08"x,LENGTH(WORD)-POS)
	END
END
SAY SUBSTR(WORD,POS+1)
IF WORD\="" THEN DO
	I=!HISTORY.0
	IF WORD\=!HISTORY.I THEN DO
		!HISTORY.0=!HISTORY.0+1
		I=!HISTORY.0
		!HISTORY.I=WORD
	END
END
CMDLINEERROR:
RETURN WORD

RUBOUT:
DO !I=1 TO ARG(1)
	CALL CHAROUT ,"082008"x
END
RETURN
/* End CMDLine code */

ERRMSG: PROCEDURE /* FUNCTION: Gets information on a REXX error message. */
/*
For information on REX0123:
Parameters: 123
Returns: Help on REX123

Optional 2nd parameter: message file name. Default=REX; others may include OSO001 (SYS messages), NET (LAN messages, eg NET0272), etc.
*/
PARSE ARG N,F
IF F="" THEN F="REX"
RETURN SYSGETMESSAGE(N,F".MSG","***","***","***","***","***","***","***","***","***")SYSGETMESSAGE(N,F"H.MSG","***","***","***","***","***","***","***","***","***")

ABSOBJ: PROCEDURE
PARSE ARG OBJ,OPT
IF POS("\",OBJ)=0 THEN OBJ=DIRECTORY()"\"OBJ
DIR=LEFT(OBJ,LASTPOS("\",OBJ)-1)
TIT=TRANSLATE(SUBSTR(OBJ,LASTPOS("\",OBJ)+1)) /* Case insensitive search */
CALL WPTOOLSFOLDERCONTENT DIR,"STEM"
IF STEM.0="STEM.0" THEN RETURN ""
DO I=1 TO STEM.0
	CALL WPTOOLSQUERYOBJECT STEM.I,"CLASS","TITLE","SETUP","LOCATION"
	IF TRANSLATE(TITLE)=TIT THEN RET=RET STEM.I
END
RETURN SUBWORD(RET,2)

OBJDATA: PROCEDURE /* FUNCTION: Gets/sets object data. */
/*
Two forms.

Form 1 - Get data
Parameters: object
Returns: setup

Form 2 - Set data
Parameters: object, setup
Returns: Return value from WPToolsSetObjectData

Parameter meanings:
object: objectid, filename, or WPTools #nnnnn id
setup: WinSetObjectData setup string for object
*/
SELECT
	WHEN ARG()=1 THEN DO; RET=""; CALL WPTOOLSQUERYOBJECT ARG(1),,,"RET"; RETURN RET; END
	WHEN ARG()=2 THEN RETURN WPTOOLSSETOBJECTDATA(ARG(1),ARG(2))
OTHERWISE RETURN "Invalid number of arguments."
END

PIPE_WRITE: PROCEDURE /* FUNCTION: Write to a closed Named Pipe */
/*
Parameters:
PIPE,MESSAGE
where PIPE is the pipe name (\PIPE\pipename or \\server\PIPE\pipename)
and MESSAGE is the message to be sent
Returns 0 if successful, or error code if not
*/
PARSE ARG PIPE,MESSAGE
CALL NMPIPE_OPEN PIPE
IF RESULT\=0 THEN RETURN RESULT
ERR=NMPIPE_WRITE(PIPE,MESSAGE)
CALL NMPIPE_CLOSE PIPE
IF ERR=0 THEN RETURN RESULT
RETURN ERR

SETDATA: PROCEDURE /* FUNCTION: Call SysSetObjectData for a directory and all its subdirs */
/*
Parameters: DIR,SETUP
Returns: 1 if directory has subdirs, 0 if not
*/
PARSE ARG DIR,SETUP
CALL SYSSETOBJECTDATA DIR,SETUP
CALL SYSFILETREE DIR"\*","STEM","DOS" /* Third arg: D=Directories only, O=Only names, S=subdirs */
DO I=1 TO STEM.0
	CALL SYSSETOBJECTDATA STEM.I,SETUP
END
RETURN STEM.0>0

EXECPM: PROCEDURE /* FUNCTION: Execute a statement in a PM session */
/*
Parameters:
statement
Returns:
RC from RxStartSession
*/
RETURN RXSTARTSESSION("CMD.EXE","/C REXXTRY.CMD "ARG(1),"I","F","PM REXXTry","P","I")

SORT:
RETURN SETDATA(ARG(1),"ALWAYSSORT=YES")

