(********************************************************************************************
** PROGRAM     : lines
** VERSION     : 1.0.0
** DESCRIPTION : Counts the number of lines in one or more text files.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and was written to provide
** an example of how to manipulates files and directories. To make best use of this sample
** you should have a basic understanding of Pascal.
**********************************************************************************************)
program lines(output);
var
   pc : integer;
   TotalFiles, TotalLines : integer;

   procedure syntax;
   begin //syntax
      writeln('Lines - Counts the number of lines in the files specified');
      writeln('Syntax: ivm lines filespec1, ... filespecN');
      writeln('        The wildcards ''?'' and ''*'' may be used');
      writeln('For example:');
      writeln('        ivm lines *.pas *.txt');
      writeln('  Counts the number of lines in all files with extensions');
      writeln('  .pas or .txt in the current directory');
      halt
   end;  //syntax

   procedure WriteString(var f : text; s : string; width : integer);
   var
      i : integer;
   begin //WriteString
      write(f, s);
      for i := 1 to width - length(s) do
         write(f, ' ')
   end;  //WriteString

   procedure CountLines(f : filename);
   var
      NumFiles, NumLines : integer;
      DirPart, NamePart, ExtPart : filename;
      fname : filename;
      d : Dir;

      function DoCount(name : filename) : integer;
      var
         count : integer;
         f : text;
      begin //DoCount
         count := 0;
         assign(f, name);
         reset(f);
         while not eof(f) do
            begin
               readln(f);
               inc(count);
            end;
         DoCount := count;
         close(f)
      end;  //DoCount

   begin //CountLines
      NumFiles := 0;
      NumLines := 0;
      f := fexpand(f);
      writeln(f);
      fsplit(f, DirPart, NamePart, ExtPart);
      NamePart := NamePart + ExtPart;
      OpenDir(d, DirPart);
      repeat
         ReadDir(d, fname);
         if fname <> '' then
            begin
               if FileMatch(NamePart, fname) then
                  begin
                     inc(NumFiles);
                     NumLines := DoCount(DirPart+fname);
                     WriteString(output, fname, 16);
                     writeln(NumLines);
                     inc(TotalLines, NumLines)
                  end
            end
      until fname = '';
      CloseDir(d);
      inc(TotalFiles, NumFiles);
   end;  //CountLines

begin
   if paramcount < 1 then
      syntax;
   TotalFiles := 0;
   TotalLines := 0;
   for pc := 1 to paramcount do
       CountLines(paramstr(pc));
   writeln('--------------------------');
   writeln('Total Files = ', TotalFiles:10);
   writeln('Total Lines = ', TotalLines:10)
end.
