(********************************************************************************************
** PROGRAM     : cgiinfo
** VERSION     : 1.0.0
** DESCRIPTION : Displays commonly used CGI environment variables.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2002. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and is an example of how to
** write CGI programs using Irie Pascal. To make best use of this sample you should have
** a basic understanding of Pascal as well as a basic understanding of the
** Common Gateway Interface (CGI).
**********************************************************************************************)
program info(output);

	procedure WriteResponseHeader;
	begin (* WriteResponseHeader *)
		writeln('content-type: text/html');
		writeln
	end; (* WriteResponseHeader *)

	procedure WriteHTMLHeader;
	begin (* WriteHTMLHeader *)
		writeln('Content-type: text/html');
		writeln;
		writeln('<html>');
		writeln('<head>');
		writeln('<title>Irie Pascal sample CGI application</title>');
		writeln('<h1>This program displays the contents of all CGI environment variables.</h1>');
		writeln('</head>')
	end; (* WriteHTMLHeader *)

	procedure WriteHTMLBody;

		procedure DisplayEnvVar(name : string);
		var
			value : string;
		begin (* DisplayEnvVar *)
			value := getenv(name);
			writeln(name, ' = ', value, '<br>')
		end; (* DisplayEnvVar *)

	begin (* WriteHTMLBody *)
		writeln('<body>');

		DisplayEnvVar('HTTP_ACCEPT');
		DisplayEnvVar('HTTP_ACCEPT_ENCODING');
		DisplayEnvVar('HTTP_ACCEPT_LANGUAGE');
		DisplayEnvVar('HTTP_AUTHORIZATION');
		DisplayEnvVar('HTTP_CHARGE_TO');
		DisplayEnvVar('HTTP_FROM');
		DisplayEnvVar('HTTP_IF_MODIFIED_SINCE');
		DisplayEnvVar('HTTP_PRAGMA');
		DisplayEnvVar('HTTP_REFERER');
		DisplayEnvVar('HTTP_USER_AGENT');

		writeln('<hr>');

		DisplayEnvVar('AUTH_TYPE');
		DisplayEnvVar('CONTENT_LENGTH');
		DisplayEnvVar('CONTENT_TYPE');
		DisplayEnvVar('GATEWAY_INTERFACE');
		DisplayEnvVar('PATH_INFO');
		DisplayEnvVar('PATH_TRANSLATED');
		DisplayEnvVar('QUERY_STRING');
		DisplayEnvVar('REMOTE_ADDR');
		DisplayEnvVar('REMOTE_HOST');
		DisplayEnvVar('REMOTE_IDENT');
		DisplayEnvVar('REMOTE_USER');
		DisplayEnvVar('REQUEST_METHOD');
		DisplayEnvVar('SCRIPT_NAME');
		DisplayEnvVar('SERVER_NAME');
		DisplayEnvVar('SERVER_PORT');
		DisplayEnvVar('SERVER_PROTOCOL');
		DisplayEnvVar('SERVER_SOFTWARE');

		writeln('</body>')
	end; (* WriteHTMLBody *)

	procedure WriteHTMLFooter;
	begin (* WriteHTMLFooter *)
		writeln('</html>')
	end; (* WriteHTMLFooter *)

begin
	WriteResponseHeader;
	WriteHTMLHeader;
	WriteHTMLBody;
	WriteHTMLFooter
end.
