//FILE: SHELLAPI.INC
//VERSION: 1.0

(*$W44- *)
(*$W53- *)

(*$I winreg.inc *)

const
    FO_MOVE = $0001;
    FO_COPY = $0002;
    FO_DELETE = $0003;
    FO_RENAME = $0004;
    FOF_MULTIDESTFILES = $0001;
    FOF_CONFIRMMOUSE = $0002;
    FOF_SILENT = $0004;
    FOF_RENAMEONCOLLISION = $0008;
    FOF_NOCONFIRMATION = $0010;
    FOF_WANTMAPPINGHANDLE = $0020;
    FOF_ALLOWUNDO = $0040;
    FOF_FILESONLY = $0080;
    FOF_SIMPLEPROGRESS = $0100;
    FOF_NOCONFIRMMKDIR = $0200;
    FOF_NOERRORUI = $0400;

    PO_DELETE = $0013;
    PO_RENAME = $0014;
    PO_PORTCHANGE = $0020;
    PO_REN_PORT = $0034;

    SE_ERR_FNF = 2;
    SE_ERR_PNF = 3;
    SE_ERR_ACCESSDENIED = 5;
    SE_ERR_OOM = 8;
    SE_ERR_DLLNOTFOUND = 32;
    SE_ERR_SHARE = 26;
    SE_ERR_ASSOCINCOMPLETE = 27;
    SE_ERR_DDETIMEOUT = 28;
    SE_ERR_DDEFAIL = 29;
    SE_ERR_DDEBUSY = 30;
    SE_ERR_NOASSOC = 31;
    SEE_MASK_CLASSNAME = $00000001;
    SEE_MASK_CLASSKEY = $00000003;
    SEE_MASK_IDLIST = $00000004;
    SEE_MASK_INVOKEIDLIST = $0000000c;
    SEE_MASK_ICON = $00000010;
    SEE_MASK_HOTKEY = $00000020;
    SEE_MASK_NOCLOSEPROCESS = $00000040;
    SEE_MASK_CONNECTNETDRV = $00000080;
    SEE_MASK_FLAG_DDEWAIT = $00000100;
    SEE_MASK_DOENVSUBST = $00000200;
    SEE_MASK_FLAG_NO_UI = $00000400;
    SEE_MASK_UNICODE = $00004000;
    SEE_MASK_NO_CONSOLE = $00008000;
    SEE_MASK_ASYNCOK = $00100000;

    SHGFI_ICON = $000000100;
    SHGFI_DISPLAYNAME = $000000200;
    SHGFI_TYPENAME = $000000400;
    SHGFI_ATTRIBUTES = $000000800;
    SHGFI_ICONLOCATION = $000001000;
    SHGFI_EXETYPE = $000002000;
    SHGFI_SYSICONINDEX = $000004000;
    SHGFI_LINKOVERLAY = $000008000;
    SHGFI_SELECTED = $000010000;
    SHGFI_LARGEICON = $000000000;
    SHGFI_SMALLICON = $000000001;
    SHGFI_OPENICON = $000000002;
    SHGFI_SHELLICONSIZE = $000000004;
    SHGFI_PIDL = $000000008;
    SHGFI_USEFILEATTRIBUTES = $000000010;

    SHGNLI_PIDL = $000000001;
    SHGNLI_PREFIXNAME = $000000002;
    SHGNLI_NOUNIQUE = $000000004;

type
	FILEOP_FLAGS = shortword;

	SHFILEOPSTRUCT = record
		hwnd : _HWND;
		wFunc : UINT;
		pFrom : address;
		pTo : address;
		fFlags : FILEOP_FLAGS;
		fAnyOperationsAborted : BOOL;
		hNameMappings : address;
		plszProgressTitle : address;
	end;

	SHNAMEMAPPING = record
		pszOldPath : address;
		pszNewPath : address;
		cchOldPath : integer;
		cchNewPath : integer;
	end;

	SHELLEXECUTEINFO = record
        cbSize : DWORD;
        fMask : ULONG;
        hwnd : _HWND;
        lpVerb : address;
        lpFile : address;
        lpParameters : address;
        lpDirectory : address;
        nShow : integer;
        hInstApp : HINSTANCE;
        // Optional fields
        lpIDList : LPVOID;
        lpClass : address;
        hkeyClass : HKEY;
        dwHotKey : DWORD;
        hIcon : HANDLE;
        hProcess : HANDLE;
	end;

	SHFILEINFO = record
        hIcon : _HICON;
        iIcon : integer;
        dwAttributes : DWORD;
        szDisplayName : cstring[MAX_CSTRING_PATH];
        szTypeName : cstring[79];
    end;

    function ShellExecute(hwnd : _HWND; lpOperation, lpFile, lpParameters, lpDirectory : address; nShowCmd : integer) : HINSTANCE;
    	external dll='shell32.dll' name='ShellExecuteA' stdcall;

	function CommandLineToArgvW(lpCmdLine : address; var NumArgs : integer) : address;
    	external dll='shell32.dll' stdcall;

	function ShellAbout(hwnd : _HWND; szApp, szOtherStuff : address; hIcon : _HICON) : integer;
    	external dll='shell32.dll' name='ShellAboutA' stdcall;

	function ExtractAssociatedIcon(hInst : HINSTANCE; lpIconPath : address; var lpiIcon : shortword) : HICON;
    	external dll='shell32.dll' name='ExtractAssociatedIconA' stdcall;

	function ExtractIcon(hInst : HINSTANCE; lpszExecFileName : address; nIconIndex : UINT) : HICON;
    	external dll='shell32.dll' name='ExtractIconA' stdcall;

	function ExtractIconEx(lpszFile : address; nIconIndex : integer; var phiconLarge, phiconSmall : HICON; nIcons : UINT) : UINT;
    	external dll='shell32.dll' name='ExtractIconExA' stdcall;

	function SHFileOperation(var plFileOp : SHFILEOPSTRUCT) : integer;
    	external dll='shell32.dll' name='SHFileOperationA' stdcall;

	procedure SHFreeNameMappings(hNameMappings : HANDLE);
    	external dll='shell32.dll' stdcall;

	function ShellExecuteEx(var lpExecInfo : SHELLEXECUTEINFO) : BOOL;
    	external dll='shell32.dll' name='ShellExecuteExA' stdcall;

	function SHGetFileInfo(pszPath : address; dwFileAttributes : DWORD; var psfi : SHFILEINFO; cbFileInfo, uFlags : UINT) : DWORD;
    	external dll='shell32.dll' name='SHGetFileInfoA' stdcall;

(*$W53. *)
(*$W44. *)
