implementation module StdOverloaded

// ****************************************************************************************
//	Concurrent Clean Standard Library Module Version 1.1
//	Copyright 1995 University of Nijmegen
// ****************************************************************************************

class (+)  infixl 6	a	:: !a	!a	->	a				//	Add arg1 to arg2
class (-)  infixl 6	a	:: !a	!a	->	a 				//	Subtract arg2 from arg1
class zero 			a	:: a							//	Zero (unit element for addition)

class (*)  infixl 7	a	:: !a	!a	->	a				//	Multiply arg1 with arg2
class (/)  infix  7	a	:: !a	!a	->	a				//	Divide arg1 by arg2
class one 			a	:: a							//	One (unit element for multiplication)

class (^)  infixr 8	a	:: !a	!a 	->	a				//	arg1 to the power of arg2
class inc 			a	:: !a 		->	a 				//	Increment with 1
class dec  			a	:: !a 		->	a 				//	Decrement with 1
class abs  			a	:: !a		->	a				//	Absolute value
class sign 			a	:: !a 		->	Int				//	1 (pos value) -1 (neg value) 0 (if zero)
class ~				a	:: !a 		->	a				//	-a1

class (==) infix  2	a	:: !a	!a	->	Bool			//	True if arg1 is equal to arg2

class (<)  infix  2	a	:: !a	!a	->	Bool	 		//	True if arg1 is less than arg2

class toInt			a	:: !a		->	Int				//	Convert into Int
class toChar			a	:: !a		->	Char			//	Convert into Char
class toBool			a	:: !a		->	Bool			//	Convert into Bool
class toReal			a	:: !a		->	Real			//	Convert into Real
class toString		a	:: !a		->	{#Char}			//	Convert into String

class fromInt		a	:: !Int		-> a				//	Convert from Int
class fromChar		a	:: !Char	-> a				//	Convert from Char
class fromBool		a	:: !Bool	-> a				//	Convert from Bool
class fromReal		a	:: !Real	-> a				//	Convert from Real
class fromString		a	:: !{#Char}	-> a				//	Convert from String

class  length  		  	m	:: !(m a) -> Int			//	Number of elements in arg
														//		used for list like structures (linear time)

class  (%)  infixl 9	a	:: !a !(!Int,!Int)	-> a		//	Slice a part from arg1

class (+++) infixr 5	a 	:: !a	!a			-> a		//	Append args
