implementation module EdEditMenu;

/*	The commands of the Edit menu */

import	StdClass;
import StdInt, StdBool, StdString, StdMisc, StdArray;
import deltaEventIO, deltaMenu, deltaWindow, deltaTimer, deltaDialog, deltaControls;

import EdProgramState, EdWindows, EdDialogs, EdDraw, EdSupport, EdKeyboard, EdSearchMenu;

    

//
//	Device function for the Undo command
//

Undo :: Editor IO -> EdIO;
Undo editor io
	| not_removed && not_added && clip =  FinishUndo editor3 io;
	| not_removed && not_added =  (editor1,io);
	| not_removed =  UndoAdded clip added front editor1 io1;
	| not_added =  UndoRemoved removed  front editor1 io1;
	=  UndoBoth added removed front editor1 io1;
	where {
	editor3			=: SetFrontWindow (EW_SetUndoInfo ((True,clipb,0,0),added) front) (
						     SetClipboard strs editor2);
	(editor2,clipb)=: GetClipboard editor1;
	io1				=: EvtUnSelect front io;
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	not_added		=:  l1 == l2  &&  c1 == c2 ;
	not_removed		=:  x == 0  &&  y == 0 ;
	(l1,c1,l2,c2)	=: added;
	(clip,strs,x,y)=: removed;
	(removed,added)=: EW_GetUndoInfo front;
	};

UndoBoth	:: PartSel Removed EditWindow Editor IO -> EdIO;
UndoBoth added removed=:(fromclip,s,l,n) front editor io
	=  (SetFrontWindow (EW_SetUndoInfo (removed`,added`) front2) editor4, io2);
	where {
	(removed1,added`)	=: EW_GetUndoInfo front2;
	(editor4,front2)	=: GetFrontWindow editor3;
	(editor3,io2)		=: UndoRemoved removed front1 editor2 io1;
	(removed`,added1)	=: EW_GetUndoInfo front1;
	(editor2,front1)	=: ResetCurLine_and_GetFrontWindow editor1;
	(editor1,io1)		=: UndoAdded fromclip added front editor io;
	};

UndoAdded	:: Bool PartSel EditWindow Editor IO -> EdIO;
UndoAdded fromclip added=:(l1,c1,l2,c2) front editor io
	| fromclip =  FinishUndo editora io`;
	=  FinishUndo editorb io`;
	where {
	editora				=: ChangeFrontWindow [EW_SetUndoInfo ((True,[],l1,c1),EmptyAdded)] (
							     SetClipboard clip editor2);
	editorb				=: ChangeFrontWindow [EW_SetUndoInfo ((False,clip,l1,c1),EmptyAdded)] editor2;
	(clip,editor2,io`)=: RemoveSelection editor1 io1;
	io1					=: ChangeIOState
						    	[ EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
						    	  DrawInActiveWindow [DrawReHilite selection hght],
						    	  DisableTimer TimerID,
						   	  ChangeActiveKeyboardFunction TypeSelect ] io;
	editor1				=: ChangeFrontWindow [EW_SetSelection selection,
							                     EW_SetCursorPos (False,bx,by,bx),
							                     EW_SetCurLine (before,after,l1,c1)] editor;
	(before,after)		=: Line_SplitLine c1 (Text_GetLine l1 text);
	selection			=: (added,psel);
	(bx,by,ex,ey)		=: psel;
	psel					=: CalcPixelSelection added tabw hght text rfont;
	text					=: EW_GetText front;
	(ft,sz,rfont)		=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	(rtw,tabw)			=: EW_GetTabWidth front;
	};

UndoRemoved	:: Removed EditWindow Editor IO -> EdIO;
UndoRemoved (True,strs,lnr,cnr) front editor io =  FinishUndo editor` io`;
	where {
	io`					=: ChangeIOState
							    [ EvtUnSelect newfr,
							  		EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
							      DrawInActiveWindow [DrawReHilite selection hght],
							      DisableTimer TimerID,
							      ChangeActiveKeyboardFunction TypeSelect] io1;
	editor`				=: SetClipboard strs editor4;
	editor4				=: ChangeFrontWindow [EW_SetSelection selection,
	                                       EW_SetUndoInfo ((True,[],0,0),tsel)] editor3;
	selection			=: (tsel,psel);
	psel					=: (cx,cy,ncx,ncy);
	tsel					=: (lnr,cnr,nln,ncn);
	(b,ncx,ncy,nux)	=: EW_GetCursorPos newfr;
	(bf,af,nln,ncn)	=: EW_GetCurLine newfr;
	(editor3,newfr)	=: GetFrontWindow editor2;
	(editor2,io1)		=: Paste editor1 io;
	editor1				=: ChangeFrontWindow [EW_SetSelection ((lnr,cnr,lnr,cnr),(cx,cy,cx,cy)),
							                     EW_SetCursorPos (False,cx,cy,cx),
							                     EW_SetCurLine (before,after,lnr,cnr)] editor;
	(before,after)		=: Line_SplitLine cnr (Text_GetLine lnr (EW_GetText front));
	cx						=: CalcCursorX LinesLeft tabw (BeforeToLine before) rfont;
	cy						=: PictureTop +  lnr * hght ;
	(ft,sz,rfont)		=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	(rtw,tabw)			=: EW_GetTabWidth front;
	};
UndoRemoved (False,strs,lnr,cnr) front editor io =  FinishUndo editor` io`;
	where {
	io`					=: ChangeIOState
							    [ EvtUnSelect newfr,
							  		EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
							      DrawInActiveWindow [DrawReHilite selection hght],
							      DisableTimer TimerID,
							      ChangeActiveKeyboardFunction TypeSelect] io1;
	editor`				=: ChangeFrontWindow [EW_SetSelection selection,
	                                       EW_SetUndoInfo ((False,[],0,0),tsel)] editor4;
	selection			=: (tsel,psel);
	psel					=: (cx,cy,ncx,ncy);
	tsel					=: (lnr,cnr,nln,ncn);
	(b,ncx,ncy,nux)	=: EW_GetCursorPos newfr;
	(bf,af,nln,ncn)	=: EW_GetCurLine newfr;
	(editor4,newfr)	=: GetFrontWindow (SetClipboard clip editor3);
	(editor3,io1)		=: Paste (SetClipboard strs editor2) io;
	editor2				=: ChangeFrontWindow [EW_SetSelection ((lnr,cnr,lnr,cnr),(cx,cy,cx,cy)),
							                     EW_SetCursorPos (False,cx,cy,cx),
							                     EW_SetCurLine (before,after,lnr,cnr)] editor1;
	(editor1,clip)		=: GetClipboard editor;
	(before,after)		=: Line_SplitLine cnr (Text_GetLine lnr (EW_GetText front));
	cx						=: CalcCursorX LinesLeft tabw (BeforeToLine before) rfont;
	cy						=: PictureTop +  lnr * hght ;
	(ft,sz,rfont)		=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	(rtw,tabw)			=: EW_GetTabWidth front;
	};

FinishUndo	:: Editor IO -> EdIO;
FinishUndo editor io
	| IsEmptyList clip =  (editor`, DisableMenuItems [IPasteID] io`);
	=  (editor`, EnableMenuItems  [IPasteID] io`);
	where {
	io`				=: ChangeActiveKeyboardFunction TypeUndo io1;
	(editor`,clip)	=: GetClipboard editor1;
	(editor1,io1)	=: GotoCursor editor io;
	};

//
//	Device function for the Cut command
//

Cut :: Editor IO -> EdIO;
Cut editor io =  let! {
		clip;
		} in
		(editor`, EnableMenuItems [IPasteID,IReverID,ISaveID] io`);
	where {
	io`					=: ChangeActiveKeyboardFunction TypeUndo io1;
	editor`				=: SetClipboard clip editor4;	// !-annotated to prevent space-leak
	editor4				=: ChangeFrontWindow [EW_SetUndoInfo ((True,oldclip,lnr,cnr),EmptyAdded),
														EW_SetSaved False] editor3;
	(editor3,front)	=: GetFrontWindow editor2;
	(clip,editor2,io1)=: RemoveSelection editor1 io;
	(editor1,oldclip) =: GetClipboard editor;
	(b,a,lnr,cnr)		=: EW_GetCurLine front;
	};

//
//	Device function for the Copy command
//

Copy :: Editor IO -> EdIO;
Copy editor io =  (editor`, EnableMenuItems [IPasteID] io`);
	where {
	io`				=: ChangeActiveKeyboardFunction TypeUndo io;
	editor`			=: SetFrontWindow (EW_SetUndoInfo ((True,oldc,0,0),EmptyAdded) front) (
						     SetClipboard clip editor2);
	(editor2,front)=: ResetCurLine_and_GetFrontWindow editor1;
	(editor1,oldc)	=: GetClipboard editor;
	clip				=: Text_CopySelection (EW_GetSelection front) (EW_GetText front);
	};

Paste	:: Editor IO -> EdIO;
Paste editor io
	| no_selection && one_string_clip =  PasteOneString cliplast editorb iob;
	| one_string_clip =  PasteOneString cliplast editora ioa;
	| no_selection =  PasteStrings cliplen cliplast clip editorb iob;
	=  PasteStrings cliplen cliplast clip editora ioa;
	where {
	no_selection		=: IsEmptySelection (EW_GetSelection front);
	one_string_clip	=: cliplen == 1;
	editora				=: SetFrontWindow (
							     EW_SetUndoInfo ((False,rmvd,lnr,cnr),EmptyAdded) fronta) editor4;
	(editor4,fronta)	=: GetFrontWindow editor3;
	(rmvd,editor3,ioa)=: RemoveSelection editorb iob;
	editorb				=: ChangeFrontWindow [EW_SetUndoInfo (EmptyRemoved,EmptyAdded),
							                     EW_SetSaved False] editor2;
	(editor2,clip)		=: GetClipboard editor1;
	(editor1,front)	=: ResetCurLine_and_GetFrontWindow editor;
	iob					=: EnableMenuItems [ISaveID, IReverID] io1;
	io1					=: ChangeActiveKeyboardFunction TypeUndo io;
	(cliplen,cliplast)=: Length_and_Last clip;
	(bef,aft,lnr,cnr)	=: EW_GetCurLine fronta;
	};
	
PasteOneString	:: String Editor IO -> EdIO;
PasteOneString clipstr editor io =  (editor`,io`);
	where {
	editor`				=: ChangeFrontWindow
							    [ EW_SetUndoInfo (removed,(lnr,cnr,lnr,ncnr)),
							      EW_SetCurLine (before,aft,lnr,ncnr),
							      EW_SetCursorPos newpos ] editor1;
	(editor1,front)	=: GetFrontWindow editor;
	io`					=: DrawInActiveWindow 
							   [ Erase_and_DrawLine basey hght ofs tabw rgt line,
							     DrawCursor newpos cht ld ] io3;
	(visrect,io3)		=: ActiveWindowGetFrame io1;
	io1					=: DrawInActiveWindow [RemoveCursor oldpos cht ld] io;
	cx						=: CalcCursorX LinesLeft tabw (BeforeToLine before) rfont;
	before				=: AddStringBefore clipstr bef;
	ncnr					=: cnr +  size clipstr ;
	(bef,aft,lnr,cnr)	=: EW_GetCurLine front;
	line					=: Line_GlueLine before aft;
	oldpos				=: EW_GetCursorPos front;
	(v,ocx,ocy,oux)	=: oldpos;
	newpos				=: (True,cx,ocy,cx);
	basey					=: ocy + ofs;
	ofs					=: at_new + ld;
	(rtw,tabw)			=: EW_GetTabWidth front;
	cht					=: at_new + dt;
	(ft,sz,rfont)		=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	(removed,added)	=: EW_GetUndoInfo front;
	(rgt,bot)			=: botr;
	(topl,botr)			=: visrect;
	};

PasteStrings	:: Int String Clipboard Editor IO -> EdIO;
PasteStrings cliplen cliplast clip editor io
	| cbot > bot || cy < top =  (editora, ioa);
	=  (editorb, iob);
	where {
	(editora,ioa)		=: ChangeActiveScrollBar (ChangeVThumb verttmb) editorb iob;
	(editorb,iob)		=: AdjustWindowSize nrlines front editor2 io3;
	editor2				=: ChangeFrontWindow
							    [ EW_SetUndoInfo (removed,(lnr,cnr,ln,cn)),
							      EW_SetCurLine (before,after,ln,cn),
							      EW_SetCursorPos curcpos,
							      EW_SetText text,
							      EW_SetNrLines nrlines ] editor1;
	(editor1,front)	=: GetFrontWindow editor;
	io3					=: DrawInActiveWindow
							    [ Erase_and_DrawLines basey hght ofs tabw rgt lines,
							      DrawCursor curcpos cht ld] io2;
	(visrect,io2)		=: ActiveWindowGetFrame io;
	cx						=: CalcCursorX LinesLeft tabw (BeforeToLine before) rfont;
	(bef,aft,lnr,cnr)	=: EW_GetCurLine front;
	oldpos				=: EW_GetCursorPos front;
	(v,ocx,ocy,oux)	=: oldpos;
	nrlines				=:  EW_GetNrLines front  + pnrlines;
	(before,after)		=: Line_SplitLine cn (Text_GetLine ln text);
	cn						=: size cliplast;
	ln						=: lnr + pnrlines;
	cy						=: PictureTop +  ln * hght ;
	text					=: Text_PasteClipboard clip lnr cnr (EW_GetText front);
	lines					=: Text_GetLines lnr number text;
	number				=: Between 0 (nrlines - lnr) nr;
	nr						=: inc ( (bot - PictureTop) / hght  - lnr);
	basey					=: ocy + ofs;
	ofs					=: at_new + ld;
	(rtw,tabw)			=: EW_GetTabWidth front;
	cht					=: at_new + dt;
	cbot					=: cy + cht;
	verttmb				=: PictureTop +  hght *  inc (ln -  (bot - top) / hght )  ;
	(ft,sz,rfont)		=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)	=: EW_GetFontMetrics front;
	(removed,added)	=: EW_GetUndoInfo front;
	(rgt,bot)			=: botr;
	(lft,top)			=: topl;
	(topl,botr)			=: visrect;
	curcpos=:(True,cx,cy,cx);
		pnrlines=:(dec cliplen);
		};


//
//	Device function for the Clear command
//

Clear :: Editor IO -> EdIO;
Clear editor io =  (editor`, EnableMenuItems [IReverID,ISaveID] io`);
	where {
	io`					=: ChangeActiveKeyboardFunction TypeUndo io1;
	editor`				=: ChangeFrontWindow [EW_SetUndoInfo ((False,clip,lnr,cnr),EmptyAdded),
							                     EW_SetSaved False ] editor2;
	(editor2,front)	=: GetFrontWindow editor1;
	(clip,editor1,io1)=: RemoveSelection editor io;
	(bef,aft,lnr,cnr)	=: EW_GetCurLine front;
	};


//
//	Device function for the Balance command
//

Balance :: Editor IO -> EdIO;
Balance editor io
	| fnd =  (editor`, io`);
	=  (editor1, Alert io);
	where {
	editor`			=: ChangeFrontWindow [ EW_SetCurLine (bef,aft,l1,c1),
						                      EW_SetSelection selection,
						                      EW_SetCursorPos (True,cx,cy,x2) ] editor1;
	(editor1,front)=: ResetCurLine_and_GetFrontWindow editor;
	io`				=: ChangeIOState
						    [ EnableMenuItems [ICutID,ICopyID,IClearID,IFindSID,IReplaID],
						      DrawInActiveWindow [DrawReHilite selection hght],
						      DisableTimer TimerID,
						      ChangeActiveKeyboardFunction TypeSelect ] io1;
	io1				=: EvtUnSelect front io;
	(fnd,tsel)		=: Text_Balance bl bc el ec text;
	(l1,c1,l2,c2)	=: tsel;
	(x2,y2,cx,cy)	=: psel;
	selection		=: (tsel,psel);
	psel				=: CalcPixelSelection tsel tabw hght text rfont;
	(bef,aft)		=: Line_SplitLine c1 (Text_GetLine l1 text);
	text				=: EW_GetText front;
	(bl,bc,el,ec)	=: EW_GetTextPosition front;
	(ft,sz,rfont)	=: EW_GetWindowFont front;
	(at_new,dt,ld,hght)=: EW_GetFontMetrics front;
	(rtw,tabw)		=: EW_GetTabWidth front;
	};


//
//	Device function for the Format dialog
//

     
	PFontID	:== 1;
	PSFontID	:== 2;
	PSizeID	:== 3;
	PSSizeID	:== 4;
	PFoxID	:== 5;
	PETabWID	:== 6;		PSTabWID	:== 7;
	PSAutoID	:== 8;		PBAutoID	:== 9;
	PUseAID	:== 11;	PUseDID	:== 12;	PCancID	:== 13;	POKID	:== 14;
	IFontID	:== 2000;	ISizeID	:== 4000;
	FoxWid	:== 260;	FoxHgt	:== 32;
	
    
Format	:: Editor IO -> EdIO;
Format editor io =  OpenModalDialog dialog editor` io;
	where {
	dialog=: CommandDialog DFormatID "Format" [ItemSpace (Pixel 12) (Pixel 6)] POKID [
				StaticText PSFontID Left "Font:",
				ScrollingList PFontID (XOffset PSFontID (MM 1.0)) (MM 0.0) Able 5
			                                    cfont MakeFontItems ChangeSizesList,
				StaticText PSSizeID (RightTo PFontID) "Size:",
				ScrollingList PSizeID (XOffset PSSizeID (MM 1.0)) (MM 10.0) Able 5
			                                    (toString csize) (MakeSizeItems cfont) ChangeLazyFox,
				DialogIconButton PFoxID Left ((0,0),(FoxWid,FoxHgt))
			                                    (LazyFox cfont csize) Unable ButIdle,
				CheckBoxes PSAutoID Left (Columns 1)
			             [CheckBox PBAutoID "Auto Indent" Able (BoolToMark autoind) DFIdle],
				StaticText PSTabWID (RightTo PSAutoID) "Tab Width:",
				EditText   PETabWID (XOffset PSTabWID (MM 1.0)) (MM 10.0) 1 (toString rtabw),
				DialogButton PUseAID (YOffset PSAutoID (Pixel 12)) "Use Default Settings"
				                                                           Able SetToDefaults,
				DialogButton PCancID (XOffset PUseAID (Pixel 40)) "Cancel" Able FormatCancel,
				DialogButton PUseDID (YOffset PUseAID (Pixel 12)) "  Use As Defaults  "
				                                                           Able (FormatOK True),
				DialogButton POKID   (YOffset PCancID (Pixel 12)) "OK"     Able (FormatOK False) ];
	(fid,fonts)		=: MakeFontItems cfont;
	(sid,sizes)		=: MakeSizeItems cfont csize;
	(editor`,defs)	=: GetDefaults editor1;
	(editor1,front)=: GetFrontWindow editor;
	(cfont,csize,r)=: EW_GetWindowFont front;
	(rtabw,ptw)		=: EW_GetTabWidth front;
	autoind			=: EW_AutoIndent front;
	};

SetToDefaults	:: DialogInfo Editor IO -> EdIO;
SetToDefaults dialog editor io
	| same_font && same_size =  (editor`, ChangeDialog DFormatID changes io);
	| same_font =  (editor`, ChangeDialog DFormatID [setsize : changes] io);
	=  (editor`, ChangeDialog DFormatID [setfont,setsize : changes] io);
	where {
	setfont				=: ChangeScrollingList PFontID font MakeFontItems;
	setsize				=: ChangeScrollingList PSizeID (toString size) (MakeSizeItems font);
	changes				=: [ChangeIconLook PFoxID (LazyFox font size),
							   ChangeEditText PETabWID (toString tabw),
							   ChangeAutoIndentOption auto];
	same_font			=: font == oldft;
	same_size			=: size == oldsz;
	(font,size)			=: ft_and_sz;
	(tabw,ft_and_sz,auto)	=: defaults;
	(editor`,defaults)=: GetDefaults editor;
	(oldft,oldsz)		=: oldft_and_sz;
	(t,oldft_and_sz,a)		=: GetFormatDialogInfo dialog;
	};

ChangeAutoIndentOption	:: Bool (DialogState Editor IO) -> DialogState Editor IO;
ChangeAutoIndentOption auto dstate
	| auto =  MarkCheckBoxes   [PBAutoID] dstate;
	=  UnmarkCheckBoxes [PBAutoID] dstate;

FormatOK	:: Bool DialogInfo Editor IO -> EdIO;
FormatOK use_as_default dialog editor io
	| use_as_default =  ChangeWindowSettings newdefs editor` io;
	=  ChangeWindowSettings newdefs editor  io;
	where {
	editor`=: SetDefaults newdefs editor;
	newdefs=: GetFormatDialogInfo dialog;
	}; 

ChangeWindowSettings	:: Defaults Editor IO -> EdIO;
ChangeWindowSettings (tabs,(font,size),autoi) editor io
	| samefont_and_size && sametabs =  (editor`,io`);
	| samefont_and_size =  WindowSetTabWidth tabs front editor` io`;
	=  WindowSetFont_and_Size font size front` editor` io`;
	where {
	io`					=: CloseActiveDialog io;
	(editor`,front)	=: ResetCurLine_and_GetFrontWindow editor1;
	editor1				=: ChangeFrontWindow [ EW_SetAutoIndent autoi ] editor;
	front`				=: EW_SetTabWidth (tabs,0) front;
	sametabs				=: tabs == oldts;
	samefont_and_size		=:  font == oldf  &&  size == olds ;
	(oldts,oldrt)		=: EW_GetTabWidth front;
	(oldf,olds,oldrf)	=: EW_GetWindowFont front;
	};

FormatCancel	:: DialogInfo Editor IO -> EdIO;
FormatCancel dialog editor io =  (editor, CloseActiveDialog io);

LazyFox	:: FontName FontSize SelectState -> [DrawFunction];
LazyFox font size abty
	=  [SetFont rfont, MovePenTo (0,base), DrawString "The quick brown dog jumps..."];
	where {
	(b,rfont)			=: SelectFont font [] size;
	base					=: If (ascent > middle) ascent middle;
	(ascent,ds,mw,ld)	=: FontMetrics rfont;
	middle				=: FoxHgt / 2;
	};

DFIdle	:: DialogInfo (DialogState Editor IO) -> DialogState Editor IO;
DFIdle ddef dstate =  dstate;

ButIdle	:: DialogInfo Editor IO -> EdIO;
ButIdle ddef editor io =  (editor,io);

GetFormatDialogInfo	:: DialogInfo -> Defaults;
GetFormatDialogInfo dialog
	= 	(Between 1 99 (StringToInt tabstr), (fontname, realsize), automark);
	where {
	automark=: CheckBoxMarked PBAutoID dialog;
	tabstr  =: GetEditText PETabWID dialog;
	fontname=: GetScrollingListItem PFontID dialog;
	realsize=: StringToInt (GetScrollingListItem PSizeID dialog);
	};

/*	Create the items of the Font and Size pop-up menus */

MakeFontItems	::    [ItemTitle];
MakeFontItems = SortStrings FontNames;

MakeSizeItems	:: FontName -> [ItemTitle];
MakeSizeItems font =  CreateSizeItems (FontSizes font);

CreateSizeItems	:: [FontSize] -> [ItemTitle];
CreateSizeItems [size : rest] =  [toString size : CreateSizeItems rest];
CreateSizeItems [] =  [];

ChangeSizesList	:: DialogInfo (DialogState Editor IO) -> DialogState Editor IO;
ChangeSizesList ddef dstate
	= 	ChangeIconLook PFoxID (LazyFox font (StringToInt sstr)) dstate``;
	where {
	sstr				=: GetScrollingListItem PSizeID info;
	(info,dstate``)=: DialogStateGetDialogInfo dstate`;
	dstate`			=: ChangeScrollingList PSizeID (toString size) (MakeSizeItems font) dstate;
	(tb,ft_and_sz,ai)	=: GetFormatDialogInfo ddef;
	(font,size)		=: ft_and_sz;
	};

ChangeLazyFox	:: DialogInfo (DialogState Editor IO) -> DialogState Editor IO;
ChangeLazyFox dialog dstate =  ChangeIconLook PFoxID (LazyFox font size) dstate;
	where {
	(tb,ft_and_sz,ai)=: GetFormatDialogInfo dialog;
	(font,size)  =: ft_and_sz;
	};

/*	Misc. function(s) */

Length_and_Last	:: [t] -> (Int,t);
Length_and_Last [f] =  (1,f);
Length_and_Last [f:r] =  (inc len,last);
	where {
	(len,last)=: Length_and_Last r;
	};

IsEmptyList	:: [t] -> Bool;
IsEmptyList []  =  True;
IsEmptyList xs  =  False;
