definition module EdConstants;

/*	The constants for the Editor */

import deltaSystem;

     

/* The name of the help and preferences files */

HelpFile				:== "EditorHelp";
PrefsFile			:== "EditorPrefs";

/*	Default values */

DefIgnoreCase		:== False;
DefBackwards		:== False;
DefWrapAround		:== True;
DefMatchWords		:== False;
DefTabWidth			:== 4;
DefAutoIndent		:== True;

/*	initial cursor blinking rate (will be ignored) */

BlinkRate			:== 30;

/*	text sizes */

LinesPerBlock		:== 80;

/*	Picture offsets */

PictureTop			:== -31000;	// Lowest save value
MinBottom			:== -30700;	// PictureTop + 300
PictureLeft			:== -6;
PictureRight		:== 4000;
LinesLeft			:== 0;			// Must be zero!

/*	Window constants */

FirstEditWdID		:== 4000;
HelpWdID				:== 1;
WdCorner				:== (0,0);
WdInitSize			:== (500,300);
WdMinSize			:== (70,70);
HorScroll			:== 10;
VertScroll			:== 10;

/*	Ids of the menu(item)s */

MFileID				:== 10;
	INewID			:== 101;
	IOpenID			:== 102;
	ICloseID			:== 103;
	ISaveID			:== 104;
	ISavesID			:== 105;
	IReverID			:== 106;
	IQuitID			:== 107;

MEditID				:== 20;
	IUndoID			:== 200;
	ICutID			:== 201;
	ICopyID			:== 202;
	IPasteID			:== 203;
	IClearID			:== 204;
	IBalanID			:== 205;
	ISelecID			:== 206;
	IFormaID			:== 207;

MSearcID				:== 30;
	IFindID			:== 301;
	IFindNID			:== 302;
	IFindSID			:== 303;
	IReplaID			:== 304;
	IGotoCID			:== 305;
	IGotoLID			:== 306;

MWindoID				:== 40;
	IHelpID			:== 401;
	ISaveaID			:== 402;
	IClosaID			:== 403;
	IWindoID			:== 404;

/*	Id's of the dialogs */

DFindID				:== 1;
DGotoLID				:== 2;
DTabWID				:== 3;
DSvBCID				:== 4;
DFormatID			:== 5;

/*	Id of the timer */

TimerID				:== 1;

/*	Key constants */

	TabStr			:== "\t";
	TabChar			:== '\t';
	NewlStr			:== "\n";
	NewlChar			:== '\n';
	
	FirstPrintable	:== '\040';
	LastPrintable	:== '\176';
	FirstCapital	:== 'A';
	LastCapital		:== 'Z';
	FirstSmall		:== 'a';
	LastSmall		:== 'z';
	CaseOffset		:== 32;
	OutlineChars	:== [' ', '"', '\'' ,'(' ,')' ,',' ,'.' ,':',
						    ';', '[', ']', '{', '|', '}'];

/*	Available font sizes */

    
SizesList	::		   [Int];
