#ifndef _KVALMASK_
#define _KVALMASK_

#ifndef _KVALID_
   #include <kvalid.hpp>
#endif

#ifndef _I0STRING_
   #include <i0string.hpp>
#endif

#ifndef _IPOINT_
   #include <ipoint.hpp>
#endif

#ifndef _IHANDLER_
   #include <ihandler.hpp>
#endif

#ifndef _IMCHDR_
   #include <imchdr.hpp>
#endif


class KEntryField;


class KMaskFocusHandler : public IHandler
{
  protected:
    virtual Boolean dispatchHandlerEvent(IEvent& event);
    virtual Boolean setFocus(IEvent& event);
};

class KMaskClickHandler : public IMouseClickHandler
{
  protected:
    virtual Boolean mouseClicked(IMouseClickEvent& event);
};

class _Export KMaskValidator : public KValidator
{
   typedef KValidator Inherited;
   static const int right, 
                    left;

   public: 
      KMaskValidator(const char *pattern);
      virtual IHandler& handleEventsFor(IWindow *window);
      virtual IString &fill(IString &strText);
      virtual IString &strip(IString &strText);

   protected:
      virtual Boolean characterKeyPress(IKeyboardEvent& event);
      virtual Boolean virtualKeyPress(IKeyboardEvent& event);
      virtual Boolean isValid(const char *text, 
                              Boolean fill=false) const;

   private:
      Boolean adjustPosition(KEntryField* field, int dir);
      void fillMasks();
      IRange selected;
      I0String emptyMask;
      I0String controlMask;
      I0String originalMask;
      KMaskFocusHandler focusHandler;
      KMaskClickHandler clickHandler;
};

#endif
