/*
 * $RCSId: xc/lib/fontconfig/src/fccfg.c,v 1.23 2002/08/31 22:17:32 keithp Exp $
 *
 * Copyright © 2000 Keith Packard
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Keith Packard not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Keith Packard makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdlib.h>
#include <stdio.h>
#include "fcint.h"

#ifdef __OS2__
#define INCL_WINDIALOGS
#include <os2.h>
#endif

#define FC_DEFAULT_CONFIG_FILE \
  "<?xml version=\"1.0\"?>\n" \
"<!DOCTYPE fontconfig SYSTEM \"fonts.dtd\">\n" \
"<!-- /etc/fonts/fonts.conf file to configure system font access -->\n" \
"<fontconfig>\n" \
"\n" \
"<!--\n" \
"	DO NOT EDIT THIS FILE.\n" \
"	IT WILL BE REPLACED WHEN FONTCONFIG IS UPDATED.\n" \
"	LOCAL CHANGES BELONG IN 'local.conf'.\n" \
"\n" \
"	The intent of this standard configuration file is to be adequate for\n" \
"	most environments.  If you have a reasonably normal environment and\n" \
"	have found problems with this configuration, they are probably\n" \
"	things that others will also want fixed.  Please submit any\n" \
"	problems to the fontconfig bugzilla system located at fontconfig.org\n" \
"\n" \
"	Note that the normal 'make install' procedure for fontconfig is to\n" \
"	replace any existing fonts.conf file with the new version.  Place\n" \
"	any local customizations in local.conf which this file references.\n" \
"\n" \
"	Keith Packard\n" \
"-->\n" \
"\n" \
"<!-- Font directory list -->\n" \
"\n" \
"	<dir></dir>\n" \
"\n" \
"<!--\n" \
"  Accept deprecated 'mono' alias, replacing it with 'monospace'\n" \
"-->\n" \
"	<match target=\"pattern\">\n" \
"		<test qual=\"any\" name=\"family\">\n" \
"			<string>mono</string>\n" \
"		</test>\n" \
"		<edit name=\"family\" mode=\"assign\">\n" \
"			<string>monospace</string>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"<!--\n" \
"  Accept alternate 'sans serif' spelling, replacing it with 'sans-serif'\n" \
"-->\n" \
"	<match target=\"pattern\">\n" \
"		<test qual=\"any\" name=\"family\">\n" \
"			<string>sans serif</string>\n" \
"		</test>\n" \
"		<edit name=\"family\" mode=\"assign\">\n" \
"			<string>sans-serif</string>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"<!--\n" \
"  Accept deprecated 'sans' alias, replacing it with 'sans-serif'\n" \
"-->\n" \
"	<match target=\"pattern\">\n" \
"		<test qual=\"any\" name=\"family\">\n" \
"			<string>sans</string>\n" \
"		</test>\n" \
"		<edit name=\"family\" mode=\"assign\">\n" \
"			<string>sans-serif</string>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"<!--\n" \
"  Mark common families with their generics so we'll get\n" \
"  something reasonable\n" \
"-->\n" \
"\n" \
"<!--\n" \
"  Serif faces\n" \
" -->\n" \
"	<alias>\n" \
"		<family>Bitstream Vera Serif</family>\n" \
"		<family>Times New Roman</family>\n" \
"		<family>Thorndale AMT</family>\n" \
"		<family>Times</family>\n" \
"		<family>Nimbus Roman No9 L</family>\n" \
"		<family>Luxi Serif</family>\n" \
"		<family>Kochi Mincho</family>\n" \
"		<family>AR PL SungtiL GB</family>\n" \
"		<family>AR PL Mingti2L Big5</family>\n" \
"		<family>ＭＳ 明朝</family>\n" \
"		<family>Baekmuk Batang</family>\n" \
"		<family>FreeSerif</family>\n" \
"		<default><family>serif</family></default>\n" \
"	</alias>\n" \
"<!--\n" \
"  Sans-serif faces\n" \
" -->\n" \
"	<alias>\n" \
"		<family>Bitstream Vera Sans</family>\n" \
"		<family>Helvetica</family>\n" \
"		<family>Arial</family>\n" \
"		<family>Verdana</family>\n" \
"		<family>Albany AMT</family>\n" \
"		<family>Nimbus Sans L</family>\n" \
"		<family>Luxi Sans</family>\n" \
"		<family>Kochi Gothic</family>\n" \
"		<family>AR PL KaitiM GB</family>\n" \
"		<family>AR PL KaitiM Big5</family>\n" \
"		<family>ＭＳ ゴシック</family>\n" \
"		<family>Baekmuk Dotum</family>\n" \
"		<family>SimSun</family>\n" \
"		<family>FreeSans</family>\n" \
"		<default><family>sans-serif</family></default>\n" \
"	</alias>\n" \
"<!--\n" \
"  Monospace faces\n" \
" -->\n" \
" 	<alias>\n" \
"		<family>Bitstream Vera Sans Mono</family>\n" \
"		<family>Courier</family>\n" \
"		<family>Courier New</family>\n" \
"		<family>Andale Mono</family>\n" \
"		<family>Luxi Mono</family>\n" \
"		<family>Cumberland AMT</family>\n" \
"		<family>Nimbus Mono L</family>\n" \
"		<family>NSimSun</family>\n" \
"		<family>FreeMono</family>\n" \
"		<default><family>monospace</family></default>\n" \
"	</alias>\n" \
"<!--\n" \
"  If the font still has no generic name, add sans-serif\n" \
" -->\n" \
"	<match target=\"pattern\">\n" \
"		<test qual=\"all\" name=\"family\" compare=\"not_eq\">\n" \
"			<string>sans-serif</string>\n" \
"		</test>\n" \
"		<test qual=\"all\" name=\"family\" compare=\"not_eq\">\n" \
"			<string>serif</string>\n" \
"		</test>\n" \
"		<test qual=\"all\" name=\"family\" compare=\"not_eq\">\n" \
"			<string>monospace</string>\n" \
"		</test>\n" \
"		<edit name=\"family\" mode=\"append_last\">\n" \
"			<string>sans-serif</string>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"<!--\n" \
"  URW provides metric and shape compatible fonts for these 3 Adobe families.\n" \
"  -->\n" \
"        <alias>\n" \
"	  <family>Times</family>\n" \
"	  <accept><family>Nimbus Roman No9 L</family></accept>\n" \
"	</alias>\n" \
"        <alias>\n" \
"	  <family>Helvetica</family>\n" \
"	  <accept><family>Nimbus Sans L</family></accept>\n" \
"	</alias>\n" \
"        <alias>\n" \
"	  <family>Courier</family>\n" \
"	  <accept><family>Nimbus Mono L</family></accept>\n" \
"	</alias>\n" \
"\n" \
"<!--\n" \
" AMT provides metric and shape compatible fonts for these three web font\n" \
" families.\n" \
" -->\n" \
" 	<alias>\n" \
"		<family>Times New Roman</family>\n" \
"		<accept><family>Thorndale AMT</family></accept>\n" \
"	</alias>\n" \
" 	<alias>\n" \
"		<family>Arial</family>\n" \
"		<accept><family>Albany AMT</family></accept>\n" \
"	</alias>\n" \
" 	<alias>\n" \
"		<family>Courier New</family>\n" \
"		<accept><family>Cumberland AMT</family></accept>\n" \
"	</alias>\n" \
" \n" \
"<!--\n" \
"  Some Asian fonts misadvertise themselves as monospaced when\n" \
"  in fact they are dual-spaced (half and full).  This makes\n" \
"  FreeType very confused as it forces all widths to match.\n" \
"  Undo this magic by disabling the width forcing code -->\n" \
"	<match target=\"font\">\n" \
"		<test name=\"family\"><string>GulimChe</string></test>\n" \
"		<edit name=\"globaladvance\"><bool>false</bool></edit>\n" \
"	</match>\n" \
"\n" \
"	<match target=\"font\">\n" \
"		<test name=\"family\"><string>DotumChe</string></test>\n" \
"		<edit name=\"globaladvance\"><bool>false</bool></edit>\n" \
"	</match>\n" \
"\n" \
"	<match target=\"font\">\n" \
"		<test name=\"family\"><string>BatangChe</string></test>\n" \
"		<edit name=\"globaladvance\"><bool>false</bool></edit>\n" \
"	</match>\n" \
"\n" \
"       <match target=\"font\">\n" \
"		<test name=\"family\"><string>GungsuhChe</string></test>\n" \
"		<edit name=\"globaladvance\"><bool>false</bool></edit>\n" \
"	</match>\n" \
"\n" \
"<!-- \n" \
"	The Bitstream Vera fonts have GASP entries suggesting that hinting be\n" \
"	disabled below 8 ppem, but FreeType ignores those, preferring to use\n" \
"	the data found in the instructed hints.  The initial Vera release\n" \
"	didn't include the right instructions in the 'prep' table. Fix this\n" \
"	by disabling hinting manually at smaller sizes (< 8ppem)\n" \
" -->\n" \
"\n" \
"	<match target=\"font\">\n" \
"		<test name=\"family\">\n" \
"			<string>Bitstream Vera Sans</string>\n" \
"		</test>\n" \
"		<test name=\"pixelsize\" compare=\"less\">\n" \
"			<double>7.5</double>\n" \
"		</test>\n" \
"		<edit name=\"hinting\">\n" \
"			<bool>false</bool>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"	<match target=\"font\">\n" \
"		<test name=\"family\">\n" \
"			<string>Bitstream Vera Serif</string>\n" \
"		</test>\n" \
"		<test name=\"pixelsize\" compare=\"less\">\n" \
"			<double>7.5</double>\n" \
"		</test>\n" \
"		<edit name=\"hinting\">\n" \
"			<bool>false</bool>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"	<match target=\"font\">\n" \
"		<test name=\"family\">\n" \
"			<string>Bitstream Vera Sans Mono</string>\n" \
"		</test>\n" \
"		<test name=\"pixelsize\" compare=\"less\">\n" \
"			<double>7.5</double>\n" \
"		</test>\n" \
"		<edit name=\"hinting\">\n" \
"			<bool>false</bool>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"<!--\n" \
"  Provide required aliases for standard names\n" \
"-->\n" \
"	<alias>\n" \
"		<family>serif</family>\n" \
"		<prefer>\n" \
"			<family>Bitstream Vera Serif</family>\n" \
"			<family>Times New Roman</family>\n" \
"			<family>Thorndale AMT</family>\n" \
"			<family>Luxi Serif</family>\n" \
"			<family>Nimbus Roman No9 L</family>\n" \
"			<family>Times</family>\n" \
"			<family>Frank Ruehl</family>\n" \
"			<family>Kochi Mincho</family>\n" \
"			<family>AR PL SungtiL GB</family>\n" \
"			<family>AR PL Mingti2L Big5</family>\n" \
"			<family>ＭＳ 明朝</family>\n" \
"			<family>Baekmuk Batang</family>\n" \
"			<family>FreeSerif</family>\n" \
"		</prefer>\n" \
"	</alias>\n" \
"	<alias>\n" \
"		<family>sans-serif</family>\n" \
"		<prefer>\n" \
"			<family>Bitstream Vera Sans</family>\n" \
"			<family>Verdana</family>\n" \
"			<family>Arial</family>\n" \
"			<family>Albany AMT</family>\n" \
"			<family>Luxi Sans</family>\n" \
"			<family>Nimbus Sans L</family>\n" \
"			<family>Helvetica</family>\n" \
"			<family>Nachlieli</family>\n" \
"			<family>Kochi Gothic</family>\n" \
"			<family>AR PL KaitiM GB</family>\n" \
"			<family>AR PL KaitiM Big5</family>\n" \
"			<family>ＭＳ ゴシック</family>\n" \
"			<family>Baekmuk Dotum</family>\n" \
"			<family>SimSun</family>\n" \
"			<family>FreeSans</family>\n" \
"		</prefer>\n" \
"	</alias>\n" \
"	<alias>\n" \
"		<family>monospace</family>\n" \
"		<prefer>\n" \
"			<family>Bitstream Vera Sans Mono</family>\n" \
"			<family>Andale Mono</family>\n" \
"			<family>Courier New</family>\n" \
"			<family>Cumberland AMT</family>\n" \
"			<family>Luxi Mono</family>\n" \
"			<family>Nimbus Mono L</family>\n" \
"			<family>Courier</family>\n" \
"			<family>Miriam Mono</family>\n" \
"			<family>Kochi Gothic</family>\n" \
"			<family>AR PL KaitiM GB</family>\n" \
"			<family>Baekmuk Dotum</family>\n" \
"			<family>FreeMono</family>\n" \
"		</prefer>\n" \
"	</alias>\n" \
"\n" \
"<!-- \n" \
" Artificial oblique for fonts without an italic or oblique version\n" \
" -->\n" \
" \n" \
"	<match target=\"font\">\n" \
"		<!-- check to see if the font is roman -->\n" \
"		<test name=\"slant\">\n" \
"			<const>roman</const>\n" \
"		</test>\n" \
"		<!-- check to see if the pattern requested non-roman -->\n" \
"		<test target=\"pattern\" name=\"slant\" compare=\"not_eq\">\n" \
"			<const>roman</const>\n" \
"		</test>\n" \
"		<!-- multiply the matrix to slant the font -->\n" \
"		<edit name=\"matrix\" mode=\"assign\">\n" \
"			<times>\n" \
"				<name>matrix</name>\n" \
"				<matrix><double>1</double><double>0.2</double>\n" \
"					<double>0</double><double>1</double>\n" \
"				</matrix>\n" \
"			</times>\n" \
"		</edit>\n" \
"		<!-- pretend the font is oblique now -->\n" \
"		<edit name=\"slant\" mode=\"assign\">\n" \
"			<const>oblique</const>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"<!--\n" \
" Synthetic emboldening for fonts that do not have bold face available\n" \
" -->\n" \
"\n" \
"	<match target=\"font\">\n" \
"		<!-- check to see if the font is just regular -->\n" \
"		<test name=\"weight\" compare=\"less_eq\">\n" \
"			<int>100</int>\n" \
"		</test>\n" \
"		<!-- check to see if the pattern requests bold -->\n" \
"		<test target=\"pattern\" name=\"weight\" compare=\"more_eq\">\n" \
"			<int>200</int>\n" \
"		</test>\n" \
"		<!-- set the embolden flag -->\n" \
"		<edit name=\"embolden\" mode=\"assign\">\n" \
"			<bool>true</bool>\n" \
"		</edit>\n" \
"	</match>\n" \
"\n" \
"\n" \
"	<config>\n" \
"<!--\n" \
"  These are the default Unicode chars that are expected to be blank\n" \
"  in fonts.  All other blank chars are assumed to be broken and\n" \
"  won't appear in the resulting charsets\n" \
" -->\n" \
"		<blank>\n" \
"			<int>0x0020</int>	<!-- SPACE -->\n" \
"			<int>0x00A0</int>	<!-- NO-BREAK SPACE -->\n" \
"			<int>0x00AD</int>	<!-- SOFT HYPHEN -->\n" \
"			<int>0x034F</int>	<!-- COMBINING GRAPHEME JOINER -->\n" \
"			<int>0x0600</int>	<!-- ARABIC NUMBER SIGN -->\n" \
"			<int>0x0601</int>	<!-- ARABIC SIGN SANAH -->\n" \
"			<int>0x0602</int>	<!-- ARABIC FOOTNOTE MARKER -->\n" \
"			<int>0x0603</int>	<!-- ARABIC SIGN SAFHA -->\n" \
"			<int>0x06DD</int>	<!-- ARABIC END OF AYAH -->\n" \
"			<int>0x070F</int>	<!-- SYRIAC ABBREVIATION MARK -->\n" \
"			<int>0x115F</int>	<!-- HANGUL CHOSEONG FILLER -->\n" \
"			<int>0x1160</int>	<!-- HANGUL JUNGSEONG FILLER -->\n" \
"			<int>0x1680</int>	<!-- OGHAM SPACE MARK -->\n" \
"			<int>0x17B4</int>	<!-- KHMER VOWEL INHERENT AQ -->\n" \
"			<int>0x17B5</int>	<!-- KHMER VOWEL INHERENT AA -->\n" \
"			<int>0x180E</int>	<!-- MONGOLIAN VOWEL SEPARATOR -->\n" \
"			<int>0x2000</int>	<!-- EN QUAD -->\n" \
"			<int>0x2001</int>	<!-- EM QUAD -->\n" \
"			<int>0x2002</int>	<!-- EN SPACE -->\n" \
"			<int>0x2003</int>	<!-- EM SPACE -->\n" \
"			<int>0x2004</int>	<!-- THREE-PER-EM SPACE -->\n" \
"			<int>0x2005</int>	<!-- FOUR-PER-EM SPACE -->\n" \
"			<int>0x2006</int>	<!-- SIX-PER-EM SPACE -->\n" \
"			<int>0x2007</int>	<!-- FIGURE SPACE -->\n" \
"			<int>0x2008</int>	<!-- PUNCTUATION SPACE -->\n" \
"			<int>0x2009</int>	<!-- THIN SPACE -->\n" \
"			<int>0x200A</int>	<!-- HAIR SPACE -->\n" \
"			<int>0x200B</int>	<!-- ZERO WIDTH SPACE -->\n" \
"			<int>0x200C</int>	<!-- ZERO WIDTH NON-JOINER -->\n" \
"			<int>0x200D</int>	<!-- ZERO WIDTH JOINER -->\n" \
"			<int>0x200E</int>	<!-- LEFT-TO-RIGHT MARK -->\n" \
"			<int>0x200F</int>	<!-- RIGHT-TO-LEFT MARK -->\n" \
"			<int>0x2028</int>	<!-- LINE SEPARATOR -->\n" \
"			<int>0x2029</int>	<!-- PARAGRAPH SEPARATOR -->\n" \
"			<int>0x202A</int>	<!-- LEFT-TO-RIGHT EMBEDDING -->\n" \
"			<int>0x202B</int>	<!-- RIGHT-TO-LEFT EMBEDDING -->\n" \
"			<int>0x202C</int>	<!-- POP DIRECTIONAL FORMATTING -->\n" \
"			<int>0x202D</int>	<!-- LEFT-TO-RIGHT OVERRIDE -->\n" \
"			<int>0x202E</int>	<!-- RIGHT-TO-LEFT OVERRIDE -->\n" \
"			<int>0x202F</int>	<!-- NARROW NO-BREAK SPACE -->\n" \
"			<int>0x205F</int>	<!-- MEDIUM MATHEMATICAL SPACE -->\n" \
"			<int>0x2060</int>	<!-- WORD JOINER -->\n" \
"			<int>0x2061</int>	<!-- FUNCTION APPLICATION -->\n" \
"			<int>0x2062</int>	<!-- INVISIBLE TIMES -->\n" \
"			<int>0x2063</int>	<!-- INVISIBLE SEPARATOR -->\n" \
"			<int>0x206A</int>	<!-- INHIBIT SYMMETRIC SWAPPING -->\n" \
"			<int>0x206B</int>	<!-- ACTIVATE SYMMETRIC SWAPPING -->\n" \
"			<int>0x206C</int>	<!-- INHIBIT ARABIC FORM SHAPING -->\n" \
"			<int>0x206D</int>	<!-- ACTIVATE ARABIC FORM SHAPING -->\n" \
"			<int>0x206E</int>	<!-- NATIONAL DIGIT SHAPES -->\n" \
"			<int>0x206F</int>	<!-- NOMINAL DIGIT SHAPES -->\n" \
"			<int>0x3000</int>	<!-- IDEOGRAPHIC SPACE -->\n" \
"			<int>0x3164</int>	<!-- HANGUL FILLER -->\n" \
"			<int>0xFEFF</int>	<!-- ZERO WIDTH NO-BREAK SPACE -->\n" \
"			<int>0xFFA0</int>	<!-- HALFWIDTH HANGUL FILLER -->\n" \
"			<int>0xFFF9</int>	<!-- INTERLINEAR ANNOTATION ANCHOR -->\n" \
"			<int>0xFFFA</int>	<!-- INTERLINEAR ANNOTATION SEPARATOR -->\n" \
"			<int>0xFFFB</int>	<!-- INTERLINEAR ANNOTATION TERMINATOR -->\n" \
"		</blank>\n" \
"<!--\n" \
"  Rescan configuration every 30 seconds when FcFontSetList is called\n" \
" -->\n" \
"		<rescan>\n" \
"			<int>30</int>\n" \
"		</rescan>\n" \
"	</config>\n" \
"\n" \
"</fontconfig>\n" \
"\n"


int
FcCreateDefaultConfigFile (void)
{
  int rc;
  FILE *hFile = NULL;
  char *pchHome = FcConfigHome();
  char *pchFilename = FONTCONFIG_FILE;
  char *pchFullPath = NULL;

  /* Default result: failure */
  rc = 0;

  /* Assemble default config file filename */
  if (pchFilename[0]=='~')
  {
    /* In HOME */
    if (pchHome)
    {
      pchFullPath = malloc(strlen(pchHome)+strlen(pchFilename)+10);
    
      if (pchFullPath)
      {
        if (pchHome[strlen(pchHome)-1]!='\\')
          sprintf(pchFullPath, "%s\\%s", pchHome, pchFilename+2);
        else
          sprintf(pchFullPath, "%s%s", pchHome, pchFilename+2);
      }
    }

    if (pchFullPath)
    {
      hFile = fopen(pchFullPath, "wt");
      free(pchFullPath);
    }
  } else
  {
    /* Not in home */
    hFile = fopen(pchFilename, "wt");
  }

  if (hFile)
  {
    fprintf(hFile, FC_DEFAULT_CONFIG_FILE);
    fclose(hFile);
    /* Set result to success */
    rc = 1;

#ifdef __OS2__
    // Show info on text screens
    fprintf(stderr, "WARNING: New config file has been created for FontConfig!\n");
    fprintf(stderr, "         A scanning of all system fonts will be needed,\n");
    fprintf(stderr, "         which may take some minutes!\n");
    fprintf(stderr, "         Please be patient!\n");

    // Also show info in window, if possible!
    // The MB_NONMODAL flag is missing from some OS/2 header
    // files, so we define it here in case it's still missing:
#ifndef MB_NONMODAL
#define MB_NONMODAL 0x8000
#endif
    WinMessageBox(HWND_DESKTOP,
                  HWND_DESKTOP,
                  "New config file has been created for FontConfig!\n"
                  "A scanning of all system fonts will be needed,\n"
                  "which may take some minutes!\n"
                  "Please be patient!\n",
                  "First start of FontConfig",
                  0xca1f0,
                  MB_OK | MB_INFORMATION | MB_MOVEABLE | MB_NONMODAL);
#endif
  }

  return rc;
}
