/*
 * SETMODE.CMD - Changes the pwICQ current status
 */

parse arg mode

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call RxFuncAdd 'ICQLoadFuncs', 'rxicq', 'ICQLoadFuncs' 
call ICQLoadFuncs

if mode = ""
   then mode = "Away"

/* Find current user */

iniFile = SysIni('USER', 'pwICQ', 'ProgramPath')||"pwICQ.INI"
UIN     = SysIni(iniFile,"MAIN","UIN")

/* Send command */

say "Changing status of "||UIN||" to "||mode

if ICQSetStatus(UIN,mode) = 343 then
   do
      /* pwICQ isn't running, open the object */
      say "pwICQ isn't running, starting it..."
      ok = SysSetObjectData("<PWICQ#"||UIN||">","OPEN=DEFAULT")
      ok = SysSleep(5)
      ok = ICQSetStatus(UIN,mode)
   end

call ICQDropFuncs




