/*
 * Set time/date/hostname for uniaud build environment
 */

/* parse arg sAlsaBase */
parse arg sAlsaBase

/* I don't this will ever change from Netlabs */
projVendor    = "Netlabs"
projVendorNam = "Netlabs <www.netlabs.org>"
projAdapter   = "Rexx Utility Library"


/* uniaud.inc is located in the mif directory and
 * is read by mkversion.cmd for constants. The result
 * is written to bin directory and removed by clean.
 */
if sAlsaBase = "" then sAlsaBase = "."

versConst = sAlsaBase'\mif\rexxutil.inc'
versMak   = sAlsaBase'\rxdesc.lnk'
versHdr   = sAlsaBase'\version.h'

/* get and format date and time */
curDate    = DATE('S')
projDate   = RIGHT(curDate, 2)"."SUBSTR(curDate, 5, 2)"."LEFT(curDate, 4)
projDate2  = LEFT(curDate, 4)SUBSTR(curDate, 5, 2)RIGHT(curDate, 2)L
projTime   = TIME( )

/* get hostname for build system */
projHost = VALUE('HOSTNAME',,'OS2ENVIRONMENT')

/* projString = projDate" "projTime"       "projHost */
projString = left(Date() TIME(),25)left(projHost,10)

say "Project date: "projDate
say "Project time: "projTime
say "hostname:     "projHost
say "Version In:    "versConst
say "Version Mak:   "versMak
say "Version Hdr:   "versHdr

LINEIN(versConst,,0)

fixpack=''

do while(LINES(versConst))
    tmpLine = LINEIN(versConst)

    IF POS('#', tmpline) = 1 Then iterate

    opLoc = POS('BUILDVERSION', tmpLine)
    if opLoc > 0 then
      versionIn = STRIP((RIGHT(tmpLine, ( LENGTH(tmpLine) - (POS("=", tmpLine)+1) ))), B, ' ')

    opLoc = POS('PRODUCTNAME', tmpLine)
    if opLoc > 0 then
      productName = STRIP((RIGHT(tmpLine, ( LENGTH(tmpLine) - (POS("=", tmpLine)+1) ))), B, ' ')

    opLoc = POS('FIXPACK', tmpLine)
    if opLoc > 0 then
      fixpack = STRIP((RIGHT(tmpLine, ( LENGTH(tmpLine) - (POS("=", tmpLine)+1) ))), B, ' ')

    opLoc = POS('ALSAVERSION', tmpLine)
    if opLoc > 0 then
      alsalevel = STRIP((RIGHT(tmpLine, ( LENGTH(tmpLine) - (POS("=", tmpLine)+1) ))), B, ' ')
end

if versionIn = "" then do
    say "Could not find Version in "versConst
    exit
end

parse value versionIn with major'.'minor'.'projVersion

projVers  = versionIn'-'fixpack
projVers2 = major||minor||LEFT(projVersion, 1)

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


/* Here is where we setup the BLDLEVEL string and it has to be this way!!
 * wmake eats extra spaces so the BLDLEVEL info is written to version.lnk
 * and later used directly by wlink to preserve its structure:
 * wlink @version.lnk
 */
dummy = SysFileDelete(versMak)
call lineout versMak, "option description '@#"ProjVendor":"major"."minor"#@##1## "ProjString"::::"ProjVersion"::"Fixpack"@@"productname"'"
call lineout versMak


/* construct the vesion header
 */
dummy = SysFileDelete(versHdr)
if (stream(versHdr, 'c', 'open write' ) = 'READY:') then
do
    call lineout versHdr, '/*'
    call lineout versHdr, ' * version.h   Header for version string'
    call lineout versHdr, ' *'
    call lineout versHdr, ' *    Generated by mkversion.cmd, do NOT edit !'
    call lineout versHdr, ' *'
    call lineout versHdr, ' */'
    call lineout versHdr, ' '
    call lineout versHdr, ' '
    call lineout versHdr, '#ifndef __REXXUTILVER_H__'
    call lineout versHdr, '#define __REXXUTILVER_H__'
    call lineout versHdr, ' '
    call lineout versHdr, ' '
    call lineout versHdr, '#define LIBVERSION_MAJOR        "'major'"'
    call lineout versHdr, '#define LIBVERSION_MINOR        "'minor'"'
    call lineout versHdr, ' '
    call lineout versHdr, ' '
    call lineout versHdr, "#endif //__REXXUTILVER_H__"
    call lineout versHdr, ' '
    call stream versHdr, 'c', 'close';
end
else
do
    say 'oops, failed to open outputfile,' versHdr;
    exit 1;
end

exit 0;


