/* rexx */
parse arg argument

signal on error
signal on syntax  name syntax
signal on halt    name halt
signal on failure name failure
'@echo off'

'cls'
say
say 'TestLong --- Testing REXXGDB2.DLL For Long SQLs & Returned Values'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., June 1996'
say
sql = 'select text from sysibm.sysviews where length(text) > 1000'

say

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
call time 'R'
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'
say 'Execution time    ' time('E') / 1
say
say copies('~', 78)
say center('*** TESTLONG TESTS STARTED ***', 78)
say
say copies('~', 78)

say 'G2Immediate using IMMED (value) as input...'
immed = 'set current query optimization 9'
say 'Immed:' immed
'pause'
call time 'R'
retcode = g2immediate(immed)
elapse = time('E')
say 'Return Code           ' retcode
say 'Completed in (seconds)' elapse
say copies('~', 78)

say 'G2Immediate using ''IMMED'' as input...'
immed = 'set current query optimization 0'
say 'Immed:' immed
'pause'
call time 'R'
retcode = g2immediate('immed')
elapse = time('E')
say 'Return Code           ' retcode
say 'Completed in (seconds)' elapse
say copies('~', 78)

say 'G2SelectCols using SQL (value) as input...'
say 'SQL:' sql
'pause'
call time 'R'
retcode = g2selectcols(sql, cols.)
elapse = time('E')
say 'Return Code           ' retcode
say 'Completed in (seconds)' elapse
say
say 'Stem tot# elements    ' cols.0
if retcode = 0 | retcode = 100 then do
   do i = 1 to cols.0
      say 'Element COLS.'i '=' cols.i
      end
   end
say copies('~', 78)

say 'G2SelectCols using ''SQL'' as input...'
say 'SQL:' sql
'pause'
call time 'R'
retcode = g2selectcols('sql', cols.)
elapse = time('E')
say 'Return Code           ' retcode
say 'Completed in (seconds)' elapse
say
say 'Stem tot# elements    ' cols.0
if retcode = 0 | retcode = 100 then do
   do i = 1 to cols.0
      say 'Element COLS.'i '=' cols.i
      end
   end
say copies('~', 78)

say 'G2SelectData using SQL (value) as input...'
say 'SQL:' sql
'pause'
say
call time 'R'
retcode = g2selectdata(sql, data., reqrows)
say 'Selecting data    ' retcode time('R')

say 'DATA.0   =' data.0
say 'DATA.0.0 =' data.0.0
if retcode = 0 | retcode = 100 then
do r = 1 to data.0
   do c = 1 to data.0.0
      say 'DATA.'r'.'c '=' data.r.c '    length='length(data.r.c)
      end
   end
say copies('~', 78)

say 'G2SelectData using ''SQL'' as input...'
say 'SQL:' sql
'pause'
call time 'R'
retcode = g2selectdata('sql', data., reqrows)
say 'Selecting data    ' retcode time('R')

say 'DATA.0   =' data.0
say 'DATA.0.0 =' data.0.0
if retcode = 0 | retcode = 100 then
do r = 1 to data.0
   do c = 1 to data.0.0
      say 'DATA.'r'.'c '=' data.r.c '    length='length(data.r.c)
      end
   end
say copies('~', 78)

say 'G2SelectForm using SQL (value) as input...'
say 'SQL:' sql
'pause'
call time 'R'
retcode = g2selectform(sql, form.,,,,1100)
elapse = time('E')
say 'Return Code       ' retcode
say 'Execution time    ' time('E')
say
say 'Stem tot# elements' form.0
if retcode = 0 | retcode = 100 then
   do r = 1 to form.0
      say 'Element FORM.'r '=' form.r'    length='length(form.r)
      end
say copies('~', 78)

say 'G2SelectForm using ''SQL'' as input...'
say 'SQL:' sql
'pause'
call time 'R'
retcode = g2selectform('sql', form.,,,,1100)
elapse = time('E')
say 'Return Code       ' retcode
say 'Execution time    ' time('E')
say
say 'Stem tot# elements' form.0
if retcode = 0 | retcode = 100 then
   do r = 1 to form.0
      say 'Element FORM.'r '=' form.r'    length='length(form.r)
      end
say copies('~', 78)

say 'G2SelectOne using SQL (value) as input...'
say 'SQL:' sql
'pause'
call time 'R'
returned = g2selectone(sql)
elapse = time('E')
say 'SelectOne returns ' returned
say '           length ' length(returned)
say ' G2SQLCODE        ' g2sqlcode
say ' G2LONGRESULT     ' g2longresult'    length='length(g2longresult)
say 'Execution time    ' elapse / 1

if g2sqlcode \= 0 |,
   returned \= '' then do
   say
   call time 'R'
   say 'Commiting...'
   call g2commit
   say 'Execution time    ' time('E') / 1
   end
say copies('~', 78)

say 'G2SelectOne using ''SQL'' as input...'
say 'SQL:' sql
'pause'
call time 'R'
returned = g2selectone('sql')
elapse = time('E')
say 'SelectOne returns ' returned
say '           length ' length(returned)
say ' G2SQLCODE        ' g2sqlcode
say ' G2LONGRESULT     ' g2longresult'    length='length(g2longresult)
say 'Execution time    ' elapse / 1

if g2sqlcode \= 0 |,
   returned \= '' then do
   say
   call time 'R'
   say 'Commiting...'
   call g2commit
   say 'Execution time    ' time('E') / 1
   return /* returned value is not NULL */
   end

say
say 'Enter any character(s) to do the same query to replace NULL char.'
parse pull nullchar

say
call time 'R'
returned = g2selectone('sql', nullchar)
elapse = time('E')
say 'SelectOne returns ' returned
say '           length ' length(returned)
say ' G2SQLCODE        ' g2sqlcode
say ' G2LONGRESULT     ' g2longresult'    length='length(g2longresult)
say 'Execution time    ' elapse / 1
say
say copies('~', 78)
say center('*** TESTLONG TESTS COMPLETED ***', 78)
say
say copies('~', 78)

say
call time 'R'
say 'Commiting...'
call g2commit
say 'Execution time    ' time('E') / 1
return 0



error:
say 'Error detected...'
return 10

syntax:
say 'Syntax error detected...'
return 20

halt:
say 'Halt error detected...'
return 30

failure:
say 'Failure error detected...'
return 40
