/* Test of automation with Visual Source Safe
 * This routine recursively retrieves the contents of a Source Safe
 * project and checks them in to RCS, preserving check-in comments and labels.
 *
 * $Header: C:/ptjm/rexx/w32funcs/RCS/vss.rex 1.9 2002/01/02 21:22:04 pmcphee Rel $
 */

parse arg proj

proj = strip(proj)

call rxfuncadd 'w32loadfuncs', 'w32util', 'w32loadfuncs'
call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'

call w32loadfuncs
call sysloadfuncs

hnd = w32createobject('SourceSafe')

if hnd = 0 then do
 say "Couldn't connect to Source Safe -- time to go home."
 exit 1
 end

call w32callfunc hnd, 'open'

if rc then do
  say "Couldn't open source safe database:" w32olegeterror()
  call w32releaseobject hnd
  exit 1
  end

s = w32getproperty(hnd, 'DatabaseName')
if rc then
  say w32olegeterror()
else
  say 'Database:' s
s = w32getproperty(hnd, 'Username')
if rc then
  say w32olegeterror()
else
  say 'User:    ' s

say 'Project: ' proj

phnd = w32getsubobj(hnd, 'VSSItem', 's', proj)

if phnd = 0 then do
  say "Couldn't open project" proj':' w32olegeterror()
  call w32releaseobject hnd
  exit 1
  end

/* get the offset from GMT */
numeric digits 10
offset = time('o')/1000000

call setupIdentifiers phnd

/* directory() will work with Regina and IBM Rexx */
call doProject phnd, directory()

call w32releaseobject hnd
exit 0

/* set up identifiers -- this avoids calling getidsofnames repeatedly
 * in the inner loop */
setupIdentifiers: procedure expose id.
  parse arg phnd

  parse value w32olegetid(phnd, 'Name', 'Items', 'Type', 'Versions', 'Get') with ,
       id.itemName +6 +1 id.itemItems +6 +1 id.itemType +6 +1 id.itemVersions +6 +1 id.itemGet

  ihnd = w32getsubobj(phnd, id.itemItems)
  parse value w32olegetid(ihnd, 'Count', 'Item') with id.itemsCount +6 +1 id.itemsItem
  call w32releaseobject ihnd

  vhnd = w32getsubobj(phnd, id.itemVersions)
  ver = w32olenext(vhnd)

  parse value w32olegetid(ver, 'action', 'VSSItem', 'username', 'date', 'Comment', 'Label') ,
       with id.verAction +6 +1 id.verItem +6 +1 id.verUser +6 +1 ,
       id.verDate +6 +1 id.verComment +6 +1 id.verLabel

  call w32releaseobject ver, vhnd

  return

doProject: procedure expose offset id.
   phnd = arg(1)
   topdir = arg(2)

   /* this is the short form of the project name */
   pname = w32getproperty(phnd, id.itemName)
   pdir = topdir'/'pname
   call sysmkdir pdir
   call directory pdir
   call sysmkdir 'RCS'

   ihnd = w32getsubobj(phnd, id.itemItems)

   if ihnd = '' | ihnd = 0 then do
      say w32olegeterror()
      call w32olecleanup
      exit 1
      end

   do i = 1 to w32getproperty(ihnd, id.itemsCount)
      iihnd = w32getsubobj(ihnd, id.itemsItem, 'i', i)
      itype = w32getproperty(iihnd, id.itemType)
      if itype = 0 then call doProject iihnd, pdir
      else call doFile iihnd, pdir
     end

  call w32releaseobject ihnd, phnd
  'rcs -q -L RCS/*'
  call directory topdir
  return

doFile: procedure expose offset id.
  parse arg iihnd, pdir

  msgfile = '..\msgfile'
  call sysfiledelete msgfile

  iname = w32getproperty(iihnd, id.itemName)

  /* get handles to all the versions. Since we can only get these
   * form the newest to the oldest, but we want to process them in
   * the opposite order, we stick them in an array. */
  vhnd = w32getsubobj(iihnd, id.itemVersions)
  i = 0
  do until ver.i = 0
    i = i + 1
    ver.i = w32olenext(vhnd)
    end
  call w32releaseobject vhnd      
  ver.0 = i - 1

  do i = ver.0 to 1 by -1
    action = word(w32getproperty(ver.i, id.verAction), 1)

    /* this is going to be 'Created', 'Checked', 'Labeled', or 'Branched' */
    if action = 'Created' | action = 'Checked' then do
      viihnd = w32getsubobj(ver.i, id.verItem)
      call w32callfunc viihnd, id.itemGet, 's', pdir'/'iname
      user = w32getproperty(ver.i, id.verUser)

      /* fix the date so that it's always ascending */

      /* if you use m/d/y hh:mi:ss am/pm, pick this template */
      parse value w32getproperty(ver.i, id.verDate) with m'/'d'/'y h':'mi':'s ampm
      if h = 12 then h = 0
      if ampm = 'PM' then
	h = h + 12

      /* if you use d/m/y hh24:mi:ss, pick this template */
      /*
      parse value w32getproperty(ver.i, id.verDate) with d'/'m'/'y h':'mi':'s
      */

      /* normalise and convert to GMT */

      bdate = date('b', right(m,2,'0')'/'right(d,2,0)'/'y, 'u')
      stime = time('s', right(h,2,0)':'mi':'s, 'n') - offset

      if stime < 0 then do
	stime = stime + 84200
	bdate = bdate - 1
	end
      else if stime > 84200 then do
	stime = stime - 84200
	bdate = bdate + 1
      end

      date = date('s', bdate, 'b')
      cvtdate = substr(date, 1, 4)'/'substr(date,5,2)'/'substr(date,7,2) time('n', stime, 's')

      if i \= ver.0 & cvtdate <= oldcvtdate then do
        say 'adjust' cvtdate 'to' oldcvtdate 'plus 1 second'
	adjusted = 1
	msgtext = 'Original time was' cvtdate

	stime = oldstime + 1
	bdate = oldbdate
	if stime > 84200 then do
	  bdate = bdate+1
	  stime = stime - 84200
	  end

        date = date('s', bdate, 'b')
	cvtdate = substr(date, 1, 4)'/'substr(date,5,2)'/'substr(date,7,2) time('n', stime, 's')
        say 'ie' cvtdate

        end
      else
        adjusted = 0
      oldcvtdate = cvtdate
      oldstime = stime
      oldbdate = bdate

      call w32releaseobject viihnd
      call charout msgfile, w32getproperty(ver.i, id.verComment)
      if adjusted then call lineout msgfile, msgtext
      call stream msgfile, 'c', 'close'

      do until rc = 0

	 /* For the first revision, set up the RCS file with strict locking
	  * turned off. This means we don't have to lock the file for each
	  * revision, and rcs doesn't have to check whether the file is locked.
	  * The time saving is 5-10% of the run time. */
	 if action = 'Created' then
	   'rcs -q -i -U -t'msgfile iname

	 'ci -q -d"'cvtdate'" -w'user iname '<' msgfile

        if rc \= 0 then do
           say 'error on' iname'. Try again? [y]'
           pull resp
           if resp = 'N' then do
              call sysfiledelete iname
              rc = 0
              end
           end
        end


      call sysfiledelete msgfile
      end
    else if action = 'Labeled' then
      'rcs -q -n"'translate(w32getproperty(ver.i, id.verLabel),,'. :;,', "_")'":' iname
    else if action = 'Branched' then nop
    else
      say iname': unexpected action' action

    call w32releaseobject ver.i
    end

  call w32releaseobject iihnd
  return

