/* find services which log in as the user given in the argument */

arg owner .

if owner = '' then do
  say 'usage findservice DOMAIN\user'
  exit 1
  end

rcc = rxfuncadd('w32loadfuncs', 'w32util', 'w32loadfuncs')

if rcc then do
  say 'oops loading w32loadfuncs'
  exit 1
  end

call w32loadfuncs

servicekey = w32regopenkey('LOCAL_MACHINE', 'SYSTEM\CurrentControlSet\Services')

call w32RegEnumKey servicekey,,'KEYS.'

do i = 1 to keys.0
  hkey = w32regopenkey(servicekey, keys.i)
  thisowner = translate(w32regqueryvalue(hkey, 'ObjectName'))
  if thisowner = owner then do
    name = w32regqueryvalue(hkey, 'DisplayName')
    if name \= '' then
       say name '('keys.i')'
    else
       say keys.i
  end
  call w32regclosekey(hkey)
  end

call w32regclosekey(servicekey)

exit 0
