/* Define for DevHelp functions */

                                            /*   K   I   I   */
                                            /*   e   n   n   */
                                            /*   r   t   i   */
                                            /*   n   e   t   */
                                            /*   a   r       */
                                            /*   l   r       */
                                            /*       u       */
                                            /*       p       */
                                            /*       t       */
                                            /* ------------- */
#define DH_SchedClockAddr           0x00    /*   x        x  */
#define DH_DevDone                  0x01    /*   x   x       */
#define DH_Yeild                    0x02    /*   x           */
#define DH_TCYield                  0x03    /*   x           */
#define DH_Block                    0x04    /*   x           */
#define DH_Run                      0x05    /*   x   x       */
#define DH_SemRequest               0x06    /*   x           */
#define DH_SemClear                 0x07    /*   x   x       */
#define DH_SemHandle                0x08    /*   x   x       */
#define DH_PushReqPacket            0x09    /*   x           */
#define DH_PullReqPacket            0x0a    /*   x   x       */
#define DH_PullParticular           0x0b    /*   x   x       */
#define DH_SortReqPacket            0x0c    /*   x           */
#define DH_AllocReqPacket           0x0d    /*   x           */
#define DH_FreeReqPacket            0x0e    /*   x           */
#define DH_QueueInit                0x0f    /*   x   x    x  */
#define DH_QueueFlush               0x10    /*   x   x       */
#define DH_QueueWrite               0x11    /*   x   x       */
#define DH_QueueRead                0x12    /*   x   x       */
#define DH_Lock                     0x13    /*   x        x  */
#define DH_Unlock                   0x14    /*   x        x  */
#define DH_PhysToVirt               0x15    /*   x   x    x  */
#define DH_PhysToUVirt              0x16    /*   x        x  */
#define DH_VirtToPhys               0x17    /*   x        x  */
#define DH_AllocPhys                0x18    /*   x        x  */
#define DH_FreePhys                 0x19    /*   x        x  */
#define DH_SetRomVector             0x1a    /*   x        x  */
#define DH_SetIRQ                   0x1b    /*   x        x  */
#define DH_UnSetIRQ                 0x1c    /*   x   x    x  */
#define DH_SetTimer                 0x1d    /*   x        x  */
#define DH_ResetTimer               0x1e    /*   x   x    x  */
#define DH_MonitorCreate            0x1f    /*   x        x  */
#define DH_Register                 0x20    /*   x           */
#define DH_DeRegister               0x21    /*   x           */
#define DH_MonWrite                 0x22    /*   x   x       */
#define DH_MonFlush                 0x23    /*   x           */
#define DH_GetDOSVar                0x24    /*   x        x  */
#define DH_SendEvent                0x25    /*   x   x       */
#define DH_ROMCritSection           0x26    /*               */
#define DH_VerifyAccess             0x27    /*   x           */
#define DH_RAS                      0x28    /*   x           */
#define DH_AttachDD                 0x2a    /*   x        x  */
#define DH_InternalError            0x2b    /*   x   x    x  */
#define DH_AllocGDTSelector         0x2d    /*            x  */
#define DH_PhysToGDTSelector        0x2e    /*   x   x    x  */
#define DH_RealToProt               0x2f    /*   x   x       */
#define DH_ProtToReal               0x30    /*   x   x       */
#define DH_EOI                      0x31    /*       x    x  */
#define DH_UnPhysToVirt             0x32    /*   x   x    x  */
#define DH_UnsetIRQCount                0x33    /*   x   x    x  */
#define DH_GetLIDEntry              0x34    /*   x        x  */
#define DH_FreeLIDEntry             0x35    /*   x        x  */
#define DH_ABIOSCall                0x36    /*   x   x    x  */
#define DH_ABIOSCommonEntry         0x37    /*   x   x    x  */
#define DH_GetDeviceBlock           0x38    /*            x  */
#define DH_RegisterStackUsage       0x3a    /*            x  */
#define DH_VideoPause               0x3c    /*   x   x    x  */
#define DH_SAVE_MESSAGE             0x3d    /*            x  */
#define DH_RegisterDeviceClass      0x43    /*            x  */
#define DH_RegisterPDD              0x50    /*   x        x  */
#define DH_RegisterBeep             0x51    /*   x        x  */
#define DH_Beep                     0x52    /*   x   x    x  */
#define DH_FreeGDTSelector          0x53    /*   x        x  */
#define DH_PhysToGDTSel             0x54    /*   x        x  */
#define DH_VMLock                   0x55    /*   x   x    x  */
#define DH_VMUnlock                 0x56    /*   x        x  */
#define DH_VMAlloc                  0x57    /*   x        x  */
#define DH_VMFree                   0x58    /*   x        x  */
#define DH_VMProcessToGlobal        0x59    /*   x           */
#define DH_VMGlobalToProcess        0x5a    /*   x           */
#define DH_VirtToLin                0x5b    /*   x   x    x  */
#define DH_LinToGDTSelector         0x5c    /*   x   x    x  */
#define DH_GetDescInfo              0x5d    /*   x   *    x  */
#define DH_LinToPageList            0x5e    /*   x   x    x  */
#define DH_PageListToLin            0x5f    /*   x   x    x  */
#define DH_PageListToGDTSelector    0x60    /*   x   x    x  */
#define DH_RegisterTmrDD            0x61    /*            x  */
#define DH_AllocateCtxHook          0x63    /*   x        x  */
#define DH_FreeCtxHook              0x64    /*   x        x  */
#define DH_ArmCtxHook               0x65    /*   x   x    x  */
#define DH_VMSetMem                 0x66    /*   x        x  */
#define DH_OpenEventSem             0x67    /*   x           */
#define DH_CloseEventSem            0x68    /*   x           */
#define DH_PostEventSem             0x69    /*   x           */
#define DH_ResetEventSem            0x6a    /*   x           */
#define DH_DynamicAPI               0x6c    /*   x        x  */
#define DHGETDOSV_DEVICECLASSTABLE  14

PBYTE DevHelp_PhysToVirt( ULONG, USHORT ) ;
PBYTE DevHelp_VirtToPhys( PVOID VirtAdr ) ;
USHORT DevHelp_Beep( USHORT, USHORT ) ;
PBYTE DevHelp_VirtToLin( USHORT wSel, ULONG ulOffset ) ;
PBYTE DevHelp_PhysToUVirt( ULONG PhysAdr, USHORT len,
                  BYTE bType, USHORT wTag ) ;
PBYTE DevHelp_VMAlloc( ULONG ulPhysAdr, ULONG ulLen, ULONG ulFlags ) ;
UCHAR DevHelp_RealToProt( void ) ;
UCHAR DevHelp_ProtToReal( void ) ;
USHORT DevHelp_Block( ULONG, ULONG, UCHAR ) ;
UCHAR DevHelp_Run( ULONG ) ;
UCHAR far *DevHelp_GetDosVar(USHORT);
#if defined(TRACE) | defined(TRACE1)
void DevHelp_RAS( USHORT Major, USHORT Minor, USHORT TraceSize, PVOID TraceData);
#endif
void DevHelp_Yield(void);
USHORT DevHelp_RegisterDeviceClass(PVOID AddName, PVOID IorbEntry, USHORT code, USHORT subcode);
USHORT DevHelp_AllocGdtSel(PUSHORT outputsel ,USHORT countofselsneeded);
USHORT DevHelp_AllocPhys(ULONG size, USHORT abovebelow, PULONG returned);
USHORT DevHelp_PhysToGDT(ULONG physaddr, USHORT size, USHORT sel);
USHORT DevHelp_Settimer(USHORT handler);
USHORT DevHelp_Resettimer(USHORT handler);
USHORT DevHelp_TickCount(USHORT handler,USHORT count);
USHORT DevHelp_SetIRQ(USHORT handler,USHORT irqnum,BOOL Shared);
USHORT DevHelp_UnsetIRQ(USHORT irqnum);
USHORT DevHelp_EOI(USHORT irqnum);
ULONG  DevHelp_AllocCtxHook(USHORT function_addr_offset);
ULONG  DevHelp_ArmCtxHook(ULONG HookHandle,ULONG HookData);
ULONG  DevHelp_FreeCtxHook(ULONG HookHandle);
VOID   DevHelp_DisplayMsg( MSGTABLE far *);
