#define INCL_BASE
#define INCL_DOS
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <i86.h>
#include <os2.h>
#include <joyos2.h>
#include "ejoyos2.h"

HFILE hGame;
BOOL  enchanced_joystick_interface=FALSE;
GAME_EXT_CALIB calib;
GAME_EXT_DEADZONE deadzone;
GAME_EXT_CAPS caps;

void game_open()
{
    ULONG  action;
    APIRET rc;

    rc = DosOpen(
                 GAMEPDDNAME,
                 &hGame,
                 &action,
                 0,
                 FILE_READONLY,
                 FILE_OPEN,
                 OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,
                 NULL);

    if (rc != 0)
    {
        printf("no joystick found on system!\n");
        exit(1);
    }
}

void game_close()
{
    DosClose(hGame);
}

void game_check_version()
{
    ULONG version;
    ULONG version_len;
    APIRET rc;

    version_len = sizeof(ULONG);

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_GET_VERSION,
                     NULL, 0, NULL,
                     &version, version_len, &version_len);

    enchanced_joystick_interface=FALSE;

    if (version >= GAME_EXTVERSION)
    {
        enchanced_joystick_interface=TRUE;
    }
}

void game_ext_get_caps()
{
    ULONG capsparam_len;
    ULONG capsparam;
    ULONG caps_len;
    APIRET rc;

    caps_len = sizeof(GAME_EXT_CAPS);
    capsparam_len = sizeof(long);

    capsparam = 0; // read first joystick capabilities

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_CAPS,
                     &capsparam, capsparam_len, &capsparam_len,
                     &caps, caps_len, &caps_len);
}

void game_ext_get_info(long joy)
{
    GAME_EXT_INFO info;
    ULONG info_len;
    long this_joystick_nro;
    ULONG param_len;
    APIRET rc;

    info_len = sizeof(GAME_EXT_INFO);
    param_len = sizeof(long);

    this_joystick_nro = joy;

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_INFO,
                     &this_joystick_nro, param_len, &param_len,
                     &info, info_len, &info_len);
}

void game_ext_set_calib(long joy)
{
    ULONG calib_len;
    APIRET rc;

    calib.this_joystick_nro=joy;
    calib_len = sizeof(GAME_EXT_CALIB);

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_SET_CALIB,
                     &calib, calib_len, &calib_len,
                     NULL, 0, NULL);
}

void game_ext_get_calib(long joy)
{
    ULONG calib_len;
    long param;
    ULONG param_len;
    APIRET rc;

    param = joy;
    param_len = sizeof(long);

    calib_len = sizeof(GAME_EXT_CALIB);

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_CALIB,
                     &param, param_len, &param_len,
                     &calib, calib_len, &calib_len);
}

void game_ext_set_deadzone(long joy)
{
    ULONG deadzone_len;
    APIRET rc;

    deadzone.this_joystick_nro=joy;
    deadzone_len = sizeof(GAME_EXT_DEADZONE);

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_SET_DEADZONE,
                     &deadzone, deadzone_len, &deadzone_len,
                     NULL, 0, NULL);
}

void game_ext_get_deadzone(long joy)
{
    ULONG deadzone_len;
    long param;
    ULONG param_len;
    APIRET rc;

    param = joy;
    param_len = sizeof(long);

    deadzone_len = sizeof(GAME_EXT_DEADZONE);

    rc = DosDevIOCtl(hGame,
                     IOCTL_CAT_USER, GAME_EXT_GET_DEADZONE,
                     &param, param_len, &param_len,
                     &deadzone, deadzone_len, &deadzone_len);
}


void main()
{
    game_open();
    game_check_version();
    if (!enchanced_joystick_interface)
    {
        printf("Joystick driver doesn't support enchanced joystick i.face\n");
        game_close();
        exit(0);
    }

    game_ext_get_caps(0);

    if (caps.flags & JOYCAPS_NOTCONNECTED)
    {
        printf("Joystick is not connected!\n");
        game_close();
        exit(0);
    }

    printf("Configuring deadzones using calibration information\n\n");
    game_ext_get_calib(0);

    deadzone.x_dzone_lower=calib.xmin+((calib.xmax-calib.xmin)/4)*1;
    deadzone.x_dzone_upper=calib.xmin+((calib.xmax-calib.xmin)/4)*3;
    deadzone.y_dzone_lower=calib.ymin+((calib.ymax-calib.ymin)/4)*1;
    deadzone.y_dzone_upper=calib.ymin+((calib.ymax-calib.ymin)/4)*3;
    deadzone.z_dzone_lower=calib.zmin+((calib.zmax-calib.zmin)/4)*1;
    deadzone.z_dzone_upper=calib.zmin+((calib.zmax-calib.zmin)/4)*3;
    deadzone.r_dzone_lower=calib.rmin+((calib.rmax-calib.rmin)/4)*1;
    deadzone.r_dzone_upper=calib.rmin+((calib.rmax-calib.rmin)/4)*3;
    deadzone.u_dzone_lower=calib.umin+((calib.umax-calib.umin)/4)*1;
    deadzone.u_dzone_upper=calib.umin+((calib.umax-calib.umin)/4)*3;
    deadzone.v_dzone_lower=calib.vmin+((calib.vmax-calib.vmin)/4)*1;
    deadzone.v_dzone_upper=calib.vmin+((calib.vmax-calib.vmin)/4)*3;

    game_ext_set_deadzone(0);

    game_ext_get_deadzone(0);

    printf("calibration:\n");
    if (caps.flags & JOYCAPS_HASX)
        printf("x-axis min=%d center=%d max=%d\n", calib.xmin, calib.xcent, calib.xmax);
    if (caps.flags & JOYCAPS_HASY)
        printf("y-axis min=%d center=%d max=%d\n", calib.ymin, calib.ycent, calib.ymax);
    if (caps.flags & JOYCAPS_HASZ)
        printf("z-axis min=%d center=%d max=%d\n", calib.zmin, calib.zcent, calib.zmax);
    if (caps.flags & JOYCAPS_HASR)
        printf("r-axis min=%d center=%d max=%d\n", calib.rmin, calib.rcent, calib.rmax);
    if (caps.flags & JOYCAPS_HASU)
        printf("u-axis min=%d center=%d max=%d\n", calib.umin, calib.ucent, calib.umax);
    if (caps.flags & JOYCAPS_HASV)
        printf("v-axis min=%d center=%d max=%d\n", calib.vmin, calib.vcent, calib.vmax);

    printf("deadzones:\n");
    if (caps.flags & JOYCAPS_HASX)
        printf("x-axis upper=%d lower=%d\n", deadzone.x_dzone_lower, deadzone.x_dzone_upper);
    if (caps.flags & JOYCAPS_HASY)
        printf("y-axis upper=%d lower=%d\n", deadzone.y_dzone_lower, deadzone.y_dzone_upper);
    if (caps.flags & JOYCAPS_HASZ)
        printf("z-axis upper=%d lower=%d\n", deadzone.z_dzone_lower, deadzone.z_dzone_upper);
    if (caps.flags & JOYCAPS_HASR)
        printf("r-axis upper=%d lower=%d\n", deadzone.r_dzone_lower, deadzone.r_dzone_upper);
    if (caps.flags & JOYCAPS_HASU)
        printf("u-axis upper=%d lower=%d\n", deadzone.u_dzone_lower, deadzone.u_dzone_upper);
    if (caps.flags & JOYCAPS_HASV)
        printf("v-axis upper=%d lower=%d\n", deadzone.v_dzone_lower, deadzone.v_dzone_upper);

    game_close();
}
