extproc sh

#!/bin/sh
#
# ppmmargin - add a margin to a portable anymap
#
# Copyright (C) 1991 by Jef Poskanzer.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies and that both that
# copyright notice and this permission notice appear in supporting
# documentation.  This software is provided "as is" without express or
# implied warranty.

tmp1=/tmp/pnmm1$$
tmp2=/tmp/pnmm2$$
tmp3=/tmp/pnmm3$$
tmp4=/tmp/pnmm4$$
rm -f $tmp1 $tmp2 $tmp3 $tmp4

color="-gofigure"

# Parse args.
while true ; do
    case "$1" in
        -w* )
        color="-white"
        shift
        ;;
        -b* )
        color="-black"
        shift
        ;;
        -c* )
        shift
        if [ ! ${1-""} ] ; then
            echo "usage: $0 [-white|-black|-color <colorspec>] <size> [pnmfile]" 1>&2
            exit 1
        fi
        color="$1"
        shift
        ;;
        -* )
        echo "usage: $0 [-white|-black|-color <colorspec>] <size> [pnmfile]" 1>&2
        exit 1
        ;;
        * )
        break
        ;;
    esac
done

if [ ! ${1-""} ] ; then
    echo "usage: $0 [-white|-black|-color <colorspec>] <size> [pnmfile]" 1>&2
    exit 1
fi
size="$1"
shift

if [ ${2-""} ] ; then
    echo "usage: $0 [-white|-black|-color <colorspec>] <size> [pnmfile]" 1>&2
    exit 1
fi

# Capture input file in a tmp file, in case it's a pipe.
cat $@ > $tmp1

# Construct spacer files.
case "$color" in
    -gofigure )
    pnmcut 0 0 1 1 $tmp1 | pnmtile $size 1 > $tmp2
    ;;
    -white | -black )
    pbmmake $color $size 1 > $tmp2
    ;;
    * )
    ppmmake $color $size 1 > $tmp2
    ;;
esac
pnmflip -rotate90 $tmp2 > $tmp3

# Cat things together.
pnmcat -lr $tmp2 $tmp1 $tmp2 > $tmp4
pnmcat -tb $tmp3 $tmp4 $tmp3

# All done.
rm -f $tmp1 $tmp2 $tmp3 $tmp4
