#define INCL_WIN
#define INCL_DOS
#include <os2.h>

#include "dive.h"
#include "mglserver_internal.h"

#define TIMEOUT 5 // seconds before giving up on the MGL server daemon

#define MGLSC_WAKEUP_SEM_NAME "\\SEM32\\MGLS_PM_WAKEUP"
#define MGLSC_LISTENER_NAME   "\\QUEUES\\MGLS_CLIENT_LISTENER"

#define FOURCC_R565 0x35363552ul
#define FOURCC_LUT8 0x3854554cul
#define FOURCC_SCRN 0
#define WM_VRNENABLE 0x7f
#define WM_VRNDISABLE 0x7e

#define TEST_CLIENT_WIDTH  640
#define TEST_CLIENT_HEIGHT 480

struct MGLSC_state
{
        ULONG MGL_session, listener_thread, server_pid;
        void *shared_packet, *vidbuffer;
        HQUEUE command_queue, listener_queue;
        HEV client_wakeup;
        char isFullScreen;
        int width, height, depth;
        char autoBlitVidBufferOnRefresh;
        HDIVE diveinst;
        ULONG divebufnum, depthfourcc;
        HWND clientwin, framewin;
        SETUP_BLITTER BlSet;
} mglclient;

void MGLS_synchronous_command( int command, int packetsize, void *packet )
{
        ULONG junk;

        DosResetEventSem( mglclient.client_wakeup, &junk );
        if ( !mglclient.isFullScreen ) return;
	DosWriteQueue( mglclient.command_queue, command, packetsize, packet, 0 );
//        printf( "Wrote message %d to the command queue.\n", command );
        DosWaitEventSem( mglclient.client_wakeup, -1 );
//        printf( "Server responded to message.\n" );
}

void ClientListenerThread( void *unused )
{
	REQUESTDATA request;
        ULONG reqlen, information, rc, junk;
        char priority;

//        printf( "Client listener thread is alive.\n" );

        rc = DosReadQueue( mglclient.listener_queue, &request, &junk,
          (void **) &information, 0, 0, &priority, 0 );

        while ( !rc ) // While queue handle is valid
        {
                switch ( request.ulData )
                {
                        case MGLC_VIDEO_SWITCH_NOTIFICATION:
                                mglclient.isFullScreen = information;
//                                printf( "Video mode switch notification: %d\n", information );
                                if ( !mglclient.isFullScreen )
                                {
                                        DosPostEventSem( mglclient.client_wakeup );
                                } else {
                                        if ( mglclient.autoBlitVidBufferOnRefresh )
                                        {
/*                                                MGL_SERVER_BLIT_BUFFER_PACKET *bb = 
                                                mglclient.shared_packet;

                                                bb->left = 0;
                                                bb->right = mglclient.width;
                                                bb->top = 0;
                                                bb->bottom = mglclient.height;
                                                bb->destx = 0;
                                                bb->desty = 0;
                                                MGLS_synchronous_command( MGLS_BLIT_BUFFER,
                                                  sizeof(MGL_SERVER_BLIT_BUFFER_PACKET), bb ); */
                                        }
                                }
                        break;
                        case MGLC_KEYDOWN_NOTIFICATION:
                                if ( information == KB_esc )
                                {
                                        WinPostMsg( mglclient.framewin, WM_CLOSE, 0, 0 );
                                }
                                DosSelectSession( 0 );
                                // return to PM
                        break;
                        default:
                }
                rc = DosReadQueue( mglclient.listener_queue, &request, &junk, 
                  (void **) &information, 0, 0, &priority, 0 );
        }

//        printf( "Client listener thread is dead.  DosReadQueue rc=%d.\n", rc );

        DosPostEventSem( mglclient.client_wakeup );
        // Tell the main thread that we're done.

        _endthread();
}

int MGLSC_MGL_init( void )
{
        ULONG rc, i;
        STARTDATA sd;
        RESULTCODES res;
        MGL_SERVER_INIT_PACKET *ip;
        MGL_SERVER_INIT_VIDMODE_PACKET *iv;
        MGL_SERVER_INIT_BUFFER_PACKET *ib;

        rc = DosCreateEventSem( MGLSC_WAKEUP_SEM_NAME, 
          &(mglclient.client_wakeup), DC_SEM_SHARED, FALSE );

        if ( rc )
        {
                return 1;
        }

	rc = DosOpenQueue( &(mglclient.server_pid), &(mglclient.command_queue),
          MGLS_COMMAND_QUEUE_NAME );

	if ( !rc )
        {
		DosCloseQueue( mglclient.command_queue );
                DosCloseEventSem( mglclient.client_wakeup );
                return 2;
        }
        // Daemon is already running and is probably owned by someone else.
        // Don't start up.

        if ( rc != 343 )
        {
                return 3;
        }
        // DosOpenQueue failed for some other wacky reason.

        sd.Length = 32;
	sd.Related = 1;
	sd.FgBg = SSF_FGBG_BACK;
	sd.TraceOpt = SSF_TRACEOPT_NONE;
	sd.PgmTitle = NULL;
	sd.PgmName = "mglserver.exe";
      	sd.PgmInputs = NULL;
	sd.TermQ = NULL;
	sd.Environment = 0;
	sd.InheritOpt = SSF_INHERTOPT_PARENT;
	sd.SessionType = SSF_TYPE_FULLSCREEN;

        rc = DosStartSession( &sd, &(mglclient.MGL_session), &mglclient.server_pid );

        if ( rc ) { 
		DosCloseQueue( mglclient.command_queue );
                DosCloseEventSem( mglclient.client_wakeup );
                return 4;
        }

        for (i=0; i<TIMEOUT; ++i)
        {
                DosSleep(1000);
	        rc = DosOpenQueue( &(mglclient.server_pid), &(mglclient.command_queue),
                  MGLS_COMMAND_QUEUE_NAME );
                if ( !rc ) break;
        }

        if ( rc ) return 5;

        rc = DosAllocSharedMem( &(mglclient.shared_packet), NULL, 
          MGLS_BIGGEST_PACKET_SIZE, OBJ_GETTABLE | PAG_READ | PAG_WRITE | PAG_COMMIT );

	if ( rc )
        {
		DosCloseQueue( mglclient.command_queue );
                DosCloseEventSem( mglclient.client_wakeup );
                return 6;
	}

        rc = DosCreateQueue( &(mglclient.listener_queue), QUE_FIFO, MGLSC_LISTENER_NAME );
        if ( rc )
        {
		DosCloseQueue( mglclient.command_queue );
                DosCloseEventSem( mglclient.client_wakeup );
                DosFreeMem( mglclient.shared_packet );
                return 7;
        }

        ip = mglclient.shared_packet;
        strcpy( ip->client_semaphore_name, MGLSC_WAKEUP_SEM_NAME );
        strcpy( ip->input_queue_name, MGLSC_LISTENER_NAME );

        mglclient.listener_thread = _beginthread( 
          ClientListenerThread, NULL, 16384, NULL );

        // Fire off the listener thread to get feedback from the
        // daemon.  Needed for mode switch notification and input
        // device notifications.

        rc = DosSelectSession( mglclient.MGL_session );
        if ( rc )
        {
                return 8;
        }

        mglclient.isFullScreen = 1;

        MGLS_synchronous_command( MGLS_INIT, sizeof(MGL_SERVER_INIT_PACKET), ip );

        iv = mglclient.shared_packet;
        iv->width = mglclient.width;
        iv->height = mglclient.height;
        iv->depth = mglclient.depth;
        iv->flags = MGLS_VMIFLAG_USE_CUSTOM;

        MGLS_synchronous_command( MGLS_INIT_VIDMODE, 
          sizeof(MGL_SERVER_INIT_VIDMODE_PACKET), iv );

        if ( !(iv->flags & MGLS_VMOFLAG_SUCCESS) ) return 9;

        ib = mglclient.shared_packet;
        ib->buffer = mglclient.vidbuffer;
        ib->width = mglclient.width;
        ib->height = mglclient.height;
        ib->depth = mglclient.depth;

        MGLS_synchronous_command( MGLS_INIT_BUFFER, 
          sizeof(MGL_SERVER_INIT_BUFFER_PACKET), ib );
        // MGL now has a memory device context associated with this buffer.
        // We're ready to blit!

        mglclient.autoBlitVidBufferOnRefresh = 1;

        return 0;
}

void MGLS_shutdown( void )
{
        ULONG junk;

        while ( !mglclient.isFullScreen )
        {
          DosSelectSession( mglclient.MGL_session );
          DosSleep( 250 );
        }

        MGLS_synchronous_command( MGLS_FREE_BUFFER,
          sizeof(MGL_SERVER_FREE_BUFFER_PACKET), mglclient.shared_packet );

        MGLS_synchronous_command( MGLS_SHUTDOWN_VIDMODE,
          sizeof(MGL_SERVER_SHUTDOWN_VIDMODE_PACKET), mglclient.shared_packet );

        MGLS_synchronous_command( MGLS_SHUTDOWN,
          sizeof(MGL_SERVER_SHUTDOWN_PACKET), mglclient.shared_packet );

        DosFreeMem( mglclient.shared_packet );
        DosFreeMem( mglclient.vidbuffer );
        DosCloseQueue( mglclient.command_queue );
        DosCloseQueue( mglclient.listener_queue );

        DosWaitEventSem( mglclient.client_wakeup, -1 );
        // Wait for listener thread to exit gracefully.

        DosCloseEventSem( mglclient.client_wakeup );

        DosSelectSession( 0 );
}

#define maker565( r, g, b ) (unsigned short) (((unsigned short)(b)>>3) | ((unsigned short)(g)&0x00fc)<<3 | ((unsigned short)(r)&0x00f8)<<8)

MRESULT EXPENTRY DualModePM(HWND win, ULONG message, MPARAM mp1, MPARAM mp2)
{
        static char MGLup = 0;
        static char bmpver = 0, vrn_enabled = 0;
        static ULONG err;
        static HPS hps;
        static HRGN hrgn;
        static RGNRECT rgnCtl;
        static RECTL rcls[50];
        static SWP swp;
        static POINTL pointl;

	switch ( message )
        {
		case WM_CREATE:
                {
                        MGLup = 0;
                        mglclient.autoBlitVidBufferOnRefresh = 0;

//                        printf( "Creating DIVE instance..." );
                        err = DiveOpen( &(mglclient.diveinst), FALSE, NULL );
			if ( err ) {
				printf( "failed!  DiveOpen rc = %ld.\n",err );
				return MRFROMSHORT(-1);
			}
//			printf( "succeeded.\nAllocating DIVE image buffer handle..." );

			err = DiveAllocImageBuffer( mglclient.diveinst, 
                          &(mglclient.divebufnum), mglclient.depthfourcc,
                          mglclient.width, mglclient.height, 
                          mglclient.width * (mglclient.depth / 8), 
                          mglclient.vidbuffer );

			if ( err ) {
//				printf( "failed! DiveAllocImageBuffer rc = %ld.\n", err );
				DiveClose( mglclient.diveinst );
				return MRFROMSHORT(-1);
			}
//                        printf( "success.\n" );
	                WinPostMsg(win, WM_TIMER, 0L, 0L);
                        WinStartTimer( WinQueryAnchorBlock(win), win, 0, 5000 );
                }
                break;
                case WM_TIMER:
                {
                        MGL_SERVER_BLIT_BUFFER_PACKET *bb = mglclient.shared_packet;
                        unsigned short *vidbuffer = mglclient.vidbuffer;
                        int i, j;

                        DosWriteQueue( mglclient.command_queue, MGLS_EVENT_FLUSH, 0, NULL, 0 );
                        bmpver = 1 - bmpver;

                        switch ( bmpver )
                        {
                                case 0:
                                        for ( i=0; i<TEST_CLIENT_HEIGHT; ++i )
                                        {
                                                for ( j=0; j<TEST_CLIENT_WIDTH; ++j )
                                                {
                                                        vidbuffer[ (i*TEST_CLIENT_WIDTH)+j ] = maker565( (i*255) / TEST_CLIENT_HEIGHT, ((i+j)*255 / (TEST_CLIENT_WIDTH + TEST_CLIENT_HEIGHT)), (j*255) / TEST_CLIENT_WIDTH );
                                                }
                                        }
                                break;
                                case 1:
                                        for ( i=0; i<TEST_CLIENT_HEIGHT; ++i )
                                        {
                                                for ( j=0; j<TEST_CLIENT_WIDTH; ++j )
                                                {
                                                        vidbuffer[ (i*TEST_CLIENT_WIDTH)+j ] = maker565( (j*255) / TEST_CLIENT_WIDTH, ((i+j)*255 / (TEST_CLIENT_WIDTH+TEST_CLIENT_HEIGHT)), (i*255) / TEST_CLIENT_HEIGHT );
                                                }
                                        }
                                break;
                        }

                        if ( mglclient.isFullScreen )
                        {
                                bb->left = 0;
                                bb->right = mglclient.width;
                                bb->top = 0;
                                bb->bottom = mglclient.height;
                                bb->destx = 0;
                                bb->desty = 0;
                                MGLS_synchronous_command( MGLS_BLIT_BUFFER,
                                  sizeof(MGL_SERVER_BLIT_BUFFER_PACKET), bb );
                        } else {
			        DiveBlitImage( mglclient.diveinst, mglclient.divebufnum, 
                                  DIVE_BUFFER_SCREEN );
                        }
                }
                break;
                case WM_CHAR:
                        if ( !MGLup )
                        {
                                if ( MGLSC_MGL_init() ) return FALSE;
                                MGLup = 1;
                        } else {
                                DosSelectSession( mglclient.MGL_session );
                        }
                break;
                case WM_CLOSE:
                        WinStopTimer( WinQueryAnchorBlock(win), win, 0 );

                        DiveFreeImageBuffer( mglclient.diveinst, mglclient.divebufnum );
                        DiveClose( mglclient.diveinst );

                        if ( MGLup )
                        {
                                MGLS_shutdown();
                        }
                break;
                case WM_PAINT:
                        if ( vrn_enabled )
                        {
                                err = DiveBlitImage( mglclient.diveinst, 
                                  mglclient.divebufnum, DIVE_BUFFER_SCREEN );
//                                if ( err ) printf( "DIVE blit error %d.\n", err );
                        }
                break;
		case WM_VRNENABLE:
			hps=WinGetPS(win);
			if ( hps == 0 ) { err=1; break; }
			hrgn=GpiCreateRegion(hps, 0L, NULL);
			if (hrgn) {
				err = WinQueryVisibleRegion(win, hrgn);
				rgnCtl.ircStart=0;
				rgnCtl.crc=50;
				rgnCtl.ulDirection=RECTDIR_LFRT_TOPBOT;
				err = GpiQueryRegionRects(hps, hrgn, NULL, &rgnCtl, rcls);
				if ( err ) { 
					err = 0; 
					WinQueryWindowPos(win, &swp);
					pointl.x=swp.x;
					pointl.y=swp.y;
					WinMapWindowPoints(WinQueryWindow( win, QW_PARENT ), HWND_DESKTOP, (POINTL*)&pointl, 1);
					mglclient.BlSet.ulStructLen = sizeof( SETUP_BLITTER );
					mglclient.BlSet.fInvert = 0;
					mglclient.BlSet.fccSrcColorFormat = mglclient.depthfourcc;
					mglclient.BlSet.ulSrcWidth = mglclient.width;
					mglclient.BlSet.ulSrcHeight = mglclient.height;
					mglclient.BlSet.ulSrcPosX = 0;
					mglclient.BlSet.ulSrcPosY = 0;
					mglclient.BlSet.ulDitherType = 1;
					mglclient.BlSet.fccDstColorFormat = FOURCC_SCRN;
					mglclient.BlSet.ulDstWidth=swp.cx;
					mglclient.BlSet.ulDstHeight=swp.cy;
					mglclient.BlSet.lDstPosX = 0;
					mglclient.BlSet.lDstPosY = 0;
					mglclient.BlSet.lScreenPosX=pointl.x;
					mglclient.BlSet.lScreenPosY=pointl.y;
					mglclient.BlSet.ulNumDstRects=rgnCtl.crcReturned;
					mglclient.BlSet.pVisDstRects=rcls;
					if ( rgnCtl.crcReturned == 0 ) { 
						DiveSetupBlitter( mglclient.diveinst, NULL );
						GpiDestroyRegion(hps, hrgn);
                                                WinReleasePS( hps );
						return MRFROMSHORT(-1);
					}
					err = DiveSetupBlitter( mglclient.diveinst,
                                          &(mglclient.BlSet) );
					if ( err ) {
//                                                printf( "Blitter setup error %d.\n", err );
                                                return MRFROMSHORT(-1);
                                        }
//                                        printf( "Blitter setup success.\n" );
					GpiDestroyRegion(hps, hrgn);
                                        vrn_enabled = 1;
				}
			}
			WinReleasePS( hps );
		break;
                case WM_VRNDISABLE:
                        DiveSetupBlitter( mglclient.diveinst, NULL );
                        vrn_enabled = 0;
                break;
        }

        return WinDefWindowProc( win, message, mp1, mp2 );
}

void MGLSC_init( int width, int height, int depth )
{
	HAB ab;
	HMQ messq;
	QMSG qmsg;
	ULONG frameflgs= FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER | 
	    FCF_MINMAX | FCF_SHELLPOSITION | FCF_TASKLIST;

        memset( &mglclient, 0, sizeof( mglclient ) );

        switch ( depth )
        {
                case 8:   mglclient.depthfourcc = FOURCC_LUT8; break;
                case 16:  mglclient.depthfourcc = FOURCC_R565; break;
                default:  return;  // Unsupported depth;
        }

        mglclient.width = width;
        mglclient.height = height;
        mglclient.depth = depth;

        mglclient.isFullScreen = 0;

        DosAllocSharedMem( &(mglclient.vidbuffer), NULL, 
          width * height * (depth/8), OBJ_GETTABLE | PAG_READ | PAG_WRITE | PAG_COMMIT );

	ab = WinInitialize( 0 );

	messq = WinCreateMsgQueue( ab, 0 );

	WinRegisterClass( ab, "DualMode Main window", DualModePM, 
	  CS_SIZEREDRAW | CS_MOVENOTIFY, 0 );
        
	mglclient.framewin = WinCreateStdWindow( HWND_DESKTOP, WS_VISIBLE | WS_ANIMATE,
	    &frameflgs, "DualMode Main window", "DualMode MGL/DIVE test",
	    0, 0, 1, &(mglclient.clientwin) );

        WinSetVisibleRegionNotify( mglclient.clientwin, TRUE );
	WinPostMsg(mglclient.framewin, WM_VRNENABLE, 0L, 0L);

	while (WinGetMsg (ab, &qmsg, NULLHANDLE, 0, 0)) WinDispatchMsg (ab, &qmsg);

	WinDestroyWindow( mglclient.framewin );

	WinDestroyMsgQueue( messq );

	WinTerminate( ab );
}

int main( void )
{
        MGLSC_init( TEST_CLIENT_WIDTH, TEST_CLIENT_HEIGHT, 16 );
//        printf( "Done.\n" );
        fflush(stdout);

        return 0;
}

